/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.minidns.source;

import github.scarsz.discordsrv.dependencies.minidns.DnsCache;
import github.scarsz.discordsrv.dependencies.minidns.MiniDnsFuture;
import github.scarsz.discordsrv.dependencies.minidns.dnsmessage.DnsMessage;
import github.scarsz.discordsrv.dependencies.minidns.dnsqueryresult.DnsQueryResult;
import github.scarsz.discordsrv.dependencies.minidns.source.DnsDataSource;
import java.io.IOException;
import java.net.InetAddress;

public abstract class AbstractDnsDataSource
implements DnsDataSource {
    protected int udpPayloadSize = 1024;
    protected int timeout = 5000;
    private DnsCache cache;
    private QueryMode queryMode = QueryMode.dontCare;

    @Override
    public abstract DnsQueryResult query(DnsMessage var1, InetAddress var2, int var3) throws IOException;

    @Override
    public MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage message, InetAddress address, int port, DnsDataSource.OnResponseCallback onResponseCallback) {
        DnsQueryResult result;
        MiniDnsFuture.InternalMiniDnsFuture<DnsQueryResult, IOException> future = new MiniDnsFuture.InternalMiniDnsFuture<DnsQueryResult, IOException>();
        try {
            result = this.query(message, address, port);
        }
        catch (IOException e) {
            future.setException(e);
            return future;
        }
        future.setResult(result);
        return future;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be greater than zero");
        }
        this.timeout = timeout;
    }

    @Override
    public int getUdpPayloadSize() {
        return this.udpPayloadSize;
    }

    public void setUdpPayloadSize(int udpPayloadSize) {
        if (udpPayloadSize <= 0) {
            throw new IllegalArgumentException("UDP payload size must be greater than zero");
        }
        this.udpPayloadSize = udpPayloadSize;
    }

    protected final void cacheResult(DnsMessage request, DnsQueryResult response) {
        DnsCache activeCache = this.cache;
        if (activeCache == null) {
            return;
        }
        activeCache.put(request, response);
    }

    public void setQueryMode(QueryMode queryMode) {
        if (queryMode == null) {
            throw new IllegalArgumentException();
        }
        this.queryMode = queryMode;
    }

    public QueryMode getQueryMode() {
        return this.queryMode;
    }

    public static enum QueryMode {
        dontCare,
        udpTcp,
        tcp;

    }
}

