/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.simpleast.core.parser;

import github.scarsz.discordsrv.dependencies.simpleast.core.ParseException;
import github.scarsz.discordsrv.dependencies.simpleast.core.node.Node;
import github.scarsz.discordsrv.dependencies.simpleast.core.parser.ParseSpec;
import github.scarsz.discordsrv.dependencies.simpleast.core.parser.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;

public class Parser<R, T extends Node<R>, S> {
    private final List<Rule<R, T, S>> rules = new ArrayList<Rule<R, T, S>>();
    private final boolean enableDebugging;

    public Parser(boolean enableDebugging) {
        this.enableDebugging = enableDebugging;
    }

    public Parser() {
        this.enableDebugging = false;
    }

    public Parser<R, T, S> addRule(Rule<R, T, S> rule) {
        this.rules.add(rule);
        return this;
    }

    public Parser<R, T, S> addRules(Collection<Rule<R, T, S>> rules) {
        this.rules.addAll(rules);
        return this;
    }

    public Parser<R, T, S> removeRule(Rule<R, T, S> rule) {
        this.rules.remove(rule);
        return this;
    }

    public Parser<R, T, S> removeRules(Collection<Rule<R, T, S>> rules) {
        this.rules.removeAll(rules);
        return this;
    }

    public List<Rule<R, T, S>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<T> parse(CharSequence source) {
        return this.parse(source, null);
    }

    public List<T> parse(CharSequence source, S initialSource) {
        return this.parse(source, initialSource, this.rules);
    }

    public List<T> parse(CharSequence source, S initialState, List<Rule<R, T, S>> rules) {
        return this.parse(source, initialState, rules, this.enableDebugging);
    }

    public List<T> parse(CharSequence source, S initialState, List<Rule<R, T, S>> rules, boolean enableDebugging) {
        ParseSpec builder;
        if (rules == null) {
            rules = this.rules;
        }
        Stack<ParseSpec<R, T, S>> remainingParses = new Stack<ParseSpec<R, T, S>>();
        Node topLevelRootNode = new Node<R>(){};
        String lastCapture = null;
        if (source != null && !source.toString().isEmpty()) {
            remainingParses.add(new ParseSpec(topLevelRootNode, initialState, 0, source.length()));
        }
        while (!remainingParses.isEmpty() && (builder = (ParseSpec)remainingParses.pop()).getStartIndex() < builder.getEndIndex()) {
            CharSequence inspectionSource = source.subSequence(builder.getStartIndex(), builder.getEndIndex());
            int offset = builder.getStartIndex();
            boolean foundRule = false;
            for (Rule rule : rules) {
                Matcher matcher = rule.match(inspectionSource, lastCapture, builder.getState());
                if (matcher == null) {
                    if (!enableDebugging) continue;
                    System.out.println("MISS: with rule with pattern: " + rule.getMatcher().pattern().toString() + " to source: " + source);
                    continue;
                }
                if (enableDebugging) {
                    System.out.println("MATCH: with rule with pattern: " + rule.getMatcher().pattern().toString() + " to source: " + source + " with match: " + matcher.toMatchResult());
                }
                foundRule = true;
                int matcherSourceEnd = matcher.end() + offset;
                ParseSpec<R, T, S> newBuilder = rule.parse(matcher, this, builder.getState());
                Object parent = builder.getRoot();
                ((Node)parent).addChild(newBuilder.getRoot());
                if (matcherSourceEnd != builder.getEndIndex()) {
                    remainingParses.push(ParseSpec.createNonterminal(parent, builder.getState(), matcherSourceEnd, builder.getEndIndex()));
                }
                if (!newBuilder.isTerminal()) {
                    newBuilder.applyOffset(offset);
                    remainingParses.push(newBuilder);
                }
                try {
                    lastCapture = matcher.group(0);
                    break;
                }
                catch (Throwable throwable) {
                    throw new ParseException("matcher found no matches", source, throwable);
                }
            }
            if (foundRule) continue;
            throw new ParseException("failed to find rule to match source", inspectionSource);
        }
        return topLevelRootNode.getChildren();
    }
}

