/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.OnlineStatus;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Activity;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ISnowflake;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.format.TextColor;
import github.scarsz.discordsrv.objects.managers.AccountLinkManager;
import github.scarsz.discordsrv.objects.managers.link.JdbcAccountLinkManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderAPIExpansion
extends PlaceholderExpansion {
    private long lastIssue = -1L;
    private static final Pattern SPECIFIC_ROLE_PATTERN = Pattern.compile("role_(\\d+)_(\\w+)");

    @Nullable
    public String onRequest(@Nullable OfflinePlayer player, @NotNull String identifier) {
        Role topRole;
        if (!DiscordSRV.isReady) {
            return "...";
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            return "";
        }
        Set onlineMembers = mainGuild.getMemberCache().stream().filter(member -> member.getOnlineStatus() != OnlineStatus.OFFLINE).collect(Collectors.toSet());
        Set onlineMemberIds = onlineMembers.stream().map(ISnowflake::getId).collect(Collectors.toSet());
        AccountLinkManager accountLinkManager = DiscordSRV.getPlugin().getAccountLinkManager();
        Supplier<Set> linkedAccounts = () -> {
            if (accountLinkManager instanceof JdbcAccountLinkManager && Bukkit.isPrimaryThread()) {
                long currentTime = System.currentTimeMillis();
                if (this.lastIssue + TimeUnit.SECONDS.toMillis(10L) < currentTime) {
                    DiscordSRV.warning("The %discordsrv_linked_online% placeholder was requested via PlaceholderAPI on the main thread while JDBC is enabled, this is unsupported");
                    this.lastIssue = currentTime;
                }
                return Collections.emptySet();
            }
            return accountLinkManager.getLinkedAccounts().keySet();
        };
        switch (identifier) {
            case "guild_id": {
                return mainGuild.getId();
            }
            case "guild_name": {
                return mainGuild.getName();
            }
            case "guild_icon_id": {
                return this.orEmptyString(mainGuild.getIconId());
            }
            case "guild_icon_url": {
                return this.orEmptyString(mainGuild.getIconUrl());
            }
            case "guild_splash_id": {
                return this.orEmptyString(mainGuild.getSplashId());
            }
            case "guild_splash_url": {
                return this.orEmptyString(mainGuild.getSplashUrl());
            }
            case "guild_owner_effective_name": {
                return this.applyOrEmptyString(mainGuild.getOwner(), Member::getEffectiveName);
            }
            case "guild_owner_nickname": {
                return this.applyOrEmptyString(mainGuild.getOwner(), Member::getNickname);
            }
            case "guild_owner_game_name": {
                return this.applyOrEmptyString(mainGuild.getOwner(), member -> member.getActivities().stream().findFirst().map(Activity::getName).orElse(""));
            }
            case "guild_owner_game_url": {
                return this.applyOrEmptyString(mainGuild.getOwner(), member -> member.getActivities().stream().findFirst().map(Activity::getUrl).orElse(""));
            }
            case "guild_bot_effective_name": {
                return mainGuild.getSelfMember().getEffectiveName();
            }
            case "guild_bot_nickname": {
                return this.orEmptyString(mainGuild.getSelfMember().getNickname());
            }
            case "guild_bot_game_name": {
                return this.applyOrEmptyString(mainGuild.getSelfMember(), member -> member.getActivities().stream().findFirst().map(Activity::getName).orElse(""));
            }
            case "guild_bot_game_url": {
                return this.applyOrEmptyString(mainGuild.getSelfMember(), member -> member.getActivities().stream().findFirst().map(Activity::getUrl).orElse(""));
            }
            case "guild_members_online": {
                return String.valueOf(onlineMembers.size());
            }
            case "guild_members_total": {
                return String.valueOf(mainGuild.getMembers().size());
            }
            case "linked_online": {
                return String.valueOf(linkedAccounts.get().stream().filter(onlineMemberIds::contains).count());
            }
            case "linked_total": {
                return String.valueOf(accountLinkManager.getLinkedAccountCount());
            }
        }
        Matcher rolePlaceholderMatcher = SPECIFIC_ROLE_PATTERN.matcher(identifier);
        if (rolePlaceholderMatcher.matches()) {
            String roleId = rolePlaceholderMatcher.group(1);
            Object role = DiscordUtil.getRole(roleId);
            String subPlaceholder = rolePlaceholderMatcher.group(2);
            if (role == null) {
                return "";
            }
            switch (subPlaceholder) {
                case "name": {
                    return role.getName();
                }
                case "color_hex": {
                    return this.getHex(role.getColorRaw());
                }
                case "color_code": {
                    String legacy = MessageUtil.toLegacy(Component.text(0).color(TextColor.color(role.getColorRaw())));
                    return legacy.substring(0, legacy.length() - 1);
                }
            }
        }
        if (player == null) {
            return "";
        }
        String userId = Bukkit.isPrimaryThread() ? accountLinkManager.getDiscordIdFromCache(player.getUniqueId()) : accountLinkManager.getDiscordId(player.getUniqueId());
        switch (identifier) {
            case "user_id": {
                return this.orEmptyString(userId);
            }
            case "user_islinked": {
                return this.getBoolean(userId != null);
            }
        }
        User user = DiscordUtil.getUserById(userId);
        if (user == null) {
            return "";
        }
        switch (identifier) {
            case "user_name": {
                return user.getName();
            }
            case "user_tag": {
                return user.getAsTag();
            }
        }
        Member member2 = mainGuild.getMember(user);
        if (member2 == null) {
            return "";
        }
        switch (identifier) {
            case "user_effective_name": {
                return member2.getEffectiveName();
            }
            case "user_nickname": {
                return this.orEmptyString(member2.getNickname());
            }
            case "user_online_status": {
                return member2.getOnlineStatus().getKey();
            }
            case "user_game_name": {
                return member2.getActivities().stream().findFirst().map(Activity::getName).orElse("");
            }
            case "user_game_url": {
                return member2.getActivities().stream().findFirst().map(Activity::getUrl).orElse("");
            }
            case "user_boost_status": {
                return this.getBoolean(member2.getTimeBoosted() != null);
            }
        }
        if (member2.getRoles().isEmpty()) {
            return "";
        }
        Role topSelectedRole = DiscordSRV.getPlugin().getTopSelectedRole(member2);
        if (topSelectedRole != null) {
            switch (identifier) {
                case "user_top_selected_role_id": {
                    return topSelectedRole.getId();
                }
                case "user_top_selected_role_name": {
                    return topSelectedRole.getName();
                }
                case "user_top_selected_role_color_hex": {
                    return this.applyOrEmptyString(topSelectedRole.getColorRaw(), this::getHex);
                }
                case "user_top_selected_role_color_code": {
                    String legacy = MessageUtil.toLegacy(Component.text(0).color(TextColor.color(topSelectedRole.getColorRaw())));
                    return legacy.substring(0, legacy.length() - 1);
                }
            }
        }
        if ((topRole = DiscordUtil.getTopRole(member2)) != null) {
            switch (identifier) {
                case "user_top_role_id": {
                    return topRole.getId();
                }
                case "user_top_role_name": {
                    return topRole.getName();
                }
                case "user_top_role_color_hex": {
                    return this.applyOrEmptyString(topRole.getColorRaw(), this::getHex);
                }
                case "user_top_role_color_code": {
                    String legacy = MessageUtil.toLegacy(Component.text(0).color(TextColor.color(topRole.getColorRaw())));
                    return legacy.substring(0, legacy.length() - 1);
                }
            }
        }
        return null;
    }

    private String getHex(int color) {
        return String.format("#%02x%02x%02x", (color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    private <T> String applyOrEmptyString(T input, Function<T, String> function) {
        if (input == null) {
            return "";
        }
        String output = function.apply(input);
        return this.orEmptyString(output);
    }

    private String orEmptyString(String input) {
        return StringUtils.isNotBlank(input) ? input : "";
    }

    private String getBoolean(boolean input) {
        return input ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    public String getIdentifier() {
        return "discordsrv";
    }

    public String getAuthor() {
        return DiscordSRV.getPlugin().getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return DiscordSRV.getPlugin().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }
}

