/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.util.PluginUtil;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public interface PluginHook
extends Listener {
    public Plugin getPlugin();

    default public boolean isEnabled() {
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            return false;
        }
        if (!plugin.isEnabled()) {
            DiscordSRV.debug("Plugin hook " + this.getClass().getName() + " (" + plugin.getName() + ") not enabled due to the plugin being disabled");
            return false;
        }
        if (!PluginUtil.pluginHookIsEnabled(this.getPlugin().getName())) {
            DiscordSRV.debug("Plugin hook " + this.getClass().getName() + " is disabled because " + plugin.getName() + " is disabled via the configuration");
            return false;
        }
        return true;
    }

    default public void hook() {
    }
}

