/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks;

import ch.njol.skript.ScriptLoader;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.util.PluginUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SkriptHook {
    public static Set<String> getSkripts() {
        HashSet<String> scripts = new HashSet<String>();
        if (!PluginUtil.checkIfPluginEnabled("skript")) {
            scripts.add("skript not found/enabled");
            return scripts;
        }
        try {
            for (File file : ScriptLoader.getLoadedFiles()) {
                boolean cancelsChatEvents = false;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    boolean treeIsOnChat = false;
                    while ((line = reader.readLine()) != null) {
                        if (StringUtils.isBlank(line)) continue;
                        if (!StringUtils.isWhitespace(line.substring(0, 1))) {
                            treeIsOnChat = StringUtils.startsWithIgnoreCase(line.trim(), "on chat");
                        }
                        if (!treeIsOnChat || !StringUtils.startsWithIgnoreCase(line.trim(), "cancel")) continue;
                        cancelsChatEvents = true;
                        break;
                    }
                }
                scripts.add(file.getName() + (cancelsChatEvents ? " [CANCELS CHAT]" : ""));
            }
        }
        catch (Throwable t) {
            scripts = new HashSet<String>(Collections.singletonList("exception: " + t.getMessage()));
        }
        if (scripts.isEmpty()) {
            scripts.add("none");
        }
        return scripts;
    }
}

