/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.hooks.PluginHook;
import github.scarsz.discordsrv.util.PluginUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
implements PluginHook {
    public static String getPrimaryGroup(Player player) {
        if (!PluginUtil.pluginHookIsEnabled("vault")) {
            DiscordSRV.debug("Tried looking up primary group for player " + player.getName() + " but the Vault plugin hook wasn't enabled");
            return " ";
        }
        try {
            Permission permissionProvider = (Permission)Bukkit.getServer().getServicesManager().getRegistration(Class.forName("net.milkbowl.vault.permission.Permission")).getProvider();
            if (permissionProvider == null) {
                DiscordSRV.debug("Tried looking up group for player " + player.getName() + " but failed to get the registered service provider for Vault");
                return " ";
            }
            String primaryGroup = permissionProvider.getPrimaryGroup(player);
            if (!primaryGroup.equals("default")) {
                return primaryGroup;
            }
            DiscordSRV.debug("Tried looking up group for player " + player.getName() + " but the given group was \"default\"");
            return " ";
        }
        catch (Exception e) {
            DiscordSRV.debug("Failed to look up group for player " + player.getName() + ": " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace(e));
            return " ";
        }
    }

    public static String[] getPlayersGroups(OfflinePlayer player) {
        if (!PluginUtil.pluginHookIsEnabled("vault")) {
            return new String[0];
        }
        try {
            RegisteredServiceProvider service = Bukkit.getServer().getServicesManager().getRegistration(Class.forName("net.milkbowl.vault.permission.Permission"));
            if (service == null) {
                return new String[0];
            }
            ArrayList<String> playerGroups = new ArrayList<String>();
            Method getPlayerGroupsMethod = service.getProvider().getClass().getMethod("getPlayerGroups", new Class[0]);
            for (World world : Bukkit.getWorlds()) {
                for (String group : (String[])getPlayerGroupsMethod.invoke(service.getProvider(), world.getName(), player)) {
                    if (playerGroups.contains(group)) continue;
                    playerGroups.add(group);
                }
            }
            for (String group : (String[])getPlayerGroupsMethod.invoke(service.getProvider(), null, player)) {
                if (playerGroups.contains(group)) continue;
                playerGroups.add(group);
            }
            return playerGroups.toArray(new String[0]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String[] getGroups() {
        if (!PluginUtil.pluginHookIsEnabled("vault")) {
            return new String[0];
        }
        try {
            RegisteredServiceProvider service = Bukkit.getServer().getServicesManager().getRegistration(Class.forName("net.milkbowl.vault.permission.Permission"));
            if (service == null) {
                return new String[0];
            }
            Method getGroupsMethod = service.getProvider().getClass().getMethod("getGroups", new Class[0]);
            return (String[])getGroupsMethod.invoke(service.getProvider(), new Object[0]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("Vault");
    }
}

