/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import ru.mrbrikster.chatty.api.ChattyApi;
import ru.mrbrikster.chatty.api.chats.Chat;
import ru.mrbrikster.chatty.api.events.ChattyMessageEvent;

public class ChattyChatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onChattyMessage(ChattyMessageEvent event) {
        DiscordSRV.getPlugin().processChatMessage(event.getPlayer(), event.getMessage(), event.getChat().getName(), false, (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component message) {
        ChattyApi api = this.getApi();
        if (api == null) {
            return;
        }
        Optional optChat = api.getChat(channel);
        if (!optChat.isPresent()) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Attempted to broadcast message to channel \"" + channel + "\" but the channel doesn't exist (returned null); aborting message send");
            return;
        }
        Chat chat = (Chat)optChat.get();
        String legacy = MessageUtil.toLegacy(message);
        String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelcolor%", "").replace("%channelname%", chat.getName()).replace("%channelnickname%", chat.getName()).replace("%message%", legacy);
        Collection recipients = chat.getRecipients(null);
        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Sending a message to Chatty chat (" + chat.getName() + "), recipients: " + recipients);
        String translatedMessage = MessageUtil.translateLegacy(plainMessage);
        chat.sendMessage(translatedMessage);
        PlayerUtil.notifyPlayersOfMentions(recipients::contains, legacy);
    }

    private ChattyApi getApi() {
        Plugin chatty = this.getPlugin();
        try {
            return (ChattyApi)chatty.getClass().getMethod("api", new Class[0]).invoke((Object)chatty, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            DiscordSRV.error("Unable to get Chatty plugin", e);
            return null;
        }
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("Chatty");
    }

    @Override
    public boolean isEnabled() {
        boolean regular;
        boolean bl = regular = this.getPlugin() != null && this.getPlugin().isEnabled() && PluginUtil.pluginHookIsEnabled(this.getPlugin().getName());
        if (!regular) {
            return false;
        }
        try {
            Class.forName("ru.mrbrikster.chatty.api.ChattyApi");
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
        return true;
    }
}

