/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import ru.brikster.chatty.api.ChattyApi;
import ru.brikster.chatty.api.chat.Chat;
import ru.brikster.chatty.api.event.ChattyMessageEvent;

public class ChattyV3ChatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onChattyMessage(ChattyMessageEvent event) {
        DiscordSRV.getPlugin().processChatMessage(event.getSender().getPlayer(), event.getPlainMessage(), event.getChat().getId(), false, (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component message) {
        ChattyApi api = this.getApi();
        Optional<Chat> optChat = Optional.ofNullable((Chat)api.getChats().get(channel));
        if (!optChat.isPresent()) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Attempted to broadcast message to channel \"" + channel + "\" but the channel doesn't exist (returned null); aborting message send");
            return;
        }
        Chat chat = optChat.get();
        String legacy = MessageUtil.toLegacy(message);
        String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelcolor%", "").replace("%channelname%", chat.getId()).replace("%channelnickname%", chat.getId()).replace("%message%", legacy);
        Collection recipients = chat.calculateRecipients(null);
        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Sending a message to Chatty chat (" + chat.getId() + "), recipients: " + recipients);
        String translatedMessage = MessageUtil.translateLegacy(plainMessage);
        chat.sendLegacyMessage((Plugin)DiscordSRV.getPlugin(), translatedMessage);
        PlayerUtil.notifyPlayersOfMentions(recipients::contains, legacy);
    }

    private ChattyApi getApi() {
        return ChattyApi.instance();
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("Chatty");
    }

    @Override
    public boolean isEnabled() {
        boolean regular;
        boolean bl = regular = this.getPlugin() != null && this.getPlugin().isEnabled() && PluginUtil.pluginHookIsEnabled(this.getPlugin().getName());
        if (!regular) {
            return false;
        }
        try {
            Class.forName("ru.brikster.chatty.api.ChattyApi");
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
        return true;
    }
}

