/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import br.com.finalcraft.fancychat.api.FancyChatApi;
import br.com.finalcraft.fancychat.api.FancyChatSendChannelMessageEvent;
import br.com.finalcraft.fancychat.config.fancychat.FancyChannel;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class FancyChatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onMessage(FancyChatSendChannelMessageEvent event) {
        if (event.getChannel() == null) {
            return;
        }
        if (StringUtils.isBlank(event.getMessage())) {
            return;
        }
        Player sender = null;
        if (event.getSender() instanceof Player) {
            sender = (Player)event.getSender();
        }
        DiscordSRV.getPlugin().processChatMessage(sender, event.getMessage(), event.getChannel().getName(), false, (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component message) {
        FancyChannel fancyChannel = FancyChatApi.getChannel((String)channel);
        if (fancyChannel == null) {
            return;
        }
        String legacy = MessageUtil.toLegacy(message);
        String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelcolor%", "").replace("%channelname%", fancyChannel.getName()).replace("%channelnickname%", fancyChannel.getAlias()).replace("%message%", legacy);
        String translatedMessage = MessageUtil.translateLegacy(plainMessage);
        FancyChatApi.sendMessage((String)translatedMessage, (FancyChannel)fancyChannel);
        PlayerUtil.notifyPlayersOfMentions(player -> fancyChannel.getPlayersOnThisChannel().contains(player), legacy);
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("EverNifeFancyChat");
    }
}

