/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import com.dthielke.herochat.Channel;
import com.dthielke.herochat.ChannelChatEvent;
import com.dthielke.herochat.Chatter;
import com.dthielke.herochat.Herochat;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class HerochatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onMessage(ChannelChatEvent event) {
        if (StringUtils.isBlank(event.getMessage())) {
            return;
        }
        DiscordSRV.getPlugin().processChatMessage(event.getSender().getPlayer(), event.getMessage(), event.getChannel().getName(), event.getResult() != Chatter.Result.ALLOWED, (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component message) {
        Channel chatChannel = HerochatHook.getChannelByCaseInsensitiveName(channel);
        if (chatChannel == null) {
            return;
        }
        String legacy = MessageUtil.toLegacy(message);
        String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelname%", chatChannel.getName()).replace("%channelnickname%", chatChannel.getNick()).replace("%message%", legacy).replace("%channelcolor%", chatChannel.getColor().toString());
        String translatedMessage = MessageUtil.translateLegacy(plainMessage);
        chatChannel.sendRawMessage(translatedMessage);
        PlayerUtil.notifyPlayersOfMentions(player -> chatChannel.getMembers().stream().map(Chatter::getPlayer).collect(Collectors.toList()).contains(player), legacy);
    }

    private static Channel getChannelByCaseInsensitiveName(String name) {
        List channels = Herochat.getChannelManager().getChannels();
        if (channels.size() > 0) {
            for (Channel channel : Herochat.getChannelManager().getChannels()) {
                DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "\"" + channel.getName() + "\" equalsIgnoreCase \"" + name + "\" == " + channel.getName().equalsIgnoreCase(name));
                if (!channel.getName().equalsIgnoreCase(name)) continue;
                return channel;
            }
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "No matching Herochat channels for name \"" + name + "\"");
        } else {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Herochat's channel manager returned no registered channels");
        }
        return null;
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("Herochat");
    }
}

