/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import com.github.ucchyocean.lc3.LunaChatBukkit;
import com.github.ucchyocean.lc3.bukkit.event.LunaChatBukkitChannelChatEvent;
import com.github.ucchyocean.lc3.channel.Channel;
import com.github.ucchyocean.lc3.member.ChannelMemberBukkit;
import com.github.ucchyocean.lc3.member.ChannelMemberPlayer;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class LunaChatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onMessage(LunaChatBukkitChannelChatEvent event) {
        if (StringUtils.isBlank(event.getNgMaskedMessage())) {
            return;
        }
        Player player = event.getMember() != null && event.getMember() instanceof ChannelMemberPlayer ? ((ChannelMemberPlayer)event.getMember()).getPlayer() : null;
        DiscordSRV.getPlugin().processChatMessage(player, event.getNgMaskedMessage(), event.getChannel().getName(), false, (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component message) {
        Channel chatChannel = LunaChatBukkit.getInstance().getLunaChatAPI().getChannel(channel);
        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Resolved LunaChat channel " + channel + " -> " + chatChannel + (chatChannel != null ? " (" + chatChannel.getName() + ")" : ""));
        if (chatChannel == null) {
            return;
        }
        String legacy = MessageUtil.toLegacy(message);
        String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelname%", chatChannel.getName()).replace("%channelnickname%", chatChannel.getAlias().equals("") ? chatChannel.getName() : chatChannel.getAlias()).replace("%message%", legacy).replace("%channelcolor%", MessageUtil.toLegacy(MessageUtil.toComponent(MessageUtil.translateLegacy(chatChannel.getColorCode()))));
        String translatedMessage = MessageUtil.translateLegacy(plainMessage);
        chatChannel.chatFromOtherSource("Discord", null, translatedMessage);
        PlayerUtil.notifyPlayersOfMentions(player -> chatChannel.getMembers().stream().filter(member -> member instanceof ChannelMemberBukkit).map(member -> ((ChannelMemberBukkit)member).getPlayer()).collect(Collectors.toList()).contains(player), legacy);
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("LunaChat");
    }
}

