/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import com.nickuc.chat.api.events.PublicMessageEvent;
import com.nickuc.chat.api.nChatAPI;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class NChatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onMessage(PublicMessageEvent event) {
        DiscordSRV.getPlugin().processChatMessage(event.getSender().getPlayer(), event.getMessage(), event.getChannel().getName(), event.isCancelled(), (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channelName, Component message) {
        nChatAPI.getApi().getChannelByName(channelName).ifPresent(chatChannel -> {
            String legacy = MessageUtil.toLegacy(message);
            String chatChannelCommand = chatChannel.getCommand();
            String chatChannelNickname = chatChannelCommand != null ? chatChannelCommand : Character.toString(chatChannel.getName().charAt(0));
            String chatChannelColor = ChatColor.getLastColors((String)chatChannel.getFormat());
            String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelname%", chatChannel.getName()).replace("%channelnickname%", chatChannelNickname).replace("%message%", legacy).replace("%channelcolor%", MessageUtil.toLegacy(MessageUtil.toComponent(MessageUtil.translateLegacy(chatChannelColor))));
            String translatedMessage = MessageUtil.translateLegacy(plainMessage);
            nChatAPI.getApi().handleVirtualMessage(translatedMessage, chatChannel, virtualMessageEvent -> PlayerUtil.notifyPlayersOfMentions(player -> virtualMessageEvent.getRecipients().contains(player), legacy));
        });
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("nChat");
    }
}

