/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import com.palmergames.bukkit.TownyChat.Chat;
import com.palmergames.bukkit.TownyChat.channels.Channel;
import com.palmergames.bukkit.TownyChat.events.AsyncChatHookEvent;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import java.util.LinkedList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class TownyChatHook
implements ChatHook {
    public TownyChatHook() {
        this.reload();
    }

    public void reload() {
        if (!this.isEnabled()) {
            return;
        }
        Chat instance = (Chat)Bukkit.getPluginManager().getPlugin("TownyChat");
        if (instance == null) {
            DiscordSRV.info("Could not automatically hook TownyChat channels");
            return;
        }
        LinkedList linkedChannels = new LinkedList();
        LinkedList<String> availableChannels = new LinkedList<String>();
        DiscordSRV.getPlugin().getChannels().keySet().forEach(name -> {
            Channel channel = TownyChatHook.getChannelByCaseInsensitiveName(name);
            if (channel != null) {
                channel.setHooked(true);
                linkedChannels.add(channel.getName());
            }
        });
        for (Channel channel : instance.getChannelsHandler().getAllChannels().values()) {
            availableChannels.add(channel.getName());
        }
        if (!linkedChannels.isEmpty()) {
            DiscordSRV.info("Marked the following TownyChat channels as hooked: " + String.join((CharSequence)", ", linkedChannels) + ". Available channels: " + String.join((CharSequence)", ", availableChannels));
        } else {
            DiscordSRV.info("No TownyChat channels were marked as hooked. Available channels: " + String.join((CharSequence)", ", availableChannels));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMessage(AsyncChatHookEvent event) {
        if (DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(event.getChannel().getName()) == null) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Tried looking up destination Discord channel for Towny channel " + event.getChannel().getName() + " but none found");
            return;
        }
        if (StringUtils.isBlank(event.getMessage())) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received blank TownyChat message, not processing");
            return;
        }
        DiscordSRV.getPlugin().processChatMessage(event.getPlayer(), event.getMessage(), event.getChannel().getName(), event.isCancelled(), (Event)event);
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component message) {
        Chat instance = (Chat)Bukkit.getPluginManager().getPlugin("TownyChat");
        if (instance == null) {
            return;
        }
        Channel destinationChannel = TownyChatHook.getChannelByCaseInsensitiveName(channel);
        if (destinationChannel == null) {
            return;
        }
        String legacy = MessageUtil.toLegacy(message);
        String plainMessage = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelcolor%", destinationChannel.getMessageColour() != null ? destinationChannel.getMessageColour() : "").replace("%channelname%", destinationChannel.getName()).replace("%channelnickname%", destinationChannel.getChannelTag() != null ? destinationChannel.getChannelTag() : "").replace("%message%", legacy);
        String translatedMessage = MessageUtil.translateLegacy(plainMessage);
        for (Player player2 : PlayerUtil.getOnlinePlayers()) {
            if (!destinationChannel.isPresent(player2.getName())) continue;
            MessageUtil.sendMessage((CommandSender)player2, translatedMessage);
        }
        PlayerUtil.notifyPlayersOfMentions(player -> destinationChannel.isPresent(player.getName()), legacy);
    }

    private static Channel getChannelByCaseInsensitiveName(String name) {
        Chat instance = (Chat)Bukkit.getPluginManager().getPlugin("TownyChat");
        if (instance == null) {
            return null;
        }
        for (Channel townyChannel : instance.getChannelsHandler().getAllChannels().values()) {
            if (!townyChannel.getName().equalsIgnoreCase(name)) continue;
            return townyChannel;
        }
        return null;
    }

    public static String getMainChannelName() {
        Chat instance = (Chat)Bukkit.getPluginManager().getPlugin("TownyChat");
        if (instance == null) {
            return null;
        }
        Channel channel = instance.getChannelsHandler().getDefaultChannel();
        if (channel == null) {
            return null;
        }
        return channel.getName();
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("TownyChat");
    }
}

