/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.chat;

import com.comphenix.protocol.events.PacketContainer;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.VentureChatMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.VentureChatMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.VentureChatEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;

public class VentureChatHook
implements ChatHook {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onVentureChat(VentureChatEvent event) {
        String username;
        boolean hasGoodGroup;
        Player player;
        boolean bungeeReceive;
        boolean shouldUseBungee = DiscordSRV.config().getBoolean("VentureChatBungee");
        ChatChannel chatChannel = event.getChannel();
        if (chatChannel == null) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received VentureChatEvent with a null channel");
            return;
        }
        boolean bungeeSend = event.isBungee();
        boolean bl = bungeeReceive = !bungeeSend && chatChannel.getBungee() != false;
        if (shouldUseBungee) {
            if (bungeeSend) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received a VentureChat event that it to be sent to BungeeCord, ignoring due to VentureChatBungee being enabled");
                return;
            }
        } else if (bungeeReceive) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received a VentureChat event from BungeeCord, ignoring due to VentureChatBungee being disabled");
            return;
        }
        String message = event.getChat();
        MineverseChatPlayer chatPlayer = event.getMineverseChatPlayer();
        DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received a VentureChatEvent (player: " + (chatPlayer != null ? chatPlayer.getName() : "null") + ")");
        if (chatPlayer != null && (player = chatPlayer.getPlayer()) != null) {
            DiscordSRV.getPlugin().processChatMessage(player, message, chatChannel.getName(), false, (Event)event);
            return;
        }
        if (!shouldUseBungee) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received a VentureChat message with a null MineverseChatPlayer or Player (and BungeeCord is disabled)");
            return;
        }
        DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Processing VentureChat message without a Player object" + (bungeeReceive ? " (a BungeeCord receive)" : " (not a BungeeCord receive)"));
        if (!DiscordSRV.config().getBoolean("DiscordChatChannelMinecraftToDiscord")) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "A VentureChat message was received but it was not delivered to Discord because DiscordChatChannelMinecraftToDiscord is false");
            return;
        }
        String prefix = DiscordSRV.config().getString("DiscordChatChannelPrefixRequiredToProcessMessage");
        if (!MessageUtil.strip(message).startsWith(prefix)) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "A VentureChat message was received but it was not delivered to Discord because the message didn't start with \"" + prefix + "\" (DiscordChatChannelPrefixRequiredToProcessMessage): \"" + message + "\"");
            return;
        }
        String channel = chatChannel.getName();
        VentureChatMessagePreProcessEvent preEvent = DiscordSRV.api.callEvent(new VentureChatMessagePreProcessEvent(channel, message, event));
        if (preEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "VentureChatMessagePreProcessEvent was cancelled, message send aborted");
            return;
        }
        channel = preEvent.getChannel();
        message = preEvent.getMessage();
        String userPrimaryGroup = event.getPlayerPrimaryGroup();
        if (userPrimaryGroup.equals("default")) {
            userPrimaryGroup = "";
        }
        if (hasGoodGroup = StringUtils.isNotBlank(userPrimaryGroup)) {
            userPrimaryGroup = userPrimaryGroup.substring(0, 1).toUpperCase() + userPrimaryGroup.substring(1);
        }
        boolean reserializer = DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_ToDiscord");
        String formatUsername = username = event.getUsername();
        if (!reserializer) {
            formatUsername = DiscordUtil.escapeMarkdown(username);
        }
        String discordMessage = (hasGoodGroup ? LangUtil.Message.CHAT_TO_DISCORD.toString() : LangUtil.Message.CHAT_TO_DISCORD_NO_PRIMARY_GROUP.toString()).replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%channelname%", channel != null ? channel.substring(0, 1).toUpperCase() + channel.substring(1) : "").replace("%primarygroup%", userPrimaryGroup).replace("%username%", formatUsername);
        discordMessage = PlaceholderUtil.replacePlaceholdersToDiscord(discordMessage);
        String displayName = MessageUtil.strip(event.getNickname());
        if (reserializer) {
            message = MessageUtil.reserializeToDiscord(MessageUtil.toComponent(message));
        } else {
            displayName = DiscordUtil.escapeMarkdown(displayName);
        }
        discordMessage = discordMessage.replace("%displayname%", displayName).replace("%message%", message);
        if (!reserializer) {
            discordMessage = MessageUtil.strip(discordMessage);
        }
        if (DiscordSRV.config().getBoolean("DiscordChatChannelTranslateMentions")) {
            discordMessage = DiscordUtil.convertMentionsFromNames(discordMessage, DiscordSRV.getPlugin().getMainGuild());
        } else {
            discordMessage = discordMessage.replace("@", "@\u200b");
            message = message.replace("@", "@\u200b");
        }
        VentureChatMessagePostProcessEvent postEvent = DiscordSRV.api.callEvent(new VentureChatMessagePostProcessEvent(channel, discordMessage, event, preEvent.isCancelled()));
        if (postEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "VentureChatMessagePostProcessEvent was cancelled, message send aborted");
            return;
        }
        channel = postEvent.getChannel();
        discordMessage = postEvent.getProcessedMessage();
        if (!DiscordSRV.config().getBoolean("Experiment_WebhookChatMessageDelivery")) {
            if (channel == null) {
                DiscordUtil.sendMessage(DiscordSRV.getPlugin().getOptionalTextChannel("global"), discordMessage);
            } else {
                DiscordUtil.sendMessage(DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channel), discordMessage);
            }
        } else {
            OfflinePlayer offlinePlayer;
            TextChannel destinationChannel;
            if (channel == null) {
                channel = DiscordSRV.getPlugin().getOptionalChannel("global");
            }
            if ((destinationChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channel)) == null) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to find Discord channel to forward message from game channel " + channel);
                return;
            }
            if (!DiscordUtil.checkPermission(destinationChannel.getGuild(), Permission.MANAGE_WEBHOOKS)) {
                DiscordSRV.error("Couldn't deliver chat message as webhook because the bot lacks the \"Manage Webhooks\" permission.");
                return;
            }
            message = PlaceholderUtil.replacePlaceholdersToDiscord(message);
            if (!reserializer) {
                message = MessageUtil.strip(message);
            }
            if (DiscordSRV.config().getBoolean("DiscordChatChannelTranslateMentions")) {
                message = DiscordUtil.convertMentionsFromNames(message, DiscordSRV.getPlugin().getMainGuild());
            }
            String webhookUsername = DiscordSRV.config().getString("Experiment_WebhookChatMessageUsernameFormat").replaceAll("(?:%displayname%)|(?:%username%)", username);
            webhookUsername = PlaceholderUtil.replacePlaceholders(webhookUsername);
            webhookUsername = MessageUtil.strip(webhookUsername);
            UUID uuid = chatPlayer != null ? chatPlayer.getUUID() : null;
            OfflinePlayer offlinePlayer2 = offlinePlayer = uuid != null ? Bukkit.getOfflinePlayer((UUID)uuid) : null;
            if (offlinePlayer != null) {
                String name = chatPlayer.getNickname() != null ? chatPlayer.getNickname() : chatPlayer.getName();
                WebhookUtil.deliverMessage(destinationChannel, offlinePlayer, name, message, (Collection<? extends MessageEmbed>)null);
            } else {
                WebhookUtil.deliverMessage(destinationChannel, webhookUsername, DiscordSRV.getAvatarUrl(username, uuid), message, (Collection<? extends MessageEmbed>)null);
            }
        }
    }

    @Override
    public void broadcastMessageToChannel(String channel, Component component) {
        String channelColor;
        String legacy;
        ChatChannel chatChannel;
        block7: {
            chatChannel = ChatChannel.getChannel((String)channel);
            if (chatChannel == null) {
                DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Attempted to broadcast message to channel \"" + channel + "\" but the channel doesn't exist (returned null); aborting message send");
                return;
            }
            legacy = MessageUtil.toLegacy(component);
            channelColor = null;
            try {
                channelColor = ChatColor.valueOf((String)chatChannel.getColor().toUpperCase()).toString();
            }
            catch (Exception ignored) {
                if (!chatChannel.getColor().contains(MessageUtil.LEGACY_SECTION.toString())) break block7;
                channelColor = MessageUtil.translateLegacy(chatChannel.getColor());
            }
        }
        String message = LangUtil.Message.CHAT_CHANNEL_MESSAGE.toString().replace("%channelname%", chatChannel.getName()).replace("%channelnickname%", chatChannel.getAlias()).replace("%message%", legacy).replace("%channelcolor%", MessageUtil.translateLegacy(channelColor != null ? channelColor : ""));
        if (DiscordSRV.config().getBoolean("VentureChatBungee") && chatChannel.getBungee().booleanValue()) {
            if (chatChannel.isFiltered().booleanValue()) {
                message = Format.FilterChat((String)message);
            }
            String translatedMessage = MessageUtil.toLegacy(MessageUtil.toComponent(message));
            MineverseChat.sendDiscordSRVPluginMessage((String)chatChannel.getName(), (String)translatedMessage);
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Sent a message to VentureChat via BungeeCord (channel: " + chatChannel.getName() + ")");
        } else {
            List playersToNotify = MineverseChat.onlinePlayers.stream().filter(p -> p.getListening().contains(chatChannel.getName())).filter(p -> chatChannel.hasPermission() == false || p.getPlayer().hasPermission(chatChannel.getPermission())).collect(Collectors.toList());
            for (MineverseChatPlayer player2 : playersToNotify) {
                String playerMessage = player2.hasFilter() && chatChannel.isFiltered() != false ? Format.FilterChat((String)message) : message;
                playerMessage = playerMessage.replace("\"", "\\\"");
                String json = Format.convertPlainTextToJson((String)playerMessage, (boolean)true);
                int hash = playerMessage.replaceAll("(\u00a7([a-z0-9]))", "").hashCode();
                String finalJSON = Format.formatModerationGUI((String)json, (Player)player2.getPlayer(), (String)"Discord", (String)chatChannel.getName(), (int)hash);
                PacketContainer packet = Format.createPacketPlayOutChat((String)finalJSON);
                Format.sendPacketPlayOutChat((Player)player2.getPlayer(), (PacketContainer)packet);
            }
            PlayerUtil.notifyPlayersOfMentions(player -> playersToNotify.stream().map(MineverseChatPlayer::getPlayer).collect(Collectors.toList()).contains(player), message);
        }
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("VentureChat");
    }
}

