/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.permissions;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.hooks.PluginHook;
import github.scarsz.discordsrv.objects.managers.AccountLinkManager;
import github.scarsz.discordsrv.objects.managers.GroupSynchronizationManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeMutateEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.event.user.track.UserTrackEvent;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LuckPermsHook
implements PluginHook,
ContextCalculator<Player> {
    private static final String CONTEXT_LINKED = "discordsrv:linked";
    private static final String CONTEXT_BOOSTING = "discordsrv:boosting";
    private static final String CONTEXT_ROLE = "discordsrv:role";
    private static final String CONTEXT_ROLE_ID = "discordsrv:role_id";
    private static final String CONTEXT_SERVER_ID = "discordsrv:server_id";
    private final LuckPerms luckPerms;
    private final Set<EventSubscription<?>> subscriptions = new HashSet();

    public LuckPermsHook() {
        this.luckPerms = (LuckPerms)Bukkit.getServicesManager().load(LuckPerms.class);
        if (this.luckPerms == null) {
            DiscordSRV.error("Failed to get LuckPerms service. Is LuckPerms enabled?");
            return;
        }
        if (!DiscordSRV.config().getStringList("DisabledPluginHooks").contains("LuckPerms-GroupUpdates")) {
            DiscordSRV.debug("Enabling LuckPerms' instant group updates");
            this.subscriptions.add(this.luckPerms.getEventBus().subscribe(UserTrackEvent.class, event -> this.handle(event.getUser().getUniqueId())));
            this.subscriptions.add(this.luckPerms.getEventBus().subscribe(NodeAddEvent.class, event -> this.handle((NodeMutateEvent)event, event.getNode(), true)));
            this.subscriptions.add(this.luckPerms.getEventBus().subscribe(NodeRemoveEvent.class, event -> this.handle((NodeMutateEvent)event, event.getNode(), false)));
        } else {
            DiscordSRV.debug("Not using LuckPerms' instant group updates because they are disabled in the config");
        }
        if (!DiscordSRV.config().getStringList("DisabledPluginHooks").contains("LuckPerms-Contexts")) {
            DiscordSRV.debug("Enabling LuckPerms' contexts");
            this.luckPerms.getContextManager().registerCalculator((ContextCalculator)this);
        } else {
            DiscordSRV.debug("Not using LuckPerms' contexts because they are disabled in the config");
        }
    }

    private void handle(NodeMutateEvent event, Node node, boolean add) {
        if (event.isUser() && node.getType() == NodeType.INHERITANCE) {
            String groupName = ((InheritanceNode)NodeType.INHERITANCE.cast(node)).getGroupName();
            UUID uuid = ((User)event.getTarget()).getUniqueId();
            Map justModified = DiscordSRV.getPlugin().getGroupSynchronizationManager().getJustModifiedGroups().getOrDefault(uuid, null);
            if (justModified != null && justModified.getOrDefault(add ? "add" : "remove", Collections.emptyList()).remove(groupName)) {
                return;
            }
            this.handle(((User)event.getTarget()).getUniqueId());
        }
    }

    private void handle(UUID user) {
        if (!DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled()) {
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)user);
        SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> DiscordSRV.getPlugin().getGroupSynchronizationManager().resync(player, GroupSynchronizationManager.SyncDirection.TO_DISCORD, GroupSynchronizationManager.SyncCause.MINECRAFT_GROUP_EDIT_API), 5L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin() instanceof DiscordSRV) {
            this.subscriptions.forEach(EventSubscription::close);
            this.luckPerms.getContextManager().unregisterCalculator((ContextCalculator)this);
        }
    }

    public void calculate(@NotNull Player target, ContextConsumer consumer) {
        UUID uuid = target.getUniqueId();
        AccountLinkManager accountLinkManager = DiscordSRV.getPlugin().getAccountLinkManager();
        if (!accountLinkManager.isInCache(uuid)) {
            DiscordSRV.debug(Debug.LP_CONTEXTS, "Player " + target + " was not in cache when LP contexts were requested, unable to provide contexts data (online player: " + Bukkit.getPlayer((UUID)uuid) + ")");
            return;
        }
        String userId = accountLinkManager.getDiscordIdFromCache(uuid);
        consumer.accept(CONTEXT_LINKED, Boolean.toString(userId != null));
        if (userId == null) {
            return;
        }
        github.scarsz.discordsrv.dependencies.jda.api.entities.User user = DiscordUtil.getJda().getUserById(userId);
        if (user == null) {
            return;
        }
        for (Guild guild : DiscordUtil.getJda().getGuilds()) {
            if (guild.getMember(user) == null) continue;
            consumer.accept(CONTEXT_SERVER_ID, guild.getId());
        }
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild == null) {
            return;
        }
        Member member = mainGuild.getMemberById(userId);
        if (member == null) {
            return;
        }
        consumer.accept(CONTEXT_BOOSTING, Boolean.toString(member.getTimeBoosted() != null));
        for (Role role : member.getRoles()) {
            if (StringUtils.isBlank(role.getName())) continue;
            consumer.accept(CONTEXT_ROLE, role.getName());
            consumer.accept(CONTEXT_ROLE_ID, role.getId());
        }
    }

    public ContextSet estimatePotentialContexts() {
        ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
        builder.add(CONTEXT_LINKED, "true");
        builder.add(CONTEXT_LINKED, "false");
        builder.add(CONTEXT_BOOSTING, "true");
        builder.add(CONTEXT_BOOSTING, "false");
        Guild mainGuild = DiscordSRV.getPlugin().getMainGuild();
        if (mainGuild != null) {
            for (Role role : mainGuild.getRoles()) {
                if (StringUtils.isBlank(role.getName())) continue;
                builder.add(CONTEXT_ROLE, role.getName());
                builder.add(CONTEXT_ROLE_ID, role.getId());
            }
        }
        for (Guild guild : DiscordSRV.getPlugin().getJda().getGuilds()) {
            builder.add(CONTEXT_SERVER_ID, guild.getId());
        }
        return builder.build();
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("LuckPerms");
    }
}

