/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.hooks.vanish;

import de.myzelyam.api.vanish.PostPlayerHideEvent;
import de.myzelyam.api.vanish.PostPlayerShowEvent;
import de.myzelyam.api.vanish.VanishAPI;
import de.myzelyam.supervanish.SuperVanish;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.hooks.vanish.VanishHook;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class SuperVanishHook
implements VanishHook {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerShow(PostPlayerShowEvent event) {
        SuperVanish plugin = (SuperVanish)this.getPlugin();
        if (!plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.BroadcastFakeJoinOnReappear") || event.isSilent()) {
            return;
        }
        Player player = event.getPlayer();
        String joinMessage = plugin.replacePlaceholders("VanishMessage", new Object[]{player});
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerJoinMessage");
        if (messageFormat == null) {
            return;
        }
        String name = player.getName();
        if (GamePermissionUtil.hasPermission((Permissible)event.getPlayer(), "discordsrv.silentjoin")) {
            DiscordSRV.info(LangUtil.InternalMessage.SILENT_JOIN.toString().replace("{player}", name));
            return;
        }
        SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> DiscordSRV.getPlugin().sendJoinMessage(event.getPlayer(), joinMessage), 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerHide(PostPlayerHideEvent event) {
        SuperVanish plugin = (SuperVanish)this.getPlugin();
        if (!plugin.getSettings().getBoolean("MessageOptions.FakeJoinQuitMessages.BroadcastFakeQuitOnVanish") || event.isSilent()) {
            return;
        }
        Player player = event.getPlayer();
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerLeaveMessage");
        if (messageFormat == null) {
            return;
        }
        String name = player.getName();
        String joinMessage = plugin.replacePlaceholders("ReappearMessage", new Object[]{player});
        if (GamePermissionUtil.hasPermission((Permissible)event.getPlayer(), "discordsrv.silentquit")) {
            DiscordSRV.info(LangUtil.InternalMessage.SILENT_QUIT.toString().replace("{player}", name));
            return;
        }
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> DiscordSRV.getPlugin().sendLeaveMessage(event.getPlayer(), joinMessage));
    }

    @Override
    public boolean isVanished(Player player) {
        return VanishAPI.isInvisible((Player)player);
    }

    @Override
    public Plugin getPlugin() {
        return PluginUtil.getPlugin("SuperVanish");
    }
}

