/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.DiscordPrivateMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberJoinEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.priv.PrivateMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorHandler;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.requests.ErrorResponse;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.util.DiscordUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class DiscordAccountLinkListener
extends ListenerAdapter {
    private final ErrorHandler ignoreFailedToDeleteMessage = new ErrorHandler().ignore(ErrorResponse.UNKNOWN_MESSAGE, new ErrorResponse[0]).ignore(ErrorResponse.MISSING_ACCESS, new ErrorResponse[0]);

    @Override
    public void onPrivateMessageReceived(PrivateMessageReceivedEvent event) {
        if (event.getAuthor().getId().equals(event.getJDA().getSelfUser().getId())) {
            return;
        }
        DiscordSRV.api.callEvent(new DiscordPrivateMessageReceivedEvent(event));
        if (!DiscordSRV.config().getBoolean("MinecraftDiscordAccountLinkedUsePM")) {
            return;
        }
        String reply = DiscordSRV.getPlugin().getAccountLinkManager().process(event.getMessage().getContentRaw(), event.getAuthor().getId());
        if (reply != null) {
            event.getMessage().reply(reply).queue();
        }
    }

    @Override
    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        TextChannel linkChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName("link");
        if (!event.getChannel().equals(linkChannel)) {
            return;
        }
        Message receivedMessage = event.getMessage();
        String reply = DiscordSRV.getPlugin().getAccountLinkManager().process(receivedMessage.getContentRaw(), event.getAuthor().getId());
        if (reply != null) {
            int deleteSeconds = DiscordSRV.config().getIntElse("MinecraftDiscordAccountLinkedMessageDeleteSeconds", 0);
            RestAction<Message> repliedMessage = receivedMessage.reply(reply).delay(deleteSeconds, TimeUnit.SECONDS);
            repliedMessage.queue(replyMessage -> {
                if (deleteSeconds > 0) {
                    replyMessage.delete().queue(null, this.ignoreFailedToDeleteMessage);
                    receivedMessage.delete().queue(null, this.ignoreFailedToDeleteMessage.handle(ErrorResponse.MISSING_PERMISSIONS, e -> DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Failed to delete " + receivedMessage.getAuthor() + "'s message in the link channel because of missing permissions.")));
                }
            });
        }
    }

    @Override
    public void onGuildMemberJoin(GuildMemberJoinEvent event) {
        Member member = event.getMember();
        if (DiscordSRV.getPlugin().getAccountLinkManager() == null) {
            DiscordSRV.debug(Debug.ACCOUNT_LINKING, "AccountLinkManager is null, not processing join event");
            return;
        }
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getUser().getId());
        if (uuid != null) {
            Role roleToAdd = DiscordUtil.resolveRole(DiscordSRV.config().getString("MinecraftDiscordAccountLinkedRoleNameToAddUserTo"));
            if (roleToAdd == null || roleToAdd.getGuild().equals(member.getGuild())) {
                if (roleToAdd != null) {
                    DiscordUtil.addRoleToMember(member, roleToAdd);
                } else {
                    DiscordSRV.debug(Debug.GROUP_SYNC, "Couldn't add user to null role");
                }
            } else {
                DiscordSRV.debug(Debug.GROUP_SYNC, "Not adding role to member upon guild join due to the guild being different! (" + roleToAdd.getGuild() + " / " + member.getGuild() + ")");
            }
            if (DiscordSRV.config().getBoolean("NicknameSynchronizationEnabled")) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                DiscordSRV.getPlugin().getNicknameUpdater().setNickname(member, player);
            }
        }
    }
}

