/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.GuildBanEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.GuildUnbanEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.Date;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DiscordBanListener
extends ListenerAdapter {
    @Override
    public void onGuildBan(GuildBanEvent event) {
        Player player;
        UUID linkedUuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getUser().getId());
        if (linkedUuid == null) {
            DiscordSRV.debug(Debug.BAN_SYNCHRONIZATION, "Not handling ban for user " + event.getUser() + " because they didn't have a linked account");
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)linkedUuid);
        if (!offlinePlayer.hasPlayedBefore()) {
            return;
        }
        if (!DiscordSRV.config().getBoolean("BanSynchronizationDiscordToMinecraft")) {
            DiscordSRV.debug(Debug.BAN_SYNCHRONIZATION, "Not handling ban for user " + event.getUser() + " because doing so is disabled in the config");
            return;
        }
        String reason = LangUtil.Message.BAN_DISCORD_TO_MINECRAFT.toString();
        BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.NAME);
        if (banList.isBanned(offlinePlayer.getName())) {
            return;
        }
        banList.addBan(offlinePlayer.getName(), reason, (Date)null, "Discord");
        if (offlinePlayer.isOnline() && (player = offlinePlayer.getPlayer()) != null) {
            SchedulerUtil.runTaskForPlayer((Plugin)DiscordSRV.getPlugin(), player, () -> player.kickPlayer(reason));
        }
    }

    @Override
    public void onGuildUnban(GuildUnbanEvent event) {
        UUID linkedUuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getUser().getId());
        if (linkedUuid == null) {
            DiscordSRV.debug(Debug.BAN_SYNCHRONIZATION, "Not handling unban for user " + event.getUser() + " because they didn't have a linked account");
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)linkedUuid);
        if (!offlinePlayer.hasPlayedBefore()) {
            return;
        }
        if (!DiscordSRV.config().getBoolean("BanSynchronizationDiscordToMinecraft")) {
            DiscordSRV.debug(Debug.BAN_SYNCHRONIZATION, "Not handling unban for user " + event.getUser() + " because doing so is disabled in the config");
            return;
        }
        String playerName = offlinePlayer.getName();
        if (StringUtils.isNotBlank(playerName)) {
            Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(playerName);
        }
    }
}

