/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.DiscordChatChannelListCommandMessageEvent;
import github.scarsz.discordsrv.api.events.DiscordConsoleCommandPostProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordConsoleCommandPreProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.emoji.EmojiParser;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageSticker;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.TextReplacementConfig;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.format.TextColor;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import github.scarsz.discordsrv.hooks.DynmapHook;
import github.scarsz.discordsrv.hooks.VaultHook;
import github.scarsz.discordsrv.objects.proxy.CommandSenderDynamicProxy;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageFormatResolver;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PaperForwardingCommandSender;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DiscordChatListener
extends ListenerAdapter {
    private static final Pattern TOP_ROLE_COLOR_PATTERN = Pattern.compile("%toprolecolor%.*");
    private static final Pattern MESSAGE_MATTER = Pattern.compile("%message%");
    private final boolean useFeedbackForwardingSender = PaperForwardingCommandSender.isSenderExists();

    /*
     * WARNING - void declaration
     */
    @Override
    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        void var3_19;
        void var3_15;
        String string;
        String string2;
        void var3_11;
        boolean bl;
        List<String> rolesAllowedToColor;
        boolean bl2;
        void var3_6;
        Role topRole;
        DiscordGuildMessagePreProcessEvent preEvent;
        if (event.getMember() == null && !event.isWebhookMessage() || DiscordUtil.getJda() == null || event.getAuthor().equals(DiscordUtil.getJda().getSelfUser())) {
            return;
        }
        if (event.isWebhookMessage()) {
            String webhook = WebhookUtil.getWebhookUrlFromCache(event.getChannel());
            if (webhook != null && webhook.split("/")[6].equals(event.getAuthor().getId())) {
                return;
            }
            if (DiscordSRV.config().getBoolean("DiscordChatChannelBlockWebhooks")) {
                DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Received Discord message from webhook " + event.getAuthor() + " but DiscordChatChannelBlockWebhooks is on");
                return;
            }
        }
        for (Map.Entry entry : DiscordSRV.getPlugin().getCannedResponses().entrySet()) {
            if (!event.getMessage().getContentRaw().toLowerCase().startsWith(((String)entry.getKey()).toLowerCase())) continue;
            String discordMessage = (String)entry.getValue();
            discordMessage = PlaceholderUtil.replacePlaceholdersToDiscord(discordMessage);
            DiscordUtil.sendMessage(event.getChannel(), MessageUtil.strip(discordMessage));
            return;
        }
        DiscordSRV.api.callEvent(new DiscordGuildMessageReceivedEvent(event));
        String destinationChannel = DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel());
        if (destinationChannel == null || "link".equalsIgnoreCase(destinationChannel)) {
            return;
        }
        String string3 = event.getMessage().getContentRaw();
        if (StringUtils.isBlank(string3) && event.getMessage().getAttachments().isEmpty() && event.getMessage().getStickers().isEmpty()) {
            return;
        }
        if (this.processPlayerListCommand(event, string3)) {
            return;
        }
        if (this.processConsoleCommand(event, event.getMessage().getContentRaw())) {
            return;
        }
        String string4 = string3.replace("\u001b", "");
        if (!DiscordSRV.config().getBoolean("DiscordChatChannelDiscordToMinecraft")) {
            return;
        }
        if (DiscordSRV.config().getBoolean("DiscordChatChannelRequireLinkedAccount") && !event.getAuthor().isBot()) {
            boolean hasLinkedAccount;
            if (DiscordSRV.getPlugin().getAccountLinkManager() == null) {
                event.getAuthor().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage(LangUtil.Message.FAILED_TO_CHECK_LINKED_ACCOUNT.toString()).queue());
                DiscordUtil.deleteMessage(event.getMessage());
                return;
            }
            boolean bl3 = hasLinkedAccount = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getAuthor().getId()) != null;
            if (!hasLinkedAccount) {
                LangUtil.Message formatOption = LangUtil.Message.LINKED_ACCOUNT_REQUIRED;
                String format = formatOption.toString();
                if (format != null && !format.isEmpty()) {
                    String output;
                    String msg = event.getMessage().getContentRaw();
                    String string5 = "%message%";
                    String strippedSuffix = "...";
                    int maxLength = 2000;
                    int messagelessLength = format.replace(string5, "").length();
                    if (messagelessLength + msg.length() > maxLength) {
                        int adjustedLength = maxLength - messagelessLength;
                        if (adjustedLength <= 0) {
                            DiscordSRV.error(formatOption.getKeyName() + " cannot fit " + string5 + " within " + maxLength + " characters");
                            output = format.substring(0, maxLength);
                        } else {
                            int suffixLength = strippedSuffix.length();
                            if (adjustedLength > suffixLength) {
                                msg = msg.substring(0, adjustedLength -= suffixLength) + strippedSuffix;
                            }
                            output = format.replace(string5, msg);
                        }
                    } else {
                        output = format.replace(string5, msg);
                    }
                    event.getAuthor().openPrivateChannel().queue(privateChannel -> privateChannel.sendMessage(output).queue());
                }
                DiscordUtil.deleteMessage(event.getMessage());
                return;
            }
        }
        if (DiscordSRV.config().getBoolean("DiscordChatChannelBlockBots") && event.getAuthor().isBot() && !event.isWebhookMessage()) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Received Discord message from bot " + event.getAuthor() + " but DiscordChatChannelBlockBots is on");
            return;
        }
        if (DiscordSRV.config().getStringList("DiscordChatChannelBlockedIds").contains(event.getAuthor().getId())) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Received Discord message from user " + event.getAuthor() + " but they are on the DiscordChatChannelBlockedIds list");
            return;
        }
        if (!event.isWebhookMessage()) {
            boolean hasRole = DiscordSRV.config().getStringList("DiscordChatChannelBlockedRolesIds").stream().anyMatch(id -> event.getMember().getRoles().stream().anyMatch(r -> r.getId().equals(id)));
            boolean whitelist = DiscordSRV.config().getBoolean("DiscordChatChannelBlockedRolesAsWhitelist");
            if (whitelist != hasRole) {
                DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Received Discord message from user " + event.getAuthor() + " but they " + (whitelist ? "don't " : "") + "have a role from the DiscordChatChannelBlockedRolesIds list");
                event.getMessage().addReaction("\u274c").queue();
                return;
            }
        }
        if ((preEvent = DiscordSRV.api.callEvent(new DiscordGuildMessagePreProcessEvent(event))).isCancelled()) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "DiscordGuildMessagePreProcessEvent was cancelled, message send aborted");
            return;
        }
        List<Role> selectedRoles = !event.isWebhookMessage() ? DiscordSRV.getPlugin().getSelectedRoles(event.getMember()) : Collections.emptyList();
        Role role = topRole = !selectedRoles.isEmpty() ? (Role)selectedRoles.get(0) : null;
        if (!event.getMessage().getAttachments().isEmpty()) {
            for (Message.Attachment attachment : event.getMessage().getAttachments().subList(0, Math.min(event.getMessage().getAttachments().size(), 3))) {
                if (!this.handleMessageAddons(event, preEvent, selectedRoles, topRole, attachment.getUrl())) continue;
                return;
            }
        }
        if (!event.getMessage().getStickers().isEmpty()) {
            for (MessageSticker messageSticker : event.getMessage().getStickers().subList(0, Math.min(event.getMessage().getStickers().size(), 3))) {
                if (!this.handleMessageAddons(event, preEvent, selectedRoles, topRole, messageSticker.getIconUrl())) continue;
                return;
            }
        }
        if (StringUtils.isBlank(event.getMessage().getContentRaw())) {
            return;
        }
        for (Map.Entry entry : DiscordSRV.getPlugin().getDiscordRegexes().entrySet()) {
            String string6 = ((Pattern)entry.getKey()).matcher((CharSequence)var3_6).replaceAll((String)entry.getValue());
            if (!StringUtils.isBlank(string6)) continue;
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Not processing Discord message because it was cleared by a filter: " + ((Pattern)entry.getKey()).pattern());
            return;
        }
        if (var3_6.length() > DiscordSRV.config().getInt("DiscordChatChannelTruncateLength")) {
            event.getMessage().addReaction("\ud83d\udcac").queue(v -> event.getMessage().addReaction("\u2757").queue());
            String string7 = var3_6.substring(0, DiscordSRV.config().getInt("DiscordChatChannelTruncateLength"));
        }
        boolean bl4 = bl2 = !(rolesAllowedToColor = DiscordSRV.config().getStringList("DiscordChatChannelRolesAllowedToUseColorCodesInChat")).contains("@everyone");
        if (!event.isWebhookMessage()) {
            for (Role role2 : event.getMember().getRoles()) {
                if (!rolesAllowedToColor.contains(role2.getName()) && !rolesAllowedToColor.contains(role2.getId())) continue;
                bl = false;
            }
        }
        if (bl) {
            void var3_9;
            String string8 = MessageUtil.stripLegacy((String)var3_9);
        }
        String destinationGameChannelNameForTextChannel = DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel());
        String formatMessage = MessageFormatResolver.getMessageFormat(selectedRoles, destinationGameChannelNameForTextChannel);
        String string9 = var3_11 != null ? var3_11 : "<blank message>";
        boolean isLegacy = MessageUtil.isLegacy(string9) || MessageUtil.isLegacy(formatMessage);
        Component reserialized = MessageUtil.reserializeToMinecraftBasedOnConfig(string9);
        String string10 = string2 = bl ? PlainTextComponentSerializer.plainText().serialize(reserialized) : MessageUtil.toPlain(reserialized, isLegacy);
        if (!isLegacy && bl) {
            String string11 = MessageUtil.escapeMiniTokens(string2);
        }
        if (StringUtils.isBlank(string = DiscordUtil.convertMentionsToNames((String)var3_15))) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Ignoring message from " + event.getAuthor() + " because it became completely blank after reserialization (emote filtering)");
            return;
        }
        String emojiBehavior = DiscordSRV.config().getString("DiscordChatChannelEmojiBehavior");
        boolean hideEmoji = emojiBehavior.equalsIgnoreCase("hide");
        if (hideEmoji && StringUtils.isBlank(EmojiParser.removeAllEmojis(string))) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Ignoring message from " + event.getAuthor() + " because it became completely blank after removing unicode emojis");
            return;
        }
        formatMessage = this.replacePlaceholders(formatMessage, event, selectedRoles);
        formatMessage = MessageUtil.translateLegacy(formatMessage);
        if (!emojiBehavior.equalsIgnoreCase("show")) {
            if (hideEmoji) {
                String string12 = EmojiParser.removeAllEmojis(string);
            } else {
                String string13 = EmojiParser.parseToAliases(string);
            }
        }
        OfflinePlayer authorPlayer = null;
        UUID authorLinkedUuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getAuthor().getId());
        if (authorLinkedUuid != null) {
            authorPlayer = Bukkit.getOfflinePlayer((UUID)authorLinkedUuid);
        }
        if (!MessageUtil.isLegacy(formatMessage = PlaceholderUtil.replacePlaceholders(formatMessage, authorPlayer))) {
            formatMessage = formatMessage.replace("%toprolecolor%", "<white>%toprolecolor%");
        }
        Component component = MessageUtil.toComponent(formatMessage);
        void finalMessage = var3_19;
        component = this.replaceRoleColorAndMessage(component, (String)finalMessage, topRole != null ? topRole.getColorRaw() : 10070709);
        DiscordGuildMessagePostProcessEvent postEvent = DiscordSRV.api.callEvent(new DiscordGuildMessagePostProcessEvent(event, preEvent.isCancelled(), component));
        if (postEvent.isCancelled()) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "DiscordGuildMessagePostProcessEvent was cancelled, message send aborted");
            return;
        }
        DiscordSRV.getPlugin().getPluginHooks().stream().filter(pluginHook -> pluginHook instanceof DynmapHook).map(pluginHook -> (DynmapHook)pluginHook).findAny().ifPresent(arg_0 -> this.lambda$onGuildMessageReceived$7(event, selectedRoles, (String)finalMessage, emojiBehavior, hideEmoji, arg_0));
        DiscordSRV.getPlugin().broadcastMessageToMinecraftServer(DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel()), postEvent.getMinecraftMessage(), event.getAuthor());
    }

    private boolean handleMessageAddons(GuildMessageReceivedEvent event, DiscordGuildMessagePreProcessEvent preEvent, List<Role> selectedRoles, Role topRole, String url) {
        for (Map.Entry<Pattern, String> entry : DiscordSRV.getPlugin().getDiscordRegexes().entrySet()) {
            url = entry.getKey().matcher(url).replaceAll(entry.getValue());
            if (!StringUtils.isBlank(url)) continue;
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Not processing Discord message addon because its URL was cleared by a filter: " + entry.getKey().pattern());
            return false;
        }
        String destinationGameChannelNameForTextChannel = DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel());
        String placedMessage = MessageFormatResolver.getMessageFormat(selectedRoles, destinationGameChannelNameForTextChannel);
        placedMessage = MessageUtil.translateLegacy(this.replacePlaceholders(placedMessage, event, selectedRoles));
        OfflinePlayer authorPlayer = null;
        UUID authorLinkedUuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getAuthor().getId());
        if (authorLinkedUuid != null) {
            authorPlayer = Bukkit.getOfflinePlayer((UUID)authorLinkedUuid);
        }
        placedMessage = PlaceholderUtil.replacePlaceholders(placedMessage, authorPlayer);
        if (!MessageUtil.isLegacy(placedMessage = DiscordUtil.convertMentionsToNames(placedMessage))) {
            placedMessage = placedMessage.replace("%toprolecolor%", "<white>%toprolecolor%");
        }
        Component component = MessageUtil.toComponent(placedMessage);
        component = this.replaceRoleColorAndMessage(component, url, topRole != null ? topRole.getColorRaw() : 10070709);
        DiscordGuildMessagePostProcessEvent postEvent = DiscordSRV.api.callEvent(new DiscordGuildMessagePostProcessEvent(event, preEvent.isCancelled(), component));
        if (postEvent.isCancelled()) {
            DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "DiscordGuildMessagePostProcessEvent was cancelled, attachment send aborted");
            return true;
        }
        DiscordSRV.getPlugin().broadcastMessageToMinecraftServer(DiscordSRV.getPlugin().getDestinationGameChannelNameForTextChannel(event.getChannel()), component, event.getAuthor());
        return false;
    }

    private Component replaceRoleColorAndMessage(Component component, String message, int color) {
        return component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(TOP_ROLE_COLOR_PATTERN).replacement(builder -> builder.content(builder.content().replaceFirst("%toprolecolor%", "")).color(TextColor.color(color))).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(MESSAGE_MATTER).replacement(builder -> MessageUtil.toComponent(message)).build());
    }

    private String getTopRoleAlias(Role role) {
        if (role == null) {
            return "";
        }
        String name = role.getName();
        return DiscordSRV.getPlugin().getRoleAliases().getOrDefault(role.getId(), DiscordSRV.getPlugin().getRoleAliases().getOrDefault(name.toLowerCase(), name));
    }

    private String replacePlaceholders(String input, GuildMessageReceivedEvent event, List<Role> selectedRoles) {
        Function<String, String> escape = MessageUtil.isLegacy(input) ? str -> str : str -> str.replaceAll("([<>])", "\\\\$1");
        return input.replace("%channelname%", event.getChannel().getName()).replace("%name%", escape.apply(MessageUtil.strip(event.getMember() != null ? event.getMember().getEffectiveName() : event.getAuthor().getName()))).replace("%username%", escape.apply(MessageUtil.strip(event.getAuthor().getName()))).replace("%userid%", event.getAuthor().getId()).replace("%toprole%", escape.apply(DiscordUtil.getRoleName(!selectedRoles.isEmpty() ? selectedRoles.get(0) : null))).replace("%toproleinitial%", !selectedRoles.isEmpty() ? (CharSequence)escape.apply(DiscordUtil.getRoleName(selectedRoles.get(0)).substring(0, 1)) : "").replace("%toprolealias%", this.getTopRoleAlias(!selectedRoles.isEmpty() ? selectedRoles.get(0) : null)).replace("%allroles%", escape.apply(DiscordUtil.getFormattedRoles(selectedRoles))).replace("%reply%", this.replaceReplyPlaceholders(LangUtil.Message.CHAT_TO_MINECRAFT_REPLY.toString(), event.getMessage().getReferencedMessage())).replace("\\~", "~").replace("\\*", "*").replace("\\_", "_");
    }

    private String replaceReplyPlaceholders(String format, Message repliedMessage) {
        if (repliedMessage == null) {
            return "";
        }
        boolean isLegacy = MessageUtil.isLegacy(format);
        String message = repliedMessage.getContentRaw();
        Component reserialized = MessageUtil.reserializeToMinecraftBasedOnConfig(message);
        message = MessageUtil.toPlain(reserialized, isLegacy);
        if (!isLegacy) {
            message = MessageUtil.escapeMiniTokens(message);
        }
        Function<String, String> escape = isLegacy ? str -> str : str -> str.replaceAll("([<>])", "\\\\$1");
        String repliedUserName = repliedMessage.getMember() != null ? repliedMessage.getMember().getEffectiveName() : repliedMessage.getAuthor().getName();
        return format.replace("%name%", escape.apply(MessageUtil.strip(repliedUserName))).replace("%username%", escape.apply(MessageUtil.strip(repliedMessage.getAuthor().getName()))).replace("%userid%", repliedMessage.getAuthor().getId()).replace("%message%", message);
    }

    private boolean processPlayerListCommand(GuildMessageReceivedEvent event, String message) {
        String playerListMessage;
        if (!DiscordSRV.config().getBoolean("DiscordChatChannelListCommandEnabled")) {
            return false;
        }
        if (!StringUtils.trimToEmpty(message).equalsIgnoreCase(DiscordSRV.config().getString("DiscordChatChannelListCommandMessage"))) {
            return false;
        }
        int expiration = DiscordSRV.config().getInt("DiscordChatChannelListCommandExpiration") * 1000;
        if (PlayerUtil.getOnlinePlayers(true).size() == 0) {
            playerListMessage = PlaceholderUtil.replacePlaceholdersToDiscord(LangUtil.Message.PLAYER_LIST_COMMAND_NO_PLAYERS.toString());
        } else {
            playerListMessage = LangUtil.Message.PLAYER_LIST_COMMAND.toString().replace("%playercount%", PlayerUtil.getOnlinePlayers(true).size() + "/" + Bukkit.getMaxPlayers());
            playerListMessage = PlaceholderUtil.replacePlaceholdersToDiscord(playerListMessage);
            playerListMessage = playerListMessage + "\n```\n";
            StringJoiner players = new StringJoiner(LangUtil.Message.PLAYER_LIST_COMMAND_ALL_PLAYERS_SEPARATOR.toString());
            LinkedList<String> playerList = new LinkedList<String>();
            for (Player player : PlayerUtil.getOnlinePlayers(true)) {
                String userPrimaryGroup = VaultHook.getPrimaryGroup(player);
                boolean hasGoodGroup = StringUtils.isNotBlank(userPrimaryGroup);
                if (hasGoodGroup) {
                    userPrimaryGroup = userPrimaryGroup.substring(0, 1).toUpperCase() + userPrimaryGroup.substring(1);
                }
                String playerFormat = LangUtil.Message.PLAYER_LIST_COMMAND_PLAYER.toString().replace("%username%", player.getName()).replace("%displayname%", MessageUtil.strip(player.getDisplayName())).replace("%primarygroup%", userPrimaryGroup).replace("%world%", player.getWorld().getName()).replace("%worldalias%", MessageUtil.strip(DiscordSRV.getPlugin().getWorldAlias(player.getWorld().getName())));
                playerFormat = PlaceholderUtil.replacePlaceholdersToDiscord(playerFormat, (OfflinePlayer)player);
                playerList.add(playerFormat);
            }
            playerList.sort(Comparator.naturalOrder());
            for (String playerFormat : playerList) {
                players.add(playerFormat);
            }
            if ((playerListMessage = playerListMessage + players.toString()).length() > 1996) {
                playerListMessage = playerListMessage.substring(0, 1993) + "...";
            }
            playerListMessage = playerListMessage + "\n```";
        }
        DiscordChatChannelListCommandMessageEvent listCommandMessageEvent = DiscordSRV.api.callEvent(new DiscordChatChannelListCommandMessageEvent(event.getChannel(), event.getGuild(), message, event, playerListMessage, expiration, DiscordChatChannelListCommandMessageEvent.Result.SEND_RESPONSE));
        switch (listCommandMessageEvent.getResult()) {
            case SEND_RESPONSE: {
                DiscordUtil.sendMessage(event.getChannel(), listCommandMessageEvent.getPlayerListMessage(), listCommandMessageEvent.getExpiration());
                if (listCommandMessageEvent.getExpiration() > 0 && DiscordSRV.config().getBoolean("DiscordChatChannelListCommandExpirationDeleteRequest")) {
                    event.getMessage().delete().queueAfter(listCommandMessageEvent.getExpiration(), TimeUnit.MILLISECONDS);
                }
                return true;
            }
            case NO_ACTION: {
                return true;
            }
            case TREAT_AS_REGULAR_MESSAGE: {
                return false;
            }
        }
        return true;
    }

    private boolean processConsoleCommand(GuildMessageReceivedEvent event, String message) {
        DiscordConsoleCommandPreProcessEvent consoleEvent;
        String command;
        block14: {
            boolean commandIsAbleToBeUsed;
            boolean allowed;
            if (!DiscordSRV.config().getBoolean("DiscordChatChannelConsoleCommandEnabled")) {
                return false;
            }
            String prefix = DiscordSRV.config().getString("DiscordChatChannelConsoleCommandPrefix");
            if (prefix.isEmpty()) {
                return false;
            }
            if (!StringUtils.startsWithIgnoreCase(message, prefix)) {
                return false;
            }
            command = message.substring(prefix.length()).trim();
            HashSet<String> rolesAllowedToConsole = new HashSet<String>();
            rolesAllowedToConsole.addAll(DiscordSRV.config().getStringList("DiscordChatChannelConsoleCommandRolesAllowed"));
            rolesAllowedToConsole.addAll(DiscordSRV.config().getStringList("DiscordChatChannelConsoleCommandWhitelistBypassRoles"));
            boolean bl = allowed = event.isWebhookMessage() || DiscordUtil.memberHasRole(event.getMember(), rolesAllowedToConsole);
            if (!allowed) {
                if (DiscordSRV.config().getBoolean("DiscordChatChannelConsoleCommandNotifyErrors")) {
                    String e = LangUtil.Message.CHAT_CHANNEL_COMMAND_ERROR.toString().replace("%user%", event.getAuthor().getName()).replace("%error%", "no permission");
                    event.getAuthor().openPrivateChannel().queue(dm -> dm.sendMessage(e).queue(null, t -> {
                        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Failed to send DM to " + event.getAuthor() + ": " + t.getMessage());
                        event.getChannel().sendMessage(e).queue();
                    }), t -> {
                        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Failed to open DM conversation with " + event.getAuthor() + ": " + t.getMessage());
                        event.getChannel().sendMessage(e).queue();
                    });
                }
                return true;
            }
            boolean canBypass = false;
            for (String roleName : DiscordSRV.config().getStringList("DiscordChatChannelConsoleCommandWhitelistBypassRoles")) {
                boolean isAble = DiscordUtil.memberHasRole(event.getMember(), Collections.singleton(roleName));
                canBypass = isAble || canBypass;
            }
            if (canBypass) {
                commandIsAbleToBeUsed = true;
            } else {
                String requestedCommand = command.split(" ")[0];
                boolean whitelistActsAsBlacklist = DiscordSRV.config().getBoolean("DiscordChatChannelConsoleCommandWhitelistActsAsBlacklist");
                List<String> commandsToCheck = DiscordSRV.config().getStringList("DiscordChatChannelConsoleCommandWhitelist");
                boolean isListed = commandsToCheck.contains(requestedCommand);
                commandIsAbleToBeUsed = isListed ^ whitelistActsAsBlacklist;
            }
            if (!commandIsAbleToBeUsed) {
                if (DiscordSRV.config().getBoolean("DiscordChatChannelConsoleCommandNotifyErrors")) {
                    String e = LangUtil.Message.CHAT_CHANNEL_COMMAND_ERROR.toString().replace("%user%", event.getAuthor().getName()).replace("%error%", "command is not able to be used");
                    event.getAuthor().openPrivateChannel().queue(dm -> dm.sendMessage(e).queue(null, t -> {
                        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Failed to send DM to " + event.getAuthor() + ": " + t.getMessage());
                        event.getChannel().sendMessage(e).queue();
                    }), t -> {
                        DiscordSRV.debug(Debug.DISCORD_TO_MINECRAFT, "Failed to open DM conversation with " + event.getAuthor() + ": " + t.getMessage());
                        event.getChannel().sendMessage(e).queue();
                    });
                }
                return true;
            }
            File logFile = DiscordSRV.getPlugin().getLogFile();
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile(logFile, "[" + TimeUtil.timeStamp() + " | ID " + event.getAuthor().getId() + "] " + event.getAuthor().getName() + ": " + event.getMessage().getContentRaw() + System.lineSeparator(), StandardCharsets.UTF_8, true);
                }
                catch (IOException e) {
                    DiscordSRV.error((Object)((Object)LangUtil.InternalMessage.ERROR_LOGGING_CONSOLE_ACTION) + " " + logFile.getAbsolutePath() + ": " + e.getMessage());
                    if (!DiscordSRV.config().getBoolean("CancelConsoleCommandIfLoggingFailed")) break block14;
                    return true;
                }
            }
        }
        if ((consoleEvent = DiscordSRV.api.callEvent(new DiscordConsoleCommandPreProcessEvent(event, command, false))).isCancelled()) {
            return true;
        }
        SchedulerUtil.runTask((Plugin)DiscordSRV.getPlugin(), () -> {
            CommandSender preferredSender = this.useFeedbackForwardingSender ? new PaperForwardingCommandSender(event).getFeedbackSender() : new CommandSenderDynamicProxy((CommandSender)Bukkit.getConsoleSender(), event).getProxy();
            Bukkit.getServer().dispatchCommand(preferredSender, consoleEvent.getCommand());
        });
        DiscordSRV.api.callEvent(new DiscordConsoleCommandPostProcessEvent(event, consoleEvent.getCommand(), false));
        return true;
    }
}

