/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.DiscordConsoleCommandPostProcessEvent;
import github.scarsz.discordsrv.api.events.DiscordConsoleCommandPreProcessEvent;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DiscordConsoleListener
extends ListenerAdapter {
    @Override
    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        DiscordConsoleCommandPreProcessEvent consoleEvent;
        block10: {
            if (DiscordUtil.getJda() == null) {
                return;
            }
            if (event.getAuthor().getId().equals(DiscordUtil.getJda().getSelfUser().getId())) {
                return;
            }
            if (DiscordSRV.getPlugin().getConsoleChannel() == null || !event.getChannel().getId().equals(DiscordSRV.getPlugin().getConsoleChannel().getId())) {
                return;
            }
            if (DiscordSRV.config().getBoolean("DiscordConsoleChannelBlockBots") && event.getAuthor().isBot()) {
                DiscordSRV.debug(Debug.UNCATEGORIZED, "Received a message from a bot in the console channel, but DiscordConsoleChannelBlockBots is enabled");
                return;
            }
            boolean isWhitelist = DiscordSRV.config().getBoolean("DiscordConsoleChannelBlacklistActsAsWhitelist");
            List<String> blacklistedCommands = DiscordSRV.config().getStringList("DiscordConsoleChannelBlacklistedCommands");
            for (int i = 0; i < blacklistedCommands.size(); ++i) {
                blacklistedCommands.set(i, blacklistedCommands.get(i).toLowerCase());
            }
            String requestedCommand = event.getMessage().getContentRaw().trim().split(" ")[0].toLowerCase();
            if (isWhitelist != blacklistedCommands.contains(requestedCommand = requestedCommand.substring(requestedCommand.lastIndexOf(":") + 1))) {
                return;
            }
            File logFile = DiscordSRV.getPlugin().getLogFile();
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile(logFile, "[" + TimeUtil.timeStamp() + " | ID " + event.getAuthor().getId() + "] " + event.getAuthor().getName() + ": " + event.getMessage().getContentRaw() + System.lineSeparator(), StandardCharsets.UTF_8, true);
                }
                catch (IOException e) {
                    DiscordSRV.error((Object)((Object)LangUtil.InternalMessage.ERROR_LOGGING_CONSOLE_ACTION) + " " + logFile.getAbsolutePath() + ": " + e.getMessage());
                    if (!DiscordSRV.config().getBoolean("CancelConsoleCommandIfLoggingFailed")) break block10;
                    return;
                }
            }
        }
        if ((consoleEvent = DiscordSRV.api.callEvent(new DiscordConsoleCommandPreProcessEvent(event, event.getMessage().getContentRaw(), true))).isCancelled()) {
            return;
        }
        DiscordSRV.getPlugin().getConsoleAppender().dumpStack();
        SchedulerUtil.runTask((Plugin)DiscordSRV.getPlugin(), () -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), consoleEvent.getCommand()));
        DiscordSRV.api.callEvent(new DiscordConsoleCommandPostProcessEvent(event, consoleEvent.getCommand(), true));
    }
}

