/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.events.DisconnectEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.ShutdownEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.requests.CloseCode;
import github.scarsz.discordsrv.dependencies.jda.api.requests.GatewayIntent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DiscordDisconnectListener
extends ListenerAdapter {
    public static CloseCode mostRecentCloseCode = null;

    @Override
    public void onDisconnect(@NotNull DisconnectEvent event) {
        this.handleCode(event.getCloseCode());
    }

    @Override
    public void onShutdown(@NotNull ShutdownEvent event) {
        this.handleCode(event.getCloseCode());
    }

    private void handleCode(CloseCode closeCode) {
        if (closeCode == null) {
            return;
        }
        mostRecentCloseCode = closeCode;
        if (closeCode == CloseCode.DISALLOWED_INTENTS) {
            Set<GatewayIntent> intents = DiscordSRV.api.getIntents();
            boolean presences = intents.contains((Object)GatewayIntent.GUILD_PRESENCES);
            DiscordSRV.getPlugin().disablePlugin();
            DiscordSRV.getPlugin().getLogger().severe("==============================================================");
            DiscordSRV.getPlugin().getLogger().severe(" ");
            DiscordSRV.getPlugin().getLogger().severe(" *** PLEASE FOLLOW THE INSTRUCTIONS BELOW TO GET DiscordSRV TO WORK *** ");
            DiscordSRV.getPlugin().getLogger().severe(" ");
            DiscordSRV.getPlugin().getLogger().severe(" Your DiscordSRV bot is missing one or more of the following intents: " + (presences ? "Guild Presences, " : "") + "Server Members Intent, Message Content Intent!");
            DiscordSRV.getPlugin().getLogger().severe(" DiscordSRV " + (presences && !DiscordSRV.config().getBooleanElse("EnablePresenceInformation", false) ? "and its API hooks require these intents" : "requires " + (presences ? "these intents" : "this intent")) + " to function. Instructions:");
            DiscordSRV.getPlugin().getLogger().severe("  1. Go to https://discord.com/developers/applications");
            DiscordSRV.getPlugin().getLogger().severe("  2. Click on the DiscordSRV bot");
            DiscordSRV.getPlugin().getLogger().severe("  3. Click on \"Bot\" on the left");
            DiscordSRV.getPlugin().getLogger().severe("  4. Enable the " + (presences ? "\"PRESENCE INTENT\", " : "") + "\"SERVER MEMBERS INTENT\" and \"MESSAGE CONTENT INTENT\"");
            DiscordSRV.getPlugin().getLogger().severe("  5. Restart your server");
            DiscordSRV.getPlugin().getLogger().severe(" ");
            DiscordSRV.getPlugin().getLogger().severe("==============================================================");
        } else if (!closeCode.isReconnect()) {
            DiscordSRV.getPlugin().disablePlugin();
            DiscordDisconnectListener.printDisconnectMessage(false, closeCode == CloseCode.AUTHENTICATION_FAILED ? "The bot token is invalid" : closeCode.getMeaning());
        }
    }

    public static void printDisconnectMessage(boolean startup, String message) {
        DiscordSRV.getPlugin().getLogger().severe("===================================================");
        DiscordSRV.getPlugin().getLogger().severe(" ");
        DiscordSRV.getPlugin().getLogger().severe(" " + (startup ? "DiscordSRV could not connect to Discord because" : "DiscordSRV was disconnected from Discord because") + ":");
        DiscordSRV.getPlugin().getLogger().severe(" " + message);
        DiscordSRV.getPlugin().getLogger().severe(" ");
        DiscordSRV.getPlugin().getLogger().severe("===================================================");
    }
}

