/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.AchievementMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.AchievementMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PrettyUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiFunction;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class PlayerAchievementsListener {
    private final RegisteredListener registeredListener = new RegisteredListener(new Listener(){}, new EventExecutor(){

        public void execute(Listener listener, Event event) {
            PlayerAchievementsListener.this.onPlayerAchievementAwarded(event);
        }
    }, EventPriority.MONITOR, (Plugin)DiscordSRV.getPlugin(), false);
    private HandlerList handlerList;

    public PlayerAchievementsListener() {
        try {
            Class<?> achievementAwardedEventClass = Class.forName("org.bukkit.event.player.PlayerAchievementAwardedEvent");
            if (achievementAwardedEventClass.isAnnotationPresent(Deprecated.class)) {
                return;
            }
            this.handlerList = (HandlerList)achievementAwardedEventClass.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            this.handlerList.register(this.registeredListener);
        }
        catch (ClassNotFoundException achievementAwardedEventClass) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            DiscordSRV.error("Failed to get the handler list for PlayerAchievementAwardedEvent, achievement events will not function");
        }
    }

    public void onPlayerAchievementAwarded(Event event) {
        if (event == null) {
            return;
        }
        Player player = ((PlayerEvent)event).getPlayer();
        if (PlayerUtil.isVanished(player)) {
            return;
        }
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.runAsync(event, player));
    }

    private void runAsync(Event event, Player player) {
        TextChannel destinationChannel;
        Enum achievement;
        try {
            achievement = (Enum)event.getClass().getMethod("getAchievement", new Class[0]).invoke((Object)event, new Object[0]);
            if (achievement == null) {
                return;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            DiscordSRV.error("Failed to get achievement name from " + event.getEventName() + ": " + e.getMessage());
            this.handlerList.unregister(this.registeredListener);
            return;
        }
        String channelName = DiscordSRV.getPlugin().getOptionalChannel("awards");
        String achievementName = PrettyUtil.beautify(achievement);
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerAchievementMessage");
        if (messageFormat == null) {
            return;
        }
        AchievementMessagePreProcessEvent preEvent = DiscordSRV.api.callEvent(new AchievementMessagePreProcessEvent(channelName, messageFormat, player, achievementName, event));
        if (preEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "AchievementMessagePreProcessEvent was cancelled, message send aborted");
            return;
        }
        achievementName = preEvent.getAchievementName();
        channelName = preEvent.getChannel();
        messageFormat = preEvent.getMessageFormat();
        if (messageFormat == null) {
            return;
        }
        String finalAchievementName = StringUtils.isNotBlank(achievementName) ? achievementName : "";
        String avatarUrl = DiscordSRV.getAvatarUrl(player);
        String botAvatarUrl = DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl();
        String botName = DiscordSRV.getPlugin().getMainGuild() != null ? DiscordSRV.getPlugin().getMainGuild().getSelfMember().getEffectiveName() : DiscordUtil.getJda().getSelfUser().getName();
        String displayName = StringUtils.isNotBlank(player.getDisplayName()) ? MessageUtil.strip(player.getDisplayName()) : "";
        BiFunction<String, Boolean, String> translator = (arg_0, arg_1) -> PlayerAchievementsListener.lambda$runAsync$1(player, displayName, finalAchievementName, avatarUrl, botAvatarUrl, botName, destinationChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName), arg_0, arg_1);
        Message discordMessage = DiscordSRV.translateMessage(messageFormat, translator);
        if (discordMessage == null) {
            return;
        }
        String webhookName = translator.apply(messageFormat.getWebhookName(), false);
        String webhookAvatarUrl = translator.apply(messageFormat.getWebhookAvatarUrl(), false);
        AchievementMessagePostProcessEvent postEvent = DiscordSRV.api.callEvent(new AchievementMessagePostProcessEvent(channelName, discordMessage, player, achievementName, event, messageFormat.isUseWebhooks(), webhookName, webhookAvatarUrl, preEvent.isCancelled()));
        if (postEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "AchievementMessagePostProcessEvent was cancelled, message send aborted");
            return;
        }
        channelName = postEvent.getChannel();
        discordMessage = postEvent.getDiscordMessage();
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName);
        if (postEvent.isUsingWebhooks()) {
            WebhookUtil.deliverMessage(textChannel, postEvent.getWebhookName(), postEvent.getWebhookAvatarUrl(), discordMessage.getContentRaw(), (MessageEmbed)discordMessage.getEmbeds().stream().findFirst().orElse(null));
        } else {
            DiscordUtil.queueMessage(textChannel, discordMessage, true);
        }
    }

    private static /* synthetic */ String lambda$runAsync$1(Player player, String displayName, String finalAchievementName, String avatarUrl, String botAvatarUrl, String botName, TextChannel destinationChannel, String content, Boolean needsEscape) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%username%", needsEscape != false ? DiscordUtil.escapeMarkdown(player.getName()) : player.getName()).replace("%displayname%", needsEscape != false ? DiscordUtil.escapeMarkdown(displayName) : displayName).replace("%usernamenoescapes%", player.getName()).replace("%displaynamenoescapes%", displayName).replace("%world%", player.getWorld().getName()).replace("%achievement%", MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(finalAchievementName) : finalAchievementName)).replace("%embedavatarurl%", avatarUrl).replace("%botavatarurl%", botAvatarUrl).replace("%botname%", botName);
        if (destinationChannel != null) {
            content = DiscordUtil.translateEmotes(content, destinationChannel.getGuild());
        }
        content = PlaceholderUtil.replacePlaceholdersToDiscord(content, (OfflinePlayer)player);
        return content;
    }
}

