/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.AchievementMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.AchievementMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.NMSUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.plugin.Plugin;

public class PlayerAdvancementDoneListener
implements Listener {
    private static final boolean GAMERULE_CLASS_AVAILABLE;
    private static final Object GAMERULE;
    private static Method ADVANCEMENT_GET_DISPLAY_METHOD;
    private static Method ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD;
    private static final Map<NamespacedKey, String> ADVANCEMENT_TITLE_CACHE;
    private static Method method_getAdvancementFromHolder;
    private static Method method_getAdvancementDisplay;

    public PlayerAdvancementDoneListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DiscordSRV.getPlugin());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAdvancementDone(PlayerAdvancementDoneEvent event) {
        Player player = event.getPlayer();
        if (event.getAdvancement() == null || player == null) {
            return;
        }
        if (PlayerUtil.isVanished(player)) {
            return;
        }
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.runAsync(event));
    }

    private void runAsync(PlayerAdvancementDoneEvent event) {
        TextChannel destinationChannel;
        Player player = event.getPlayer();
        Advancement advancement = event.getAdvancement();
        if (this.advancementIsHiddenInChat(advancement, player.getWorld())) {
            return;
        }
        String channelName = DiscordSRV.getPlugin().getOptionalChannel("awards");
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerAchievementMessage");
        if (messageFormat == null) {
            return;
        }
        String advancementTitle = PlayerAdvancementDoneListener.getTitle(advancement);
        AchievementMessagePreProcessEvent preEvent = DiscordSRV.api.callEvent(new AchievementMessagePreProcessEvent(channelName, messageFormat, player, advancementTitle, (Event)event));
        if (preEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "AchievementMessagePreProcessEvent was cancelled, message send aborted");
            return;
        }
        advancementTitle = preEvent.getAchievementName();
        channelName = preEvent.getChannel();
        messageFormat = preEvent.getMessageFormat();
        if (messageFormat == null) {
            return;
        }
        String finalAchievementName = StringUtils.isNotBlank(advancementTitle) ? advancementTitle : "";
        String avatarUrl = DiscordSRV.getAvatarUrl(player);
        String botAvatarUrl = DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl();
        String botName = DiscordSRV.getPlugin().getMainGuild() != null ? DiscordSRV.getPlugin().getMainGuild().getSelfMember().getEffectiveName() : DiscordUtil.getJda().getSelfUser().getName();
        String displayName = StringUtils.isNotBlank(player.getDisplayName()) ? MessageUtil.strip(player.getDisplayName()) : "";
        BiFunction<String, Boolean, String> translator = (arg_0, arg_1) -> PlayerAdvancementDoneListener.lambda$runAsync$1(player, displayName, finalAchievementName, avatarUrl, botAvatarUrl, botName, destinationChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName), arg_0, arg_1);
        Message discordMessage = DiscordSRV.translateMessage(messageFormat, translator);
        if (discordMessage == null) {
            return;
        }
        String webhookName = translator.apply(messageFormat.getWebhookName(), false);
        String webhookAvatarUrl = translator.apply(messageFormat.getWebhookAvatarUrl(), false);
        AchievementMessagePostProcessEvent postEvent = DiscordSRV.api.callEvent(new AchievementMessagePostProcessEvent(channelName, discordMessage, player, advancementTitle, (Event)event, messageFormat.isUseWebhooks(), webhookName, webhookAvatarUrl, preEvent.isCancelled()));
        if (postEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "AchievementMessagePostProcessEvent was cancelled, message send aborted");
            return;
        }
        channelName = postEvent.getChannel();
        discordMessage = postEvent.getDiscordMessage();
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName);
        if (postEvent.isUsingWebhooks()) {
            WebhookUtil.deliverMessage(textChannel, postEvent.getWebhookName(), postEvent.getWebhookAvatarUrl(), discordMessage.getContentRaw(), (MessageEmbed)discordMessage.getEmbeds().stream().findFirst().orElse(null));
        } else {
            DiscordUtil.queueMessage(textChannel, discordMessage, true);
        }
    }

    private boolean advancementIsHiddenInChat(Advancement advancement, World world) {
        Boolean isGamerule;
        String key = advancement.getKey().getKey();
        if (key.contains("recipe/") || key.contains("recipes/")) {
            return true;
        }
        Boolean bl = isGamerule = GAMERULE_CLASS_AVAILABLE ? (Boolean)world.getGameRuleValue((GameRule)GAMERULE) : Boolean.valueOf(Boolean.parseBoolean(world.getGameRuleValue((String)GAMERULE)));
        if (Boolean.FALSE.equals(isGamerule)) {
            return true;
        }
        Object advancementDisplay = null;
        if (ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD == null) {
            try {
                if (ADVANCEMENT_GET_DISPLAY_METHOD == null) {
                    ADVANCEMENT_GET_DISPLAY_METHOD = Arrays.stream(advancement.getClass().getMethods()).filter(method -> method.getName().equals("getDisplay")).findFirst().orElse(null);
                }
                advancementDisplay = ADVANCEMENT_GET_DISPLAY_METHOD.invoke((Object)advancement, new Object[0]);
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Successfully invoked bukkit AdvancementDisplay method");
            }
            catch (Exception e) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to find PlayerAdvancementDoneEvent#getDisplay method");
            }
        }
        if (ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD != null || advancementDisplay == null) {
            try {
                Object craftAdvancement = NMSUtil.getHandle(advancement);
                Optional<Object> craftAdvancementDisplayOptional = PlayerAdvancementDoneListener.getAdvancementDisplayObject(craftAdvancement);
                if (!craftAdvancementDisplayOptional.isPresent()) {
                    return true;
                }
                Object craftAdvancementDisplay = craftAdvancementDisplayOptional.get();
                if (ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD == null) {
                    ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD = Arrays.stream(craftAdvancementDisplay.getClass().getMethods()).filter(method -> method.getReturnType().equals(Boolean.TYPE)).filter(method -> method.getName().equals("i")).findFirst().orElse(null);
                }
                boolean doesAnnounceToChat = (Boolean)ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD.invoke(craftAdvancementDisplay, new Object[0]);
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Successfully invoked NMS announce in chat");
                return !doesAnnounceToChat;
            }
            catch (Exception e) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to get NMS announceChat value: " + e);
            }
        }
        if (advancementDisplay != null && !advancementDisplay.getClass().getSimpleName().equals("PaperAdvancementDisplay") && advancementDisplay instanceof AdvancementDisplay) {
            return !((AdvancementDisplay)advancementDisplay).shouldAnnounceChat();
        }
        if (advancementDisplay instanceof io.papermc.paper.advancement.AdvancementDisplay) {
            return !((io.papermc.paper.advancement.AdvancementDisplay)advancementDisplay).doesAnnounceToChat();
        }
        try {
            Object craftAdvancement = NMSUtil.getHandle(advancement);
            assert (craftAdvancement != null);
            Optional<Object> craftAdvancementDisplayOptional = PlayerAdvancementDoneListener.getAdvancementDisplayObject(craftAdvancement);
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Successfully invoked nms AdvancementDisplay method");
            return !craftAdvancementDisplayOptional.isPresent();
        }
        catch (Exception e) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to check if advancement should be displayed: " + e);
            return false;
        }
    }

    public static String getTitle(Advancement advancement) {
        return ADVANCEMENT_TITLE_CACHE.computeIfAbsent(advancement.getKey(), v -> {
            try {
                Object handle = NMSUtil.getHandle(advancement);
                assert (handle != null);
                Optional<Object> advancementDisplayOptional = PlayerAdvancementDoneListener.getAdvancementDisplayObject(handle);
                if (!advancementDisplayOptional.isPresent()) {
                    throw new RuntimeException("Advancement doesn't have display properties");
                }
                Object advancementDisplay = advancementDisplayOptional.get();
                try {
                    Field advancementMessageField = advancementDisplay.getClass().getDeclaredField("a");
                    advancementMessageField.setAccessible(true);
                    Object advancementMessage = advancementMessageField.get(advancementDisplay);
                    Object advancementTitle = advancementMessage.getClass().getMethod("getString", new Class[0]).invoke(advancementMessage, new Object[0]);
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Successfully retrieved advancement title from getString");
                    return (String)advancementTitle;
                }
                catch (Exception e) {
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to get title of advancement using getString, trying JSON method");
                    Field titleComponentField = Arrays.stream(advancementDisplay.getClass().getDeclaredFields()).filter(field -> {
                        String simpleFieldName = field.getType().getSimpleName();
                        return simpleFieldName.equals("IChatBaseComponent") || simpleFieldName.equals("IChatMutableComponent") || simpleFieldName.equals("Component");
                    }).findFirst().orElseThrow(() -> new RuntimeException("Failed to find advancement display properties field"));
                    titleComponentField.setAccessible(true);
                    Object titleChatBaseComponent = titleComponentField.get(advancementDisplay);
                    Method method_getText = null;
                    try {
                        method_getText = titleChatBaseComponent.getClass().getMethod("getText", new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (method_getText == null) {
                        try {
                            method_getText = titleChatBaseComponent.getClass().getMethod("getString", new Class[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (method_getText != null) {
                        String title = (String)method_getText.invoke(titleChatBaseComponent, new Object[0]);
                        DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Successfully retrieved advancement title from component");
                        if (StringUtils.isNotBlank(title)) {
                            return title;
                        }
                    }
                    Class chatSerializerClass = Arrays.stream(titleChatBaseComponent.getClass().getDeclaredClasses()).filter(clazz -> clazz.getSimpleName().equals("ChatSerializer")).findFirst().orElseThrow(() -> new RuntimeException("Couldn't get component ChatSerializer class"));
                    String componentJson = (String)chatSerializerClass.getMethod("a", titleChatBaseComponent.getClass()).invoke(null, titleChatBaseComponent);
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Successfully retrieved advancement title from json");
                    return MessageUtil.toLegacy(GsonComponentSerializer.gson().deserialize(componentJson));
                }
            }
            catch (Exception e) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, e, "Failed to get title of advancement " + advancement.getKey().getKey() + ": " + e.getMessage());
                String rawAdvancementName = advancement.getKey().getKey();
                return Arrays.stream(rawAdvancementName.substring(rawAdvancementName.lastIndexOf("/") + 1).toLowerCase().split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
            }
        });
    }

    private static Optional<Object> getAdvancementDisplayObject(Object handle) throws IllegalAccessException, InvocationTargetException {
        if (handle.getClass().getSimpleName().equals("AdvancementHolder")) {
            if (method_getAdvancementFromHolder == null) {
                method_getAdvancementFromHolder = Arrays.stream(handle.getClass().getMethods()).filter(method -> method.getReturnType().getName().equals("net.minecraft.advancements.Advancement")).filter(method -> method.getParameterCount() == 0).findFirst().orElseThrow(() -> new RuntimeException("Failed to find Advancement from AdvancementHolder"));
            }
            if (method_getAdvancementFromHolder != null) {
                Object holder = method_getAdvancementFromHolder.invoke(handle, new Object[0]);
                if (method_getAdvancementDisplay == null) {
                    method_getAdvancementDisplay = Arrays.stream(holder.getClass().getMethods()).filter(method -> method.getReturnType().getSimpleName().equals("Optional")).filter(method -> {
                        String displayInfoReturnName = method.getGenericReturnType().getTypeName();
                        return displayInfoReturnName.contains("AdvancementDisplay") || displayInfoReturnName.contains("DisplayInfo");
                    }).findFirst().orElseThrow(() -> new RuntimeException("Failed to find AdvancementDisplay getter for advancement handle"));
                }
                Optional optionalAdvancementDisplay = (Optional)method_getAdvancementDisplay.invoke(holder, new Object[0]);
                return optionalAdvancementDisplay;
            }
        } else {
            if (method_getAdvancementDisplay == null) {
                method_getAdvancementDisplay = Arrays.stream(handle.getClass().getMethods()).filter(method -> {
                    String simpleReturnName = method.getReturnType().getSimpleName();
                    return simpleReturnName.equals("AdvancementDisplay") || simpleReturnName.equals("DisplayInfo");
                }).filter(method -> method.getParameterCount() == 0).findFirst().orElseThrow(() -> new RuntimeException("Failed to find AdvancementDisplay getter for advancement handle"));
            }
            return Optional.ofNullable(method_getAdvancementDisplay.invoke(handle, new Object[0]));
        }
        return Optional.empty();
    }

    private static /* synthetic */ String lambda$runAsync$1(Player player, String displayName, String finalAchievementName, String avatarUrl, String botAvatarUrl, String botName, TextChannel destinationChannel, String content, Boolean needsEscape) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%username%", needsEscape != false ? DiscordUtil.escapeMarkdown(player.getName()) : player.getName()).replace("%displayname%", needsEscape != false ? DiscordUtil.escapeMarkdown(displayName) : displayName).replace("%usernamenoescapes%", player.getName()).replace("%displaynamenoescapes%", displayName).replace("%world%", player.getWorld().getName()).replace("%achievement%", MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(finalAchievementName) : finalAchievementName)).replace("%embedavatarurl%", avatarUrl).replace("%botavatarurl%", botAvatarUrl).replace("%botname%", botName);
        if (destinationChannel != null) {
            content = DiscordUtil.translateEmotes(content, destinationChannel.getGuild());
        }
        content = PlaceholderUtil.replacePlaceholdersToDiscord(content, (OfflinePlayer)player);
        return content;
    }

    static {
        String gamerule = "announceAdvancements";
        Object gameruleValue = null;
        try {
            Class<?> gameRuleClass = Class.forName("org.bukkit.GameRule");
            gameruleValue = gameRuleClass.getMethod("getByName", String.class).invoke(null, gamerule);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        GAMERULE_CLASS_AVAILABLE = gameruleValue != null;
        GAMERULE = GAMERULE_CLASS_AVAILABLE ? gameruleValue : gamerule;
        ADVANCEMENT_GET_DISPLAY_METHOD = null;
        ADVANCEMENT_DISPLAY_ANNOUNCE_CHAT_METHOD = null;
        ADVANCEMENT_TITLE_CACHE = new ConcurrentHashMap<NamespacedKey, String>();
        method_getAdvancementFromHolder = null;
        method_getAdvancementDisplay = null;
    }
}

