/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.plugin.Plugin;

public class PlayerBanListener
implements Listener {
    public PlayerBanListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DiscordSRV.getPlugin());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        SchedulerUtil.runTaskLater((Plugin)DiscordSRV.getPlugin(), () -> {
            if (Bukkit.getBannedPlayers().contains(Bukkit.getOfflinePlayer((UUID)event.getPlayer().getUniqueId())) && event.getPlayer() instanceof OfflinePlayer) {
                if (!DiscordSRV.config().getBoolean("BanSynchronizationMinecraftToDiscord")) {
                    DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not handling ban for player " + event.getPlayer().getName() + " (" + event.getPlayer().getUniqueId() + ") because doing so is disabled in the config");
                    return;
                }
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Handling ban for player " + event.getPlayer().getName() + " (" + event.getPlayer().getUniqueId() + ")");
                DiscordUtil.banMember(DiscordUtil.getMemberById(DiscordSRV.getPlugin().getAccountLinkManager().getDiscordIdBypassCache(event.getPlayer().getUniqueId())));
            }
        }, 20L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!DiscordSRV.config().getBoolean("BanSynchronizationMinecraftToDiscord")) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not handling possible unban for player " + event.getPlayer().getName() + " (" + event.getPlayer().getUniqueId() + ") because doing so is disabled in the config");
            return;
        }
        CompletableFuture.runAsync(() -> {
            String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordIdBypassCache(event.getPlayer().getUniqueId());
            if (discordId == null) {
                return;
            }
            DiscordSRV.getPlugin().getMainGuild().retrieveBanById(discordId).queue(ban -> {
                DiscordSRV.info("Unbanning player " + event.getPlayer().getName() + " from Discord (ID " + discordId + ") because they aren't banned on the server");
                DiscordSRV.getPlugin().getMainGuild().unban(discordId).queue();
            }, failure -> DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to check if player " + event.getPlayer().getName() + " is banned in Discord: " + failure.getMessage()));
        });
    }
}

