/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.DeathMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.DeathMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDeathListener
implements Listener {
    public PlayerDeathListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DiscordSRV.getPlugin());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = event.getEntity();
        if (PlayerUtil.isVanished(player)) {
            return;
        }
        String message = event.getDeathMessage();
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.runAsync(event, player, message));
    }

    private void runAsync(PlayerDeathEvent event, Player player, String deathMessage) {
        TextChannel destinationChannel;
        if (StringUtils.isBlank(deathMessage)) {
            DiscordSRV.debug("Not sending death message for " + player.getName() + ", the death message is null");
            return;
        }
        String channelName = DiscordSRV.getPlugin().getOptionalChannel("deaths");
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerDeathMessage");
        if (messageFormat == null) {
            return;
        }
        DeathMessagePreProcessEvent preEvent = DiscordSRV.api.callEvent(new DeathMessagePreProcessEvent(channelName, messageFormat, player, deathMessage, event));
        if (preEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "DeathMessagePreProcessEvent was cancelled, message send aborted");
            return;
        }
        channelName = preEvent.getChannel();
        messageFormat = preEvent.getMessageFormat();
        deathMessage = preEvent.getDeathMessage();
        if (messageFormat == null) {
            return;
        }
        String finalDeathMessage = StringUtils.isNotBlank(deathMessage) ? deathMessage : "";
        String avatarUrl = DiscordSRV.getAvatarUrl(event.getEntity());
        String botAvatarUrl = DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl();
        String botName = DiscordSRV.getPlugin().getMainGuild() != null ? DiscordSRV.getPlugin().getMainGuild().getSelfMember().getEffectiveName() : DiscordUtil.getJda().getSelfUser().getName();
        String displayName = StringUtils.isNotBlank(player.getDisplayName()) ? MessageUtil.strip(player.getDisplayName()) : "";
        BiFunction<String, Boolean, String> translator = (arg_0, arg_1) -> PlayerDeathListener.lambda$runAsync$1(player, displayName, finalDeathMessage, avatarUrl, botAvatarUrl, botName, destinationChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName), arg_0, arg_1);
        Message discordMessage = DiscordSRV.translateMessage(messageFormat, translator);
        if (discordMessage == null) {
            return;
        }
        String webhookName = translator.apply(messageFormat.getWebhookName(), false);
        String webhookAvatarUrl = translator.apply(messageFormat.getWebhookAvatarUrl(), false);
        if (DiscordSRV.getLength(discordMessage) < 3) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not sending death message, because it's less than three characters long. Message: " + messageFormat);
            return;
        }
        DeathMessagePostProcessEvent postEvent = DiscordSRV.api.callEvent(new DeathMessagePostProcessEvent(channelName, discordMessage, player, deathMessage, event, messageFormat.isUseWebhooks(), webhookName, webhookAvatarUrl, preEvent.isCancelled()));
        if (postEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "DeathMessagePostProcessEvent was cancelled, message send aborted");
            return;
        }
        channelName = postEvent.getChannel();
        discordMessage = postEvent.getDiscordMessage();
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName);
        if (postEvent.isUsingWebhooks()) {
            WebhookUtil.deliverMessage(textChannel, postEvent.getWebhookName(), postEvent.getWebhookAvatarUrl(), discordMessage.getContentRaw(), (MessageEmbed)discordMessage.getEmbeds().stream().findFirst().orElse(null));
        } else {
            DiscordUtil.queueMessage(textChannel, discordMessage, true);
        }
    }

    private static /* synthetic */ String lambda$runAsync$1(Player player, String displayName, String finalDeathMessage, String avatarUrl, String botAvatarUrl, String botName, TextChannel destinationChannel, String content, Boolean needsEscape) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%username%", needsEscape != false ? DiscordUtil.escapeMarkdown(player.getName()) : player.getName()).replace("%displayname%", needsEscape != false ? DiscordUtil.escapeMarkdown(displayName) : displayName).replace("%usernamenoescapes%", player.getName()).replace("%displaynamenoescapes%", displayName).replace("%world%", player.getWorld().getName()).replace("%deathmessage%", MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(finalDeathMessage) : finalDeathMessage)).replace("%deathmessagenoescapes%", MessageUtil.strip(finalDeathMessage)).replace("%embedavatarurl%", avatarUrl).replace("%botavatarurl%", botAvatarUrl).replace("%botname%", botName);
        if (destinationChannel != null) {
            content = DiscordUtil.translateEmotes(content, destinationChannel.getGuild());
        }
        content = PlaceholderUtil.replacePlaceholdersToDiscord(content, (OfflinePlayer)player);
        return content;
    }
}

