/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.listeners;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.objects.managers.GroupSynchronizationManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerJoinLeaveListener
implements Listener {
    public PlayerJoinLeaveListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DiscordSRV.getPlugin());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        MessageFormat messageFormat;
        Player player = event.getPlayer();
        if (GamePermissionUtil.hasPermission((Permissible)player, "discordsrv.updatenotification") && DiscordSRV.updateIsAvailable) {
            MessageUtil.sendMessage((CommandSender)player, DiscordSRV.getPlugin().getDescription().getVersion().endsWith("-SNAPSHOT") ? ChatColor.GRAY + "There is a newer development build of DiscordSRV available. Download it at https://snapshot.discordsrv.com/" : ChatColor.AQUA + "An update to DiscordSRV is available. Download it at https://modrinth.com/plugin/discordsrv/ or https://get.discordsrv.com");
        }
        if (DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled()) {
            SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> DiscordSRV.getPlugin().getGroupSynchronizationManager().resync((OfflinePlayer)player, GroupSynchronizationManager.SyncDirection.AUTHORITATIVE, true, GroupSynchronizationManager.SyncCause.PLAYER_JOIN));
        }
        if (PlayerUtil.isVanished(player)) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not sending a join message for " + event.getPlayer().getName() + " because a vanish plugin reported them as vanished");
            return;
        }
        MessageFormat messageFormat2 = messageFormat = event.getPlayer().hasPlayedBefore() ? DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerJoinMessage") : DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerFirstJoinMessage");
        if (messageFormat == null) {
            return;
        }
        String name = player.getName();
        if (GamePermissionUtil.hasPermission((Permissible)event.getPlayer(), "discordsrv.silentjoin")) {
            DiscordSRV.info(LangUtil.InternalMessage.SILENT_JOIN.toString().replace("{player}", name));
            return;
        }
        String message = event.getJoinMessage();
        SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> DiscordSRV.getPlugin().sendJoinMessage(event.getPlayer(), message), 20L);
        if (DiscordSRV.config().getBoolean("NicknameSynchronizationEnabled")) {
            SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> {
                String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
                DiscordSRV.getPlugin().getNicknameUpdater().setNickname(DiscordUtil.getMemberById(discordId), (OfflinePlayer)player);
            });
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void PlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (PlayerUtil.isVanished(player)) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not sending a quit message for " + event.getPlayer().getName() + " because a vanish plugin reported them as vanished");
            return;
        }
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("MinecraftPlayerLeaveMessage");
        if (messageFormat == null) {
            return;
        }
        String name = player.getName();
        if (GamePermissionUtil.hasPermission((Permissible)event.getPlayer(), "discordsrv.silentquit")) {
            DiscordSRV.info(LangUtil.InternalMessage.SILENT_QUIT.toString().replace("{player}", name));
            return;
        }
        String message = event.getQuitMessage();
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> DiscordSRV.getPlugin().sendLeaveMessage(event.getPlayer(), message));
    }
}

