/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.modules.alerts;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.Event;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.alexh.weak.Weak;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.math.NumberUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.GenericEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.EventListener;
import github.scarsz.discordsrv.objects.ExpiringDualHashBidiMap;
import github.scarsz.discordsrv.objects.Lag;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.NamedValueFormatter;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.SpELExpressionBuilder;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelEvaluationException;

public class AlertListener
implements Listener,
EventListener {
    private static final Pattern VALID_CLASS_NAME_PATTERN = Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*");
    private static final List<String> BLACKLISTED_CLASS_NAMES = Arrays.asList("com.destroystokyo.paper.event.player.PlayerHandshakeEvent", "org.bukkit.event.player.PlayerChatEvent", "org.bukkit.event.player.PlayerCommandPreprocessEvent", "org.bukkit.event.server.ServerCommandEvent");
    private static final List<String> SYNC_EVENT_NAMES = Arrays.asList("org.bukkit.event.block.BlockBreakEvent");
    private static final List<Class<?>> BLACKLISTED_CLASSES = new ArrayList();
    private final Map<String, String> validClassNameCache = new ExpiringDualHashBidiMap<String, String>(TimeUnit.MINUTES.toMillis(1L));
    private final Set<String> activeTriggers = new HashSet<String>();
    private boolean anyCommandTrigger = false;
    private final RegisteredListener listener;
    private final List<Dynamic> alerts = new ArrayList<Dynamic>();
    private boolean registered = false;

    public AlertListener() {
        this.listener = new RegisteredListener(new Listener(){

            public String toString() {
                return "DiscordSRV Alerts";
            }
        }, (listener, event) -> this.runAlertsForEvent(event), EventPriority.MONITOR, (Plugin)DiscordSRV.getPlugin(), false);
        this.reloadAlerts();
    }

    public void hackIntoAllHandlerLists() {
        try {
            Field allListsField = HandlerList.class.getDeclaredField("allLists");
            allListsField.setAccessible(true);
            if (Modifier.isFinal(allListsField.getModifiers())) {
                try {
                    Field modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(allListsField, allListsField.getModifiers() & 0xFFFFFFEF);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            allListsField.set(null, new ArrayList<HandlerList>(){
                {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.addAll(HandlerList.getHandlerLists());
                    }
                }

                @Override
                public boolean addAll(Collection<? extends HandlerList> c) {
                    boolean changed = false;
                    for (HandlerList handlerList : c) {
                        if (!this.add(handlerList)) continue;
                        changed = true;
                    }
                    return changed;
                }

                @Override
                public boolean add(HandlerList list) {
                    boolean added = super.add(list);
                    AlertListener.this.addListener(list);
                    return added;
                }
            });
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            DiscordSRV.error(e);
        }
    }

    private void addListener(HandlerList handlerList) {
        for (Class<?> blacklistedClass : BLACKLISTED_CLASSES) {
            try {
                HandlerList list = (HandlerList)blacklistedClass.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
                if (handlerList != list) continue;
                DiscordSRV.debug(Debug.ALERTS, "Skipping registering HandlerList for " + blacklistedClass.getName() + " for alerts");
                return;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                DiscordSRV.debug(Debug.ALERTS, "Failed to check if HandlerList was for " + blacklistedClass.getName() + ": " + e.toString());
            }
        }
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            String match = BLACKLISTED_CLASS_NAMES.stream().filter(className -> stackTraceElement.getClassName().equals(className)).findAny().orElse(null);
            if (match == null || !stackTraceElement.getMethodName().equals("<clinit>")) continue;
            DiscordSRV.debug(Debug.ALERTS, "Skipping registering HandlerList for " + match + " for alerts (during event init)");
            return;
        }
        if (Arrays.stream(handlerList.getRegisteredListeners()).noneMatch(this.listener::equals)) {
            handlerList.register(this.listener);
        }
    }

    public void reloadAlerts() {
        this.validClassNameCache.clear();
        this.activeTriggers.clear();
        this.anyCommandTrigger = false;
        this.alerts.clear();
        Optional optionalAlerts = DiscordSRV.config().getOptional("Alerts");
        if (this.registered) {
            this.unregister();
        }
        if (!optionalAlerts.isPresent() || ((List)optionalAlerts.get()).isEmpty()) {
            return;
        }
        ArrayList<String> simpleClassNames = new ArrayList<String>();
        HashSet<HandlerList> handlerLists = new HashSet<HandlerList>();
        long count = ((List)optionalAlerts.get()).size();
        for (Map map : (List)optionalAlerts.get()) {
            Dynamic alert = Dynamic.from(map);
            this.alerts.add(alert);
            Set<String> triggers = this.getTriggers(alert);
            for (String trigger : triggers) {
                if (trigger.startsWith("/")) {
                    this.anyCommandTrigger = true;
                    continue;
                }
                this.activeTriggers.add(trigger.toLowerCase(Locale.ROOT));
                if (!trigger.contains(".")) {
                    simpleClassNames.add(trigger);
                    continue;
                }
                try {
                    Class<?> eventClass = Class.forName(this.getEventClassName(trigger));
                    if (!org.bukkit.event.Event.class.isAssignableFrom(eventClass) || PlayerCommandPreprocessEvent.class.isAssignableFrom(eventClass) || ServerCommandEvent.class.isAssignableFrom(eventClass)) continue;
                    Method method = null;
                    for (Class<?> handlerListClass = eventClass; method == null && handlerListClass != null; handlerListClass = handlerListClass.getSuperclass()) {
                        try {
                            method = handlerListClass.getDeclaredMethod("getHandlerList", new Class[0]);
                            continue;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method == null) {
                        DiscordSRV.error("Could not find getHandlerList method for " + eventClass.getName());
                        continue;
                    }
                    Object handlerList = method.invoke(null, new Object[0]);
                    if (!(handlerList instanceof HandlerList)) {
                        DiscordSRV.error("Could not get HandlerList for " + eventClass.getName() + ": getHandlerList does not actually return a " + HandlerList.class.getName());
                        continue;
                    }
                    if (!handlerLists.add((HandlerList)handlerList)) continue;
                    this.addListener((HandlerList)handlerList);
                }
                catch (ClassNotFoundException ignored) {
                    DiscordSRV.warning("Could not find event for alert trigger: " + trigger);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    DiscordSRV.error("Could not get HandlerList for event " + trigger, e);
                }
            }
        }
        if (!simpleClassNames.isEmpty()) {
            DiscordSRV.warning("Some alerts are using simple class names as triggers (instead of fully-classified class names including the package name), server performance may be effected.");
            DiscordSRV.warning("Support for simple class names will be removed in a future release of DiscordSRV");
            DiscordSRV.warning("The following triggers are causing this notification: " + String.join((CharSequence)", ", simpleClassNames));
            DiscordSRV.warning("Read https://docs.discordsrv.com/alerts/migration for more information");
            this.hackIntoAllHandlerLists();
        }
        this.registered = true;
        DiscordSRV.info(((List)optionalAlerts.get()).size() + " alert" + (count > 1L ? "s" : "") + " registered");
    }

    public List<Dynamic> getAlerts() {
        return this.alerts;
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this.listener.getListener());
        this.registered = false;
    }

    @Override
    public void onEvent(@NotNull GenericEvent event) {
        this.runAlertsForEvent(event);
    }

    @Subscribe
    public void onDSRVEvent(Event event) {
        this.runAlertsForEvent(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        this.runAlertsForEvent(event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onServerCommand(ServerCommandEvent event) {
        this.runAlertsForEvent(event);
    }

    private void runAlertsForEvent(Object event) {
        boolean active;
        boolean command = event instanceof PlayerCommandPreprocessEvent || event instanceof ServerCommandEvent;
        String eventClassName = this.getEventClassName(event);
        boolean bl = active = command && this.anyCommandTrigger || this.activeTriggers.contains(eventClassName.toLowerCase(Locale.ROOT)) || this.activeTriggers.contains(this.getEventName(event).toLowerCase(Locale.ROOT));
        if (!active) {
            if (event instanceof org.bukkit.event.Event) {
                boolean anySuperClassHasHandlersMethod = false;
                for (Class<?> checkClass = event.getClass().getSuperclass(); checkClass != null; checkClass = checkClass.getSuperclass()) {
                    try {
                        checkClass.getDeclaredMethod("getHandlers", new Class[0]);
                        anySuperClassHasHandlersMethod = true;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                if (!anySuperClassHasHandlersMethod) {
                    HandlerList handlerList = ((org.bukkit.event.Event)event).getHandlers();
                    handlerList.unregister((Listener)this);
                }
            }
            return;
        }
        for (int i = 0; i < this.alerts.size(); ++i) {
            Dynamic alert = this.alerts.get(i);
            Set<String> triggers = this.getTriggers(alert);
            boolean async = true;
            Dynamic asyncDynamic = alert.get("Async");
            if (asyncDynamic.isPresent() && (asyncDynamic.convert().intoString().equalsIgnoreCase("false") || asyncDynamic.convert().intoString().equalsIgnoreCase("no"))) {
                async = false;
            }
            for (String syncName : SYNC_EVENT_NAMES) {
                if (!eventClassName.equals(syncName)) continue;
                async = false;
                break;
            }
            if (async) {
                int alertIndex = i;
                SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.process(event, alert, triggers, alertIndex));
                continue;
            }
            this.process(event, alert, triggers, i);
        }
    }

    private Set<String> getTriggers(Dynamic alert) {
        HashSet<String> triggers = new HashSet<String>();
        Dynamic triggerDynamic = alert.get("Trigger");
        if (triggerDynamic.isList()) {
            triggers.addAll(triggerDynamic.children().map(Weak::asString).collect(Collectors.toSet()));
        } else if (triggerDynamic.isString()) {
            triggers.add(triggerDynamic.asString());
        }
        HashSet<String> finalTriggers = new HashSet<String>();
        for (String trigger : triggers) {
            if (!trigger.startsWith("/")) {
                String className = this.validClassNameCache.get(trigger);
                if (className == null) {
                    Matcher matcher = VALID_CLASS_NAME_PATTERN.matcher(trigger);
                    if (matcher.find()) {
                        className = matcher.group();
                    }
                    this.validClassNameCache.put(trigger, className);
                }
                finalTriggers.add(className);
                continue;
            }
            finalTriggers.add(trigger);
        }
        return finalTriggers;
    }

    private String getEventClassName(Object event) {
        String className = event instanceof String ? (String)event : event.getClass().getName();
        return className.replace("github.scarsz.discordsrv.dependencies.jda", "net.".concat("dv8tion.jda"));
    }

    private String getEventName(Object event) {
        return event instanceof org.bukkit.event.Event ? ((org.bukkit.event.Event)event).getEventName() : event.getClass().getSimpleName();
    }

    private void process(Object event, Dynamic alert, Set<String> triggers, int alertIndex) {
        Player player;
        Player player2 = player = event instanceof PlayerEvent ? ((PlayerEvent)event).getPlayer() : null;
        if (player == null) {
            try {
                Method getPlayerMethod = event.getClass().getMethod("getPlayer", new Class[0]);
                if (getPlayerMethod.getReturnType().equals(Player.class)) {
                    player = (Player)getPlayerMethod.invoke(event, new Object[0]);
                }
            }
            catch (Exception getPlayerMethod) {
                // empty catch block
            }
        }
        Player sender = null;
        String command = null;
        LinkedList<String> args = new LinkedList<String>();
        if (event instanceof PlayerCommandPreprocessEvent) {
            sender = player;
            command = ((PlayerCommandPreprocessEvent)event).getMessage().substring(1);
        } else if (event instanceof ServerCommandEvent) {
            sender = ((ServerCommandEvent)event).getSender();
            command = ((ServerCommandEvent)event).getCommand();
        }
        if (StringUtils.isNotBlank(command)) {
            String[] split = command.split(" ", 2);
            String commandBase = split[0];
            if (split.length == 2) {
                args.addAll(Arrays.asList(split[1].split(" ")));
            }
            if (commandBase.contains(":")) {
                commandBase = commandBase.substring(commandBase.lastIndexOf(":") + 1);
            }
            command = commandBase + (split.length == 2 ? " " + split[1] : "");
        }
        MessageFormat messageFormat = DiscordSRV.getPlugin().getMessageFromConfiguration("Alerts." + alertIndex);
        String eventClassName = this.getEventClassName(event);
        String eventName = this.getEventName(event);
        for (String trigger : triggers) {
            Dynamic textChannelsDynamic;
            if (!trigger.startsWith("/") ? !eventClassName.equals(trigger) && !eventName.equalsIgnoreCase(trigger) : StringUtils.isBlank(command) || !command.toLowerCase().split("\\s+|$", 2)[0].equals(trigger.substring(1))) continue;
            if (event instanceof Cancellable && ((Cancellable)event).isCancelled()) {
                boolean ignoreCancelled;
                Dynamic ignoreCancelledDynamic = alert.get("IgnoreCancelled");
                boolean bl = ignoreCancelled = ignoreCancelledDynamic.isPresent() ? ignoreCancelledDynamic.as(Boolean.class) : true;
                if (ignoreCancelled) {
                    DiscordSRV.debug(Debug.ALERTS, "Not running alert for event " + eventName + ": event was cancelled");
                    return;
                }
            }
            if ((textChannelsDynamic = alert.get("Channel")) == null) {
                DiscordSRV.debug(Debug.ALERTS, "Not running alert for trigger " + trigger + ": no target channel was defined");
                return;
            }
            HashSet<String> channels = new HashSet<String>();
            if (textChannelsDynamic.isList()) {
                textChannelsDynamic.children().map(Weak::asString).filter(Objects::nonNull).forEach(channels::add);
            } else if (textChannelsDynamic.isString()) {
                channels.add(textChannelsDynamic.asString());
            }
            Function<Function, Set> channelResolver = converter -> {
                HashSet<TextChannel> textChannels = new HashSet<TextChannel>();
                channels.forEach(channel -> textChannels.addAll((Collection)converter.apply(channel)));
                textChannels.removeIf(Objects::isNull);
                return textChannels;
            };
            Set textChannels = channelResolver.apply(s -> {
                TextChannel target = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName((String)s);
                return Collections.singleton(target);
            });
            if (textChannels.isEmpty()) {
                textChannels.addAll(channelResolver.apply(s -> DiscordUtil.getJda().getTextChannelsByName((String)s, false)));
            }
            if (textChannels.isEmpty()) {
                textChannels.addAll(channelResolver.apply(s -> NumberUtils.isDigits(s) ? Collections.singleton(DiscordUtil.getJda().getTextChannelById((String)s)) : Collections.emptyList()));
            }
            if (textChannels.size() == 0) {
                DiscordSRV.debug(Debug.ALERTS, "Not running alert for trigger " + trigger + ": no target channel was defined/found (channels: " + channels + ")");
                return;
            }
            for (TextChannel textChannel : textChannels) {
                String finalCommand;
                Player finalSender;
                Player finalPlayer;
                BiFunction<String, Boolean, String> translator;
                Message message;
                boolean allConditionsMet = true;
                Dynamic conditionsDynamic = alert.dget("Conditions");
                if (conditionsDynamic.isPresent()) {
                    Iterator conditions = conditionsDynamic.children().iterator();
                    while (conditions.hasNext()) {
                        Dynamic dynamic = (Dynamic)conditions.next();
                        String expression = dynamic.convert().intoString();
                        try {
                            Boolean value = new SpELExpressionBuilder(expression).withPluginVariables().withVariable("event", event).withVariable("server", Bukkit.getServer()).withVariable("discordsrv", (Object)DiscordSRV.getPlugin()).withVariable("player", player).withVariable("sender", sender).withVariable("command", command).withVariable("args", args).withVariable("allArgs", String.join((CharSequence)" ", args)).withVariable("channel", textChannel).withVariable("jda", DiscordUtil.getJda()).evaluate(event, Boolean.class);
                            DiscordSRV.debug(Debug.ALERTS, "Condition \"" + expression + "\" -> " + value);
                            if (value == null || value.booleanValue()) continue;
                            allConditionsMet = false;
                            break;
                        }
                        catch (ParseException e) {
                            DiscordSRV.error("Error while parsing expression \"" + expression + "\" for trigger \"" + trigger + "\" -> " + e.getMessage());
                        }
                        catch (SpelEvaluationException e) {
                            DiscordSRV.error("Error while evaluating expression \"" + expression + "\" for trigger \"" + trigger + "\" -> " + e.getMessage());
                        }
                    }
                    if (!allConditionsMet) continue;
                }
                if ((message = DiscordSRV.translateMessage(messageFormat, translator = (arg_0, arg_1) -> AlertListener.lambda$process$9(event, finalPlayer = player, (CommandSender)(finalSender = sender), finalCommand = command, args, textChannel, arg_0, arg_1))) == null) {
                    DiscordSRV.debug(Debug.ALERTS, "Not sending alert because it is configured to have no message content");
                    return;
                }
                if (messageFormat.isUseWebhooks()) {
                    WebhookUtil.deliverMessage(textChannel, translator.apply(messageFormat.getWebhookName(), false), translator.apply(messageFormat.getWebhookAvatarUrl(), false), message.getContentRaw(), (MessageEmbed)message.getEmbeds().stream().findFirst().orElse(null));
                    continue;
                }
                DiscordUtil.queueMessage(textChannel, message);
            }
        }
    }

    private static /* synthetic */ String lambda$process$9(Object event, Player finalPlayer, CommandSender finalSender, String finalCommand, List args, TextChannel textChannel, String content, Boolean needsEscape) {
        if (content == null) {
            return null;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("event", event);
        variables.put("server", Bukkit.getServer());
        variables.put("discordsrv", (Object)DiscordSRV.getPlugin());
        variables.put("player", finalPlayer);
        variables.put("sender", finalSender);
        variables.put("command", finalCommand);
        variables.put("args", args);
        variables.put("allArgs", String.join((CharSequence)" ", args));
        variables.put("channel", textChannel);
        variables.put("jda", DiscordUtil.getJda());
        content = NamedValueFormatter.formatExpressions(content, event, variables);
        content = NamedValueFormatter.format(content, key -> {
            switch (key) {
                case "tps": {
                    return Lag.getTPSString();
                }
                case "time": 
                case "date": {
                    return TimeUtil.timeStamp();
                }
                case "ping": {
                    return finalPlayer != null ? Integer.valueOf(PlayerUtil.getPing(finalPlayer)) : "-1";
                }
                case "name": 
                case "username": {
                    return finalPlayer != null ? finalPlayer.getName() : "";
                }
                case "displayname": {
                    return finalPlayer != null ? MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(finalPlayer.getDisplayName()) : finalPlayer.getDisplayName()) : "";
                }
                case "world": {
                    return finalPlayer != null ? finalPlayer.getWorld().getName() : "";
                }
                case "embedavatarurl": {
                    return finalPlayer != null ? DiscordSRV.getAvatarUrl(finalPlayer) : DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl();
                }
                case "botavatarurl": {
                    return DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl();
                }
                case "botname": {
                    return DiscordSRV.getPlugin().getMainGuild() != null ? DiscordSRV.getPlugin().getMainGuild().getSelfMember().getEffectiveName() : DiscordUtil.getJda().getSelfUser().getName();
                }
            }
            return "{" + key + "}";
        });
        content = DiscordUtil.translateEmotes(content, textChannel.getGuild());
        content = PlaceholderUtil.replacePlaceholdersToDiscord(content, (OfflinePlayer)finalPlayer);
        return content;
    }

    static {
        for (String className : BLACKLISTED_CLASS_NAMES) {
            try {
                BLACKLISTED_CLASSES.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }
}

