/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.modules.requirelink;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;

public class RequireLinkModule
implements Listener {
    private static final String KICK_REASON_CONFIG_ERROR = AsyncPlayerPreLoginEvent.Result.KICK_OTHER.name();
    private static final String KICK_REASON_NOT_ALLOWED = AsyncPlayerPreLoginEvent.Result.KICK_OTHER.name();

    public RequireLinkModule() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DiscordSRV.getPlugin());
    }

    private void check(String eventType, EventPriority priority, String playerName, UUID playerUuid, String ip, BiConsumer<String, String> disallow) {
        block32: {
            if (!this.isEnabled()) {
                return;
            }
            if (!eventType.equals(DiscordSRV.config().getString("Require linked account to play.Listener event"))) {
                return;
            }
            String requestedPriority = DiscordSRV.config().getString("Require linked account to play.Listener priority");
            EventPriority targetPriority = Arrays.stream(EventPriority.values()).filter(p -> p.name().equalsIgnoreCase(requestedPriority)).findFirst().orElse(EventPriority.LOWEST);
            if (priority != targetPriority) {
                return;
            }
            try {
                boolean whitelisted;
                if (this.getBypassNames().contains(playerName)) {
                    DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " is on the bypass list, bypassing linking checks");
                    return;
                }
                if (this.checkWhitelist() && (whitelisted = Bukkit.getServer().getWhitelistedPlayers().stream().map(OfflinePlayer::getUniqueId).anyMatch(u -> u.equals(playerUuid)))) {
                    DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " is bypassing link requirement, player is whitelisted");
                    return;
                }
                boolean onlyCheckBannedPlayers = this.onlyCheckBannedPlayers();
                if (!this.checkBannedPlayers() || onlyCheckBannedPlayers) {
                    boolean banned = false;
                    if (Bukkit.getServer().getBannedPlayers().stream().anyMatch(p -> p.getUniqueId().equals(playerUuid))) {
                        if (!onlyCheckBannedPlayers) {
                            DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " is banned, skipping linked check");
                            return;
                        }
                        banned = true;
                    }
                    if (!banned) {
                        if (Bukkit.getServer().getIPBans().stream().anyMatch(ip::equals)) {
                            if (!onlyCheckBannedPlayers) {
                                DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " connecting with banned IP " + ip + ", skipping linked check");
                                return;
                            }
                            banned = true;
                        }
                    }
                    if (onlyCheckBannedPlayers && !banned) {
                        DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " is bypassing link requirement because \"Only check banned players\" is enabled");
                        return;
                    }
                }
                if (!DiscordSRV.isReady) {
                    DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " connecting before DiscordSRV is ready, denying login");
                    disallow.accept(KICK_REASON_CONFIG_ERROR, MessageUtil.translateLegacy(this.getDiscordSRVStillStartingKickMessage()));
                    return;
                }
                String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordIdBypassCache(playerUuid);
                if (discordId == null) {
                    Member botMember = DiscordSRV.getPlugin().getMainGuild().getSelfMember();
                    String botName = botMember.getEffectiveName() + "#" + botMember.getUser().getDiscriminator();
                    String code = DiscordSRV.getPlugin().getAccountLinkManager().generateCode(playerUuid);
                    String inviteLink = DiscordSRV.config().getString("DiscordInviteLink");
                    DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " is NOT linked to a Discord account, denying login");
                    disallow.accept(KICK_REASON_NOT_ALLOWED, MessageUtil.translateLegacy(DiscordSRV.config().getString("Require linked account to play.Not linked message")).replace("{BOT}", botName).replace("{CODE}", code).replace("{INVITE}", inviteLink));
                    return;
                }
                Dynamic mustBeInDiscordServerOption = DiscordSRV.config().dget("Require linked account to play.Must be in Discord server");
                if (mustBeInDiscordServerOption.is(Boolean.class)) {
                    boolean isPresent;
                    boolean mustBePresent = mustBeInDiscordServerOption.as(Boolean.class);
                    boolean bl = isPresent = DiscordUtil.getJda().retrieveUserById(discordId).complete().getMutualGuilds().size() > 0;
                    if (mustBePresent && !isPresent) {
                        DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + "'s linked Discord account is NOT present, denying login");
                        disallow.accept(KICK_REASON_NOT_ALLOWED, MessageUtil.translateLegacy(DiscordSRV.config().getString("Require linked account to play.Messages.Not in server")).replace("{INVITE}", DiscordSRV.config().getString("DiscordInviteLink")));
                        return;
                    }
                } else {
                    HashSet<String> targets = new HashSet<String>();
                    if (mustBeInDiscordServerOption.isList()) {
                        mustBeInDiscordServerOption.children().forEach(dynamic -> targets.add(dynamic.toString()));
                    } else {
                        targets.add(mustBeInDiscordServerOption.convert().intoString());
                    }
                    for (String guildId : targets) {
                        try {
                            Guild guild = DiscordUtil.getJda().getGuildById(guildId);
                            if (guild != null) {
                                boolean inServer = guild.retrieveMemberById(discordId).complete() != null;
                                if (inServer) continue;
                                DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + "'s linked Discord account is NOT present, denying login");
                                disallow.accept(KICK_REASON_NOT_ALLOWED, MessageUtil.translateLegacy(DiscordSRV.config().getString("Require linked account to play.Messages.Not in server")).replace("{INVITE}", DiscordSRV.config().getString("DiscordInviteLink")));
                                return;
                            }
                            DiscordSRV.debug(Debug.REQUIRE_LINK, "Failed to get Discord server by ID " + guildId + ": bot is not in server");
                        }
                        catch (NumberFormatException e) {
                            DiscordSRV.debug(Debug.REQUIRE_LINK, "Failed to get Discord server by ID " + guildId + ": not a parsable long");
                        }
                    }
                }
                List<String> subRoleIds = DiscordSRV.config().getStringList("Require linked account to play.Subscriber role.Subscriber roles");
                if (!this.isSubRoleRequired() || subRoleIds.isEmpty()) break block32;
                int failedRoleIds = 0;
                int matches = 0;
                for (String subRoleId : subRoleIds) {
                    if (StringUtils.isBlank(subRoleId)) {
                        ++failedRoleIds;
                        continue;
                    }
                    Role role = null;
                    try {
                        role = DiscordUtil.getJda().getRoleById(subRoleId);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (role == null) {
                        ++failedRoleIds;
                        continue;
                    }
                    Member member = role.getGuild().getMemberById(discordId);
                    if (member == null || !member.getRoles().contains(role)) continue;
                    ++matches;
                }
                if (failedRoleIds == subRoleIds.size()) {
                    DiscordSRV.error("Tried to authenticate " + playerName + " but no valid subscriber role IDs are found and thats a requirement; login will be denied until this is fixed.");
                    disallow.accept(KICK_REASON_CONFIG_ERROR, MessageUtil.translateLegacy(this.getFailedToFindRoleKickMessage()));
                    return;
                }
                if (this.getAllSubRolesRequired() ? matches < subRoleIds.size() : matches == 0) {
                    DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + playerName + " does NOT match subscriber role requirements, denying login");
                    disallow.accept(KICK_REASON_NOT_ALLOWED, MessageUtil.translateLegacy(this.getSubscriberRoleKickMessage()));
                }
            }
            catch (Exception exception) {
                DiscordSRV.error("Failed to check player: " + playerName, exception);
                disallow.accept(KICK_REASON_CONFIG_ERROR, MessageUtil.translateLegacy(this.getUnknownFailureKickMessage()));
            }
        }
    }

    public void noticePlayerUnlink(Player player) {
        boolean whitelisted;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getBypassNames().contains(player.getName())) {
            return;
        }
        if (this.checkWhitelist() && (whitelisted = Bukkit.getServer().getWhitelistedPlayers().stream().map(OfflinePlayer::getUniqueId).anyMatch(u -> u.equals(player.getUniqueId())))) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + player.getName() + " is bypassing link requirement, player is whitelisted");
            return;
        }
        String ip = player.getAddress().getAddress().getHostAddress();
        if (this.onlyCheckBannedPlayers() && !Bukkit.getServer().getBannedPlayers().stream().anyMatch(p -> p.getUniqueId().equals(player.getUniqueId()))) {
            if (!Bukkit.getServer().getIPBans().stream().anyMatch(ip::equals)) {
                DiscordSRV.debug(Debug.REQUIRE_LINK, "Player " + player.getName() + " is bypassing link requirement because \"Only check banned players\" is enabled");
                return;
            }
        }
        DiscordSRV.info("Kicking player " + player.getName() + " for unlinking their accounts");
        SchedulerUtil.runTaskForPlayer((Plugin)DiscordSRV.getPlugin(), player, () -> player.kickPlayer(MessageUtil.translateLegacy(this.getUnlinkedKickMessage())));
    }

    private boolean checkWhitelist() {
        return DiscordSRV.config().getBoolean("Require linked account to play.Whitelisted players bypass check");
    }

    private boolean checkBannedPlayers() {
        return DiscordSRV.config().getBoolean("Require linked account to play.Check banned players");
    }

    private boolean onlyCheckBannedPlayers() {
        return DiscordSRV.config().getBoolean("Require linked account to play.Only check banned players");
    }

    private boolean getAllSubRolesRequired() {
        return DiscordSRV.config().getBoolean("Require linked account to play.Subscriber role.Require all of the listed roles");
    }

    private boolean isEnabled() {
        return DiscordSRV.config().getBoolean("Require linked account to play.Enabled");
    }

    private boolean isSubRoleRequired() {
        return DiscordSRV.config().getBoolean("Require linked account to play.Subscriber role.Require subscriber role to join");
    }

    private Set<String> getBypassNames() {
        return new HashSet<String>(DiscordSRV.config().getStringList("Require linked account to play.Bypass names"));
    }

    private String getDiscordSRVStillStartingKickMessage() {
        return DiscordSRV.config().getString("Require linked account to play.Messages.DiscordSRV still starting");
    }

    private String getFailedToFindRoleKickMessage() {
        return DiscordSRV.config().getString("Require linked account to play.Messages.Failed to find subscriber role");
    }

    private String getSubscriberRoleKickMessage() {
        return DiscordSRV.config().getString("Require linked account to play.Subscriber role.Kick message");
    }

    private String getUnknownFailureKickMessage() {
        return DiscordSRV.config().getString("Require linked account to play.Messages.Failed for unknown reason");
    }

    private String getUnlinkedKickMessage() {
        return DiscordSRV.config().getString("Require linked account to play.Messages.Kicked for unlinking");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEventLowest(AsyncPlayerPreLoginEvent event) {
        if (!event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getName() + " = " + event.getLoginResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.LOWEST, event.getName(), event.getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(AsyncPlayerPreLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEventLow(AsyncPlayerPreLoginEvent event) {
        if (!event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getName() + " = " + event.getLoginResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.LOW, event.getName(), event.getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(AsyncPlayerPreLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEventNormal(AsyncPlayerPreLoginEvent event) {
        if (!event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getName() + " = " + event.getLoginResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.NORMAL, event.getName(), event.getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(AsyncPlayerPreLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEventHigh(AsyncPlayerPreLoginEvent event) {
        if (!event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getName() + " = " + event.getLoginResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.HIGH, event.getName(), event.getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(AsyncPlayerPreLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEventHighest(AsyncPlayerPreLoginEvent event) {
        if (!event.getLoginResult().equals((Object)AsyncPlayerPreLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getName() + " = " + event.getLoginResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.HIGHEST, event.getName(), event.getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(AsyncPlayerPreLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEventLowest(PlayerLoginEvent event) {
        if (!event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getPlayer().getName() + " = " + event.getResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.LOWEST, event.getPlayer().getName(), event.getPlayer().getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(PlayerLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEventLow(PlayerLoginEvent event) {
        if (!event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getPlayer().getName() + " = " + event.getResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.LOW, event.getPlayer().getName(), event.getPlayer().getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(PlayerLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEventNormal(PlayerLoginEvent event) {
        if (!event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getPlayer().getName() + " = " + event.getResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.NORMAL, event.getPlayer().getName(), event.getPlayer().getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(PlayerLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEventHigh(PlayerLoginEvent event) {
        if (!event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getPlayer().getName() + " = " + event.getResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.HIGH, event.getPlayer().getName(), event.getPlayer().getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(PlayerLoginEvent.Result.valueOf((String)result), message));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEventHighest(PlayerLoginEvent event) {
        if (!event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            DiscordSRV.debug(Debug.REQUIRE_LINK, "PlayerLoginEvent event result for " + event.getPlayer().getName() + " = " + event.getResult() + ", skipping");
            return;
        }
        this.check(event.getClass().getSimpleName(), EventPriority.HIGHEST, event.getPlayer().getName(), event.getPlayer().getUniqueId(), event.getAddress().getHostAddress(), (result, message) -> event.disallow(PlayerLoginEvent.Result.valueOf((String)result), message));
    }
}

