/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.modules.voice;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.IPermissionHolder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.modules.voice.VoiceModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Network {
    private final Set<UUID> players;
    private String channel;
    private boolean initialized = false;

    public Network(String channel) {
        this.players = Collections.emptySet();
        this.channel = channel;
    }

    public Network(Set<UUID> players) {
        this.players = players;
        DiscordSRV.debug(Debug.VOICE, "Network being made for " + players);
        ArrayList<Permission> allowedPermissions = new ArrayList<Permission>(Arrays.asList(Permission.VOICE_SPEAK));
        ArrayList<Permission> deniedPermissions = new ArrayList<Permission>(Arrays.asList(Permission.VOICE_CONNECT));
        if (VoiceModule.isVoiceChannelsVisible()) {
            allowedPermissions.add(Permission.VIEW_CHANNEL);
        } else {
            deniedPermissions.add(Permission.VIEW_CHANNEL);
        }
        VoiceModule.getCategory().createVoiceChannel(UUID.randomUUID().toString()).addPermissionOverride((IPermissionHolder)VoiceModule.getGuild().getPublicRole(), allowedPermissions, deniedPermissions).addPermissionOverride((IPermissionHolder)VoiceModule.getGuild().getSelfMember(), Arrays.asList(Permission.VIEW_CHANNEL, Permission.VOICE_CONNECT, Permission.VOICE_MOVE_OTHERS), Collections.emptyList()).queue(channel -> {
            this.channel = channel.getId();
            this.initialized = true;
        }, e -> {
            DiscordSRV.error("Failed to create network for " + players + ": " + e.getMessage());
            VoiceModule.get().getNetworks().remove(this);
        });
    }

    public Network engulf(Network network) {
        DiscordSRV.debug(Debug.VOICE, "Network " + this + " is engulfing " + network);
        this.players.addAll(network.players);
        network.players.clear();
        return this;
    }

    public boolean isPlayerInRangeToBeAdded(Player player) {
        return this.players.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).filter(p -> !p.equals((Object)player)).filter(p -> p.getWorld().getName().equals(player.getWorld().getName())).anyMatch(p -> VoiceModule.verticalDistance(p.getLocation(), player.getLocation()) <= VoiceModule.getVerticalStrength() && VoiceModule.horizontalDistance(p.getLocation(), player.getLocation()) <= VoiceModule.getHorizontalStrength());
    }

    public boolean isPlayerInRangeToStayConnected(Player player) {
        double falloff = VoiceModule.getFalloff();
        return this.players.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).filter(p -> !p.equals((Object)player)).filter(p -> p.getWorld().getName().equals(player.getWorld().getName())).anyMatch(p -> VoiceModule.verticalDistance(p.getLocation(), player.getLocation()) <= VoiceModule.getVerticalStrength() + falloff && VoiceModule.horizontalDistance(p.getLocation(), player.getLocation()) <= VoiceModule.getHorizontalStrength() + falloff);
    }

    public boolean isPlayerInsideFalloffZone(Player player) {
        double falloff = VoiceModule.getFalloff();
        double horizontalStrength = VoiceModule.getHorizontalStrength();
        double verticalStrength = VoiceModule.getHorizontalStrength();
        return this.players.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).filter(p -> !p.equals((Object)player)).filter(p -> p.getWorld().getName().equals(player.getWorld().getName())).anyMatch(p -> {
            double vertical = VoiceModule.verticalDistance(p.getLocation(), player.getLocation());
            double horizontal = VoiceModule.horizontalDistance(p.getLocation(), player.getLocation());
            return vertical > verticalStrength && vertical <= verticalStrength + falloff && horizontal > horizontal && horizontal <= horizontalStrength + falloff;
        });
    }

    public void clear() {
        this.players.clear();
    }

    public void add(Player player) {
        this.players.add(player.getUniqueId());
    }

    public void add(UUID uuid) {
        this.players.add(uuid);
    }

    public void remove(Player player) {
        this.players.remove(player.getUniqueId());
    }

    public void remove(UUID uuid) {
        this.players.remove(uuid);
    }

    public boolean contains(Player player) {
        return this.players.contains(player.getUniqueId());
    }

    public boolean contains(UUID uuid) {
        return this.players.contains(uuid);
    }

    public int size() {
        return this.players.size();
    }

    public boolean isEmpty() {
        return this.players.isEmpty();
    }

    public VoiceChannel getChannel() {
        if (this.channel == null || this.channel.isEmpty()) {
            return null;
        }
        return VoiceModule.getGuild().getVoiceChannelById(this.channel);
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

