/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.modules.voice;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Category;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.PermissionOverride;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.VoiceChannel;
import github.scarsz.discordsrv.dependencies.jda.api.events.channel.voice.VoiceChannelDeleteEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.voice.GuildVoiceJoinEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.voice.GuildVoiceLeaveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.voice.GuildVoiceMoveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.internal.utils.tuple.Pair;
import github.scarsz.discordsrv.modules.voice.Network;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public class VoiceModule
extends ListenerAdapter
implements Listener {
    private static final List<Permission> LOBBY_REQUIRED_PERMISSIONS = Arrays.asList(Permission.VIEW_CHANNEL, Permission.VOICE_MOVE_OTHERS);
    private static final List<Permission> CATEGORY_REQUIRED_PERMISSIONS = Arrays.asList(Permission.VIEW_CHANNEL, Permission.VOICE_MOVE_OTHERS, Permission.MANAGE_PERMISSIONS, Permission.MANAGE_CHANNEL);
    private final ReentrantLock lock = new ReentrantLock();
    private Set<UUID> dirtyPlayers = new HashSet<UUID>();
    private final Set<Network> networks = ConcurrentHashMap.newKeySet();
    private final Set<String> mutedUsers = ConcurrentHashMap.newKeySet();
    private final Map<String, Pair<String, CompletableFuture<Void>>> awaitingMoves = new ConcurrentHashMap<String, Pair<String, CompletableFuture<Void>>>();
    private long lastLogTime;

    public VoiceModule() {
        String categoryId;
        if (DiscordSRV.config().getBoolean("Voice enabled")) {
            DiscordSRV.info("Enabling voice module");
            DiscordSRV.getPlugin().getJda().addEventListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DiscordSRV.getPlugin());
            SchedulerUtil.runTaskLater((Plugin)DiscordSRV.getPlugin(), () -> SchedulerUtil.runTaskTimerAsynchronously((Plugin)DiscordSRV.getPlugin(), this::tick, 1L, DiscordSRV.config().getInt("Tick speed")), 1L);
        }
        if (StringUtils.isBlank(categoryId = DiscordSRV.config().getString("Voice category"))) {
            return;
        }
        Category category = DiscordSRV.getPlugin().getJda().getCategoryById(categoryId);
        if (category != null) {
            category.getVoiceChannels().stream().filter(channel -> {
                try {
                    UUID.fromString(channel.getName());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }).forEach(channel -> this.networks.add(new Network(channel.getId())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        if (!this.lock.tryLock()) {
            DiscordSRV.debug(Debug.VOICE, "Skipping voice module tick, a tick is already in progress");
            return;
        }
        try {
            VoiceChannel voiceChannel;
            VoiceChannel playerChannel;
            Category category = VoiceModule.getCategory();
            if (category == null) {
                DiscordSRV.debug(Debug.VOICE, "Skipping voice module tick, category is null");
                return;
            }
            VoiceChannel lobbyChannel = VoiceModule.getLobbyChannel();
            if (lobbyChannel == null) {
                DiscordSRV.debug(Debug.VOICE, "Skipping voice module tick, lobby channel is null");
                return;
            }
            Member selfMember = lobbyChannel.getGuild().getSelfMember();
            Role publicRole = lobbyChannel.getGuild().getPublicRole();
            long currentTime = System.currentTimeMillis();
            boolean log = this.lastLogTime + TimeUnit.SECONDS.toMillis(30L) < currentTime;
            boolean stop = false;
            for (Permission permission : LOBBY_REQUIRED_PERMISSIONS) {
                if (selfMember.hasPermission((GuildChannel)lobbyChannel, permission)) continue;
                if (log) {
                    DiscordSRV.error("The bot doesn't have the \"" + permission.getName() + "\" permission in the voice lobby (" + lobbyChannel.getName() + ")");
                }
                stop = true;
            }
            for (Permission permission : CATEGORY_REQUIRED_PERMISSIONS) {
                if (selfMember.hasPermission((GuildChannel)category, permission)) continue;
                if (log) {
                    DiscordSRV.error("The bot doesn't have the \"" + permission.getName() + "\" permission in the voice category (" + category.getName() + ")");
                }
                stop = true;
            }
            if (stop) {
                this.lastLogTime = currentTime;
                return;
            }
            PermissionOverride lobbyPublicRoleOverride = lobbyChannel.getPermissionOverride(publicRole);
            if (lobbyPublicRoleOverride == null) {
                lobbyChannel.createPermissionOverride(publicRole).deny(Permission.VOICE_SPEAK).queue();
            } else if (!lobbyPublicRoleOverride.getDenied().contains((Object)Permission.VOICE_SPEAK)) {
                lobbyPublicRoleOverride.getManager().deny(Permission.VOICE_SPEAK).queue();
            }
            this.networks.removeIf(network -> network.getChannel() == null && network.isInitialized());
            Set alivePlayers = PlayerUtil.getOnlinePlayers().stream().filter(player -> !player.isDead()).collect(Collectors.toSet());
            Set<UUID> oldDirtyPlayers = this.dirtyPlayers;
            this.dirtyPlayers = new HashSet<UUID>();
            for (UUID uuid : oldDirtyPlayers) {
                Player player2 = Bukkit.getPlayer((UUID)uuid);
                if (player2 == null) continue;
                Member member = VoiceModule.getMember(player2.getUniqueId());
                if (member == null) {
                    DiscordSRV.debug(Debug.VOICE, "Player " + player2.getName() + " isn't linked, skipping voice checks");
                    continue;
                }
                if (member.getVoiceState() == null || member.getVoiceState().getChannel() == null) {
                    DiscordSRV.debug(Debug.VOICE, "Player " + player2.getName() + " is not connected to voice");
                    continue;
                }
                playerChannel = member.getVoiceState().getChannel();
                boolean isLobby = playerChannel.getId().equals(VoiceModule.getLobbyChannel().getId());
                if (!(isLobby || playerChannel.getParent() != null && playerChannel.getParent().getId().equals(VoiceModule.getCategory().getId()))) {
                    DiscordSRV.debug(Debug.VOICE, "Player " + player2.getName() + " was not in the voice lobby or category");
                    Pair<String, CompletableFuture<Void>> pair = this.awaitingMoves.get(member.getId());
                    if (pair == null) continue;
                    pair.getRight().cancel(false);
                    continue;
                }
                this.networks.stream().filter(network -> network.isPlayerInRangeToBeAdded(player2)).reduce((network1, network2) -> network1.size() > network2.size() ? network1.engulf((Network)network2) : network2.engulf((Network)network1)).filter(network -> !network.contains(player2.getUniqueId())).ifPresent(network -> {
                    DiscordSRV.debug(Debug.VOICE, player2.getName() + " has entered network " + network + "'s influence, connecting");
                    network.add(player2.getUniqueId());
                });
                this.networks.stream().filter(network -> network.contains(player2.getUniqueId())).filter(network -> !network.isPlayerInRangeToStayConnected(player2)).forEach(network -> {
                    DiscordSRV.debug(Debug.VOICE, "Player " + player2.getName() + " lost connection to " + network + ", disconnecting");
                    network.remove(player2.getUniqueId());
                    if (network.size() == 1) {
                        network.clear();
                    }
                });
                Set playersWithinRange = alivePlayers.stream().filter(p -> this.networks.stream().noneMatch(network -> network.contains((Player)p))).filter(p -> !p.equals((Object)player2)).filter(p -> p.getWorld().getName().equals(player2.getWorld().getName())).filter(p -> VoiceModule.horizontalDistance(p.getLocation(), player2.getLocation()) <= VoiceModule.getHorizontalStrength() && VoiceModule.verticalDistance(p.getLocation(), player2.getLocation()) <= VoiceModule.getVerticalStrength()).filter(p -> {
                    Member m = VoiceModule.getMember(p.getUniqueId());
                    return m != null && m.getVoiceState() != null && m.getVoiceState().getChannel() != null && m.getVoiceState().getChannel().getParent() != null && m.getVoiceState().getChannel().getParent().equals(category);
                }).map(OfflinePlayer::getUniqueId).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet));
                if (playersWithinRange.isEmpty()) continue;
                if (category.getChannels().size() == 50) {
                    DiscordSRV.debug(Debug.VOICE, "Can't create new voice network because category " + category.getName() + " is full of channels");
                    continue;
                }
                playersWithinRange.add(uuid);
                this.networks.add(new Network(playersWithinRange));
            }
            HashSet<Member> members = new HashSet<Member>(lobbyChannel.getMembers());
            for (Network network3 : this.getNetworks()) {
                voiceChannel = network3.getChannel();
                if (voiceChannel == null) continue;
                members.addAll(voiceChannel.getMembers());
            }
            for (Member member : members) {
                Pair<String, CompletableFuture<Void>> awaitingMove;
                VoiceChannel shouldBeInChannel;
                Network playerNetwork;
                UUID uuid = VoiceModule.getUniqueId(member);
                playerChannel = member.getVoiceState().getChannel();
                Network network4 = playerNetwork = uuid != null ? (Network)this.networks.stream().filter(n -> n.contains(uuid)).findAny().orElse(null) : null;
                if (playerNetwork != null) {
                    if (playerNetwork.getChannel() == null) continue;
                    shouldBeInChannel = playerNetwork.getChannel();
                } else {
                    shouldBeInChannel = lobbyChannel;
                }
                if ((awaitingMove = this.awaitingMoves.get(member.getId())) != null && awaitingMove.getLeft().equals(shouldBeInChannel.getId()) || awaitingMove != null && !awaitingMove.getLeft().equals(shouldBeInChannel.getId()) && !awaitingMove.getRight().cancel(false) || playerChannel.getId().equals(shouldBeInChannel.getId())) continue;
                this.awaitingMoves.put(member.getId(), Pair.of(shouldBeInChannel.getId(), VoiceModule.getGuild().moveVoiceMember(member, shouldBeInChannel).submit().whenCompleteAsync((v, t) -> this.awaitingMoves.remove(member.getId()))));
            }
            for (Network network3 : new HashSet<Network>(this.networks)) {
                if (!network3.isEmpty() || (voiceChannel = network3.getChannel()) == null || !voiceChannel.getMembers().isEmpty()) continue;
                voiceChannel.delete().reason("Lost communication").queue();
                this.networks.remove(network3);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.markDirty(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        this.markDirty(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.markDirty(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.networks.stream().filter(network -> network.contains(event.getPlayer().getUniqueId())).forEach(network -> network.remove(event.getPlayer().getUniqueId())));
    }

    @Override
    public void onGuildVoiceJoin(GuildVoiceJoinEvent event) {
        this.checkMutedUser(event.getChannelJoined(), event.getMember());
        if (!event.getChannelJoined().equals(VoiceModule.getLobbyChannel())) {
            return;
        }
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getMember().getUser().getId());
        if (uuid == null) {
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        if (player.isOnline()) {
            this.markDirty(player.getPlayer());
        }
    }

    @Override
    public void onGuildVoiceMove(GuildVoiceMoveEvent event) {
        if (event.getChannelJoined().getParent() != null && !event.getChannelJoined().getParent().equals(VoiceModule.getCategory()) && event.getChannelLeft().getParent() != null && event.getChannelLeft().getParent().equals(VoiceModule.getCategory())) {
            UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getMember().getUser().getId());
            if (uuid == null) {
                return;
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.isOnline()) {
                this.networks.stream().filter(network -> network.contains(player.getPlayer().getUniqueId())).forEach(network -> network.remove(player.getPlayer()));
            }
        }
        this.checkMutedUser(event.getChannelJoined(), event.getMember());
    }

    @Override
    public void onGuildVoiceLeave(GuildVoiceLeaveEvent event) {
        this.checkMutedUser(event.getChannelJoined(), event.getMember());
        if (event.getChannelLeft().getParent() == null || !event.getChannelLeft().getParent().equals(VoiceModule.getCategory())) {
            return;
        }
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(event.getMember().getUser().getId());
        if (uuid == null) {
            return;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        if (player.isOnline()) {
            this.networks.stream().filter(network -> network.contains(player.getPlayer())).forEach(network -> network.remove(player.getPlayer()));
        }
    }

    @Override
    public void onVoiceChannelDelete(@NotNull VoiceChannelDeleteEvent event) {
        this.networks.removeIf(network -> network.getChannel() != null && event.getChannel().getId().equals(network.getChannel().getId()));
    }

    private void markDirty(Player player) {
        this.dirtyPlayers.add(player.getUniqueId());
    }

    private void checkMutedUser(VoiceChannel channel, Member member) {
        if (channel == null || member.getVoiceState() == null || VoiceModule.getLobbyChannel() == null || VoiceModule.getCategory() == null) {
            return;
        }
        boolean isLobby = channel.getId().equals(VoiceModule.getLobbyChannel().getId());
        if (isLobby && !member.getVoiceState().isGuildMuted()) {
            if (!DiscordSRV.config().getBoolean("Mute users who bypass speak permissions in the lobby")) {
                return;
            }
            PermissionOverride override = channel.getPermissionOverride(channel.getGuild().getPublicRole());
            if (override != null && override.getDenied().contains((Object)Permission.VOICE_SPEAK) && member.hasPermission((GuildChannel)channel, Permission.VOICE_SPEAK, Permission.VOICE_MUTE_OTHERS) && channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, Permission.VOICE_MUTE_OTHERS) && channel.getGuild().getSelfMember().hasPermission((GuildChannel)VoiceModule.getCategory(), Permission.VOICE_MOVE_OTHERS)) {
                member.mute(true).queue();
                this.mutedUsers.add(member.getId());
            }
        } else if (!isLobby && this.mutedUsers.remove(member.getId())) {
            member.mute(false).queue();
        }
    }

    public void shutdown() {
        for (Pair<String, CompletableFuture<Void>> value : this.awaitingMoves.values()) {
            value.getRight().cancel(true);
        }
        for (Network network : this.networks) {
            for (Member member : network.getChannel().getMembers()) {
                member.getGuild().moveVoiceMember(member, VoiceModule.getLobbyChannel()).queue();
            }
            network.getChannel().delete().queue();
            network.clear();
        }
        this.networks.clear();
    }

    public static VoiceModule get() {
        return DiscordSRV.getPlugin().getVoiceModule();
    }

    public static Guild getGuild() {
        return VoiceModule.getCategory().getGuild();
    }

    public static Category getCategory() {
        if (DiscordUtil.getJda() == null) {
            return null;
        }
        String id = DiscordSRV.config().getString("Voice category");
        if (StringUtils.isBlank(id)) {
            return null;
        }
        return DiscordUtil.getJda().getCategoryById(id);
    }

    public static VoiceChannel getLobbyChannel() {
        if (DiscordUtil.getJda() == null) {
            return null;
        }
        String id = DiscordSRV.config().getString("Lobby channel");
        if (StringUtils.isBlank(id)) {
            return null;
        }
        return DiscordUtil.getJda().getVoiceChannelById(id);
    }

    public static Member getMember(UUID player) {
        String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player);
        return discordId != null ? VoiceModule.getGuild().getMemberById(discordId) : null;
    }

    public static UUID getUniqueId(Member member) {
        return DiscordSRV.getPlugin().getAccountLinkManager().getUuid(member.getId());
    }

    public static double verticalDistance(Location location1, Location location2) {
        return Math.sqrt(NumberConversions.square((double)(location1.getY() - location2.getY())));
    }

    public static double horizontalDistance(Location location1, Location location2) {
        return Math.sqrt(NumberConversions.square((double)(location1.getX() - location2.getX())) + NumberConversions.square((double)(location1.getZ() - location2.getZ())));
    }

    public static double getVerticalStrength() {
        return DiscordSRV.config().getDouble("Network.Vertical Strength");
    }

    public static double getHorizontalStrength() {
        return DiscordSRV.config().getDouble("Network.Horizontal Strength");
    }

    public static double getFalloff() {
        return DiscordSRV.config().getDouble("Network.Falloff");
    }

    public static boolean isVoiceChannelsVisible() {
        return DiscordSRV.config().getBoolean("Network.Channels are visible");
    }

    public Set<Network> getNetworks() {
        return this.networks;
    }

    public Set<String> getMutedUsers() {
        return this.mutedUsers;
    }
}

