/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;

public class CancellationDetector<E extends Cancellable> {
    private final Plugin plugin;
    private final Class<?> eventClass;
    private final BiConsumer<RegisteredListener, E> cancelListener;
    private final ThreadLocal<Boolean> cancelled = ThreadLocal.withInitial(() -> false);
    private final EnumMap<EventPriority, CancellationDetectorList<E>> proxies = new EnumMap(EventPriority.class);
    private EnumMap<EventPriority, ArrayList<RegisteredListener>> originalMap;

    public CancellationDetector(Plugin plugin, @NotNull Class<E> eventClass, BiConsumer<RegisteredListener, E> cancelListener) {
        this.plugin = plugin;
        this.eventClass = eventClass;
        this.cancelListener = cancelListener;
        this.inject();
    }

    public void close() {
        if (this.originalMap == null) {
            return;
        }
        try {
            for (Map.Entry<EventPriority, ArrayList<RegisteredListener>> entry : this.originalMap.entrySet()) {
                ArrayList<RegisteredListener> list = entry.getValue();
                list.clear();
                list.addAll(((CancellationDetectorList)this.proxies.get(entry.getKey())).getRaw());
            }
            HandlerList handlerList = this.getHandlerList();
            this.setSlots(handlerList, this.originalMap);
            Field handlers = handlerList.getClass().getDeclaredField("handlers");
            handlers.setAccessible(true);
            handlers.set(handlerList, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to clean up handler list.", e);
        }
        this.originalMap = null;
    }

    private void inject() {
        HandlerList handlerList = this.getHandlerList();
        EnumMap<EventPriority, ArrayList<RegisteredListener>> slots = this.getSlots(handlerList);
        this.originalMap = slots.clone();
        for (EventPriority eventPriority : slots.keySet()) {
            List original = this.originalMap.get(eventPriority);
            CancellationDetectorList proxy = new CancellationDetectorList(original, this);
            slots.put(eventPriority, proxy);
            this.proxies.put(eventPriority, proxy);
        }
    }

    private HandlerList getHandlerList() {
        for (Class<?> currentClass = this.eventClass; currentClass != null && Event.class.isAssignableFrom(currentClass); currentClass = currentClass.getSuperclass()) {
            try {
                Method method = currentClass.getDeclaredMethod("getHandlerList", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return (HandlerList)method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException ignored) {
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not get HandlerList", e);
            }
        }
        throw new RuntimeException("Unable to find HandlerList");
    }

    public void setSlots(HandlerList handlerList, EnumMap<EventPriority, ArrayList<RegisteredListener>> slots) {
        try {
            CancellationDetector.getSlotsField().set(handlerList, slots);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to set handlerslots field", e);
        }
    }

    public EnumMap<EventPriority, ArrayList<RegisteredListener>> getSlots(HandlerList handlerList) {
        try {
            return (EnumMap)CancellationDetector.getSlotsField().get(handlerList);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to get handlerslots field", e);
        }
    }

    private static Field getSlotsField() throws NoSuchFieldException {
        Field field = HandlerList.class.getDeclaredField("handlerslots");
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static class CancellationDetectorList<E extends Cancellable>
    extends ArrayList<RegisteredListener> {
        private final CancellationDetector<E> detector;

        public CancellationDetectorList(Collection<RegisteredListener> original, CancellationDetector<E> detector) {
            super(original);
            this.detector = detector;
        }

        private List<RegisteredListener> getRaw() {
            Iterator iterator = this.iterator();
            ArrayList<RegisteredListener> listeners = new ArrayList<RegisteredListener>();
            while (iterator.hasNext()) {
                listeners.add((RegisteredListener)iterator.next());
            }
            return listeners;
        }

        private List<RegisteredListener> getListeners() {
            ArrayList<RegisteredListener> listeners = new ArrayList<RegisteredListener>();
            listeners.add(new CancellationDetectingListener<E>(null, this.detector));
            for (RegisteredListener listener : this) {
                listeners.add(listener);
                listeners.add(new CancellationDetectingListener<E>(listener, this.detector));
            }
            return listeners;
        }

        @Override
        public Object @NotNull [] toArray() {
            return this.getListeners().toArray();
        }

        @Override
        public <T> T @NotNull [] toArray(T[] a) {
            return this.getListeners().toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof CancellationDetectingListener) {
                return true;
            }
            return super.remove(o);
        }

        @Override
        public boolean add(RegisteredListener registeredListener) {
            if (registeredListener instanceof CancellationDetectingListener) {
                return true;
            }
            return super.add(registeredListener);
        }
    }

    public static class CancellationDetectingListener<E extends Cancellable>
    extends RegisteredListener {
        private final RegisteredListener listener;
        private final CancellationDetector<E> detector;

        public CancellationDetectingListener(RegisteredListener listener, CancellationDetector<E> detector) {
            super(new Listener(){}, (l, e) -> {}, listener != null ? listener.getPriority() : EventPriority.LOWEST, ((CancellationDetector)detector).plugin, false);
            this.listener = listener;
            this.detector = detector;
        }

        public void callEvent(@NotNull Event event) throws EventException {
            boolean cancelled = event instanceof Cancellable && ((Cancellable)event).isCancelled();
            boolean wasCancelled = (Boolean)((CancellationDetector)this.detector).cancelled.get();
            if (cancelled && !wasCancelled && this.listener != null) {
                ((CancellationDetector)this.detector).cancelListener.accept(this.listener, (Cancellable)event);
            }
            if (cancelled != wasCancelled) {
                ((CancellationDetector)this.detector).cancelled.set(cancelled);
            }
        }
    }
}

