/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import github.scarsz.discordsrv.util.DiscordUtil;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DiscordSRVMinecraftRenderer
extends DefaultMinecraftRenderer {
    @Override
    @Nullable
    public Component appendEmoteMention(@NonNull Component component, @NonNull String name, @NonNull String id) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String behavior = DiscordSRV.config().getString("DiscordChatChannelEmoteBehavior");
        return behavior.equalsIgnoreCase("name") ? component.append(Component.text(":" + name + ":")) : component;
    }

    @Override
    @Nullable
    public Component appendChannelMention(@NonNull Component component, @NonNull String id) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        TextChannel textChannel = DiscordUtil.getTextChannelById(id);
        if (textChannel != null) {
            component = component.append(Component.text("#" + textChannel.getName()));
        }
        return component;
    }

    @Override
    @Nullable
    public Component appendUserMention(@NonNull Component component, @NonNull String id) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Member member = DiscordUtil.getMemberById(id);
        if (member != null) {
            component = component.append(Component.text("@" + member.getEffectiveName()));
        }
        return component;
    }

    @Override
    @Nullable
    public Component appendRoleMention(@NonNull Component component, @NonNull String id) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Role role = null;
        try {
            role = DiscordUtil.getJda().getRoleById(id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (role != null) {
            component = component.append(Component.text("@" + role.getName()));
        }
        return component;
    }
}

