/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects;

import github.scarsz.discordsrv.dependencies.commons.collections4.bidimap.DualHashBidiMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ExpiringDualHashBidiMap<K, V>
extends DualHashBidiMap<K, V> {
    private final HashMap<K, Long> expiryTimes = new HashMap();
    private final long expiryDelay;

    public ExpiringDualHashBidiMap(long expiryDelayMillis) {
        this.expiryDelay = expiryDelayMillis;
        ExpiryThread.references.add(new WeakReference<ExpiringDualHashBidiMap>(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        HashMap<K, Long> hashMap = this.expiryTimes;
        synchronized (hashMap) {
            this.expiryTimes.put(key, System.currentTimeMillis() + this.expiryDelay);
        }
        return super.put(key, value);
    }

    public V putNotExpiring(K key, V value) {
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putExpiring(K key, V value, long expiryTime) {
        if (expiryTime < System.currentTimeMillis()) {
            throw new IllegalArgumentException("The expiry time must be in the future");
        }
        HashMap<K, Long> hashMap = this.expiryTimes;
        synchronized (hashMap) {
            this.expiryTimes.put(key, expiryTime);
        }
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        HashMap<K, Long> hashMap = this.expiryTimes;
        synchronized (hashMap) {
            this.expiryTimes.remove(key);
        }
        return super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K removeValue(Object value) {
        Object key = this.getKey(value);
        if (key != null) {
            HashMap<K, Long> hashMap = this.expiryTimes;
            synchronized (hashMap) {
                this.expiryTimes.remove(key);
            }
        }
        return super.removeValue(value);
    }

    public long getExpiryTime(K key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("The given key is not in the map");
        }
        return this.expiryTimes.get(key);
    }

    public void setExpiryTime(K key, long expiryTimeMillis) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("The given key is not in the map");
        }
        this.expiryTimes.put(key, expiryTimeMillis);
    }

    public long getExpiryDelay() {
        return this.expiryDelay;
    }

    private void keyExpired(Object key) {
        this.remove(key);
        this.expiryTimes.remove(key);
    }

    public static class ExpiryThread
    extends Thread {
        private static final Set<WeakReference<ExpiringDualHashBidiMap<?, ?>>> references = new HashSet();

        private ExpiryThread() {
            super("DiscordSRV " + ExpiryThread.class.getSimpleName());
            Runtime.getRuntime().addShutdownHook(new Thread(this::interrupt));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                long currentTime = System.currentTimeMillis();
                for (WeakReference<ExpiringDualHashBidiMap<?, ?>> reference : new HashSet(references)) {
                    HashMap expiryTimes;
                    ExpiringDualHashBidiMap collection = (ExpiringDualHashBidiMap)reference.get();
                    if (collection == null) {
                        references.remove(reference);
                        continue;
                    }
                    HashMap hashMap = collection.expiryTimes;
                    synchronized (hashMap) {
                        expiryTimes = new HashMap(collection.expiryTimes);
                    }
                    ArrayList removals = new ArrayList();
                    expiryTimes.entrySet().stream().filter(entry -> (Long)entry.getValue() < currentTime).forEach(entry -> removals.add(entry.getKey()));
                    ExpiringDualHashBidiMap expiringDualHashBidiMap = collection;
                    synchronized (expiringDualHashBidiMap) {
                        removals.forEach(x$0 -> collection.keyExpired(x$0));
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    break;
                }
            }
        }

        static {
            new ExpiryThread().start();
        }
    }
}

