/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects;

public class Lag
implements Runnable {
    private static final long[] TICKS = new long[600];
    private static int TICK_COUNT = 0;

    public static String getTPSString() {
        try {
            String tps;
            double tpsDouble = Lag.getTPS();
            if (tpsDouble > 19.5) {
                tpsDouble = 20.0;
            }
            return (tps = Double.toString(tpsDouble)).length() > 4 ? tps.substring(0, 4) : tps;
        }
        catch (Exception e) {
            return "3.14";
        }
    }

    private static double getTPS() {
        return Lag.getTPS(100);
    }

    private static double getTPS(int ticks) {
        if (TICK_COUNT < ticks) {
            return 20.0;
        }
        int target = (TICK_COUNT - 1 - ticks) % TICKS.length;
        long elapsed = System.currentTimeMillis() - TICKS[target];
        return (double)ticks / ((double)elapsed / 1000.0);
    }

    @Override
    public void run() {
        Lag.TICKS[Lag.TICK_COUNT % Lag.TICKS.length] = System.currentTimeMillis();
        ++TICK_COUNT;
    }
}

