/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.log4j;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;

public class JdaFilter
implements Filter {
    public Filter.Result check(String loggerName, Level level, String message, Throwable throwable) {
        if (!loggerName.startsWith("github.scarsz.discordsrv.dependencies.jda")) {
            return Filter.Result.NEUTRAL;
        }
        switch (level.name()) {
            case "INFO": {
                DiscordSRV.info("[JDA] " + message);
                break;
            }
            case "WARN": {
                if (message.contains("Encountered 429")) {
                    DiscordSRV.debug(message);
                    break;
                }
                DiscordSRV.warning("[JDA] " + message);
                break;
            }
            case "ERROR": {
                if (message.contains("Requester timed out while executing a request")) {
                    DiscordSRV.error("[JDA] " + message + ". This is either a issue on Discord's end (https://discordstatus.com) or with your server's connection");
                    DiscordSRV.debug(ExceptionUtils.getStackTrace(throwable));
                    break;
                }
                if (message.contains("There was an I/O error while executing a REST request: null") && DiscordSRV.shuttingDown) {
                    return Filter.Result.DENY;
                }
                if (throwable != null) {
                    DiscordSRV.error("[JDA] " + message + "\n" + ExceptionUtils.getStackTrace(throwable));
                    break;
                }
                DiscordSRV.error("[JDA] " + message);
                break;
            }
            default: {
                if (!Debug.JDA.isVisible()) break;
                DiscordSRV.debug("[JDA] " + message);
            }
        }
        return Filter.Result.DENY;
    }

    public Filter.Result filter(LogEvent logEvent) {
        return this.check(logEvent.getLoggerName(), logEvent.getLevel(), logEvent.getMessage().getFormattedMessage(), logEvent.getThrown());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object ... parameters) {
        return this.check(logger.getName(), level, message, null);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object message, Throwable throwable) {
        return this.check(logger.getName(), level, message.toString(), throwable);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return this.check(logger.getName(), level, message.getFormattedMessage(), throwable);
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStopped() {
        return false;
    }

    public Filter.Result getOnMismatch() {
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result getOnMatch() {
        return Filter.Result.NEUTRAL;
    }
}

