/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.commands.CommandBroadcast;
import github.scarsz.discordsrv.commands.CommandDebugger;
import github.scarsz.discordsrv.commands.CommandHelp;
import github.scarsz.discordsrv.commands.CommandLanguage;
import github.scarsz.discordsrv.commands.CommandLink;
import github.scarsz.discordsrv.commands.CommandLinked;
import github.scarsz.discordsrv.commands.CommandReload;
import github.scarsz.discordsrv.commands.CommandResync;
import github.scarsz.discordsrv.commands.CommandUnlink;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandManager {
    private final Map<String, Method> commands = new HashMap<String, Method>();

    public CommandManager() {
        List<Class> commandClasses = Arrays.asList(CommandBroadcast.class, CommandDebugger.class, CommandHelp.class, CommandLanguage.class, CommandLink.class, CommandLinked.class, CommandReload.class, CommandResync.class, CommandUnlink.class);
        for (Class clazz : commandClasses) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Command.class)) continue;
                if (method.getParameters().length != 2) {
                    DiscordSRV.debug("Method " + method.toGenericString().replace("public static void ", "") + " annotated as command but parameters count != 2");
                    continue;
                }
                if (method.getParameters()[0].getType() != CommandSender.class && method.getParameters()[0].getType() != Player.class) {
                    DiscordSRV.debug("Method " + method.toGenericString().replace("public static void ", "") + " annotated as command but parameter 1's type != CommandSender || Player");
                    continue;
                }
                if (method.getParameters()[1].getType() != String[].class) {
                    DiscordSRV.debug("Method " + method.toGenericString().replace("public static void ", "") + " annotated as command but parameter 2's type != String[]");
                    continue;
                }
                Command annotation = method.getAnnotation(Command.class);
                for (String commandName : annotation.commandNames()) {
                    this.commands.put(commandName.toLowerCase(), method);
                }
            }
        }
    }

    public boolean handle(CommandSender sender, String command, String[] args) {
        if (command == null) {
            OfflinePlayer offlinePlayer = sender instanceof Player ? Bukkit.getOfflinePlayer((UUID)((Player)sender).getUniqueId()) : null;
            String message = PlaceholderUtil.replacePlaceholders(LangUtil.Message.DISCORD_COMMAND.toString(), offlinePlayer).replace("{INVITE}", DiscordSRV.config().getString("DiscordInviteLink"));
            for (String line : message.split("\n")) {
                MessageUtil.sendMessage(sender, line);
            }
            return true;
        }
        if (this.commands.containsKey(command.toLowerCase())) {
            try {
                Method commandMethod = this.commands.get(command.toLowerCase());
                Command commandAnnotation = commandMethod.getAnnotation(Command.class);
                if (!GamePermissionUtil.hasPermission((Permissible)sender, commandAnnotation.permission())) {
                    MessageUtil.sendMessage(sender, LangUtil.Message.NO_PERMISSION.toString());
                    return true;
                }
                if (commandMethod.getParameters()[0].getType() == Player.class && !(sender instanceof Player)) {
                    MessageUtil.sendMessage(sender, ChatColor.RED + LangUtil.InternalMessage.PLAYER_ONLY_COMMAND.toString());
                    return true;
                }
                commandMethod.invoke(null, sender, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                MessageUtil.sendMessage(sender, ChatColor.RED + "" + (Object)((Object)LangUtil.InternalMessage.COMMAND_EXCEPTION));
                DiscordSRV.error(e);
            }
        } else {
            MessageUtil.sendMessage(sender, LangUtil.Message.COMMAND_DOESNT_EXIST.toString());
        }
        return true;
    }

    public Map<String, Method> getCommands() {
        return this.commands;
    }
}

