/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.ArrayUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.ISnowflake;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberJoinEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberRemoveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberRoleAddEvent;
import github.scarsz.discordsrv.dependencies.jda.api.events.guild.member.GuildMemberRoleRemoveEvent;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorResponseException;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.requests.ErrorResponse;
import github.scarsz.discordsrv.objects.ExpiringDualHashBidiMap;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class GroupSynchronizationManager
extends ListenerAdapter
implements Listener {
    private final AtomicInteger synchronizationCount = new AtomicInteger(0);
    private final Map<Member, Map.Entry<Guild, Map<String, Set<Role>>>> justModifiedRoles = new HashMap<Member, Map.Entry<Guild, Map<String, Set<Role>>>>();
    private final Map<UUID, Map<String, List<String>>> justModifiedGroups = new ExpiringDualHashBidiMap<UUID, Map<String, List<String>>>(TimeUnit.MINUTES.toMillis(1L));
    private final Map<String, Set<String>> membersNotInGuilds = new ConcurrentHashMap<String, Set<String>>();
    private final String userRegex = "([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}|[a-zA-Z0-9_]{1,16})";
    private final List<Pattern> patterns = Arrays.asList(Pattern.compile("/?manu(?:add(?:sub)?|del(?:sub)?|promote|demote) ([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}|[a-zA-Z0-9_]{1,16}).*", 2), Pattern.compile("/?pex user ([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}|[a-zA-Z0-9_]{1,16}) group(?: timed)? (?:add)|(?:set)|(?:remove) .*", 2), Pattern.compile("/?permissions player ([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}|[a-zA-Z0-9_]{1,16}) (?:(?:setgroup)|(?:addgroup)|(?:removegroup)).*", 2), Pattern.compile("/?(?:un)?setrank ([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}|[a-zA-Z0-9_]{1,16}).*", 2), Pattern.compile("/?(?:pex )?(?:promote|demote) ([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}|[a-zA-Z0-9_]{1,16}).*", 2));
    private Permission permission = null;
    private boolean warnedAboutMissingVault = false;

    @Deprecated
    public void resync() {
        this.resync(SyncCause.LEGACY);
    }

    @Deprecated
    public void resync(SyncDirection direction) {
        this.resync(direction, SyncCause.LEGACY);
    }

    @Deprecated
    public void resync(User user) {
        this.resync(user, SyncCause.LEGACY);
    }

    @Deprecated
    public void resync(User user, SyncDirection direction) {
        this.resync(user, direction, SyncCause.LEGACY);
    }

    @Deprecated
    public void resync(OfflinePlayer player) {
        this.resync(player, SyncCause.LEGACY);
    }

    @Deprecated
    public void resync(OfflinePlayer player, SyncDirection direction) {
        this.resync(player, direction, SyncCause.LEGACY);
    }

    @Deprecated
    public void resync(OfflinePlayer player, SyncDirection direction, boolean addLinkedRole) {
        this.resync(player, direction, addLinkedRole, SyncCause.LEGACY);
    }

    @Deprecated
    public void resyncEveryone() {
        this.resyncEveryone(SyncCause.LEGACY);
    }

    @Deprecated
    public void resyncEveryone(SyncDirection direction) {
        this.resyncEveryone(direction, SyncCause.LEGACY);
    }

    public void resync(SyncCause cause) {
        this.resync(SyncDirection.AUTHORITATIVE, cause);
    }

    public void resync(SyncDirection direction, SyncCause cause) {
        if (this.getPermissions() == null) {
            return;
        }
        HashSet<Player> players = new HashSet<Player>(PlayerUtil.getOnlinePlayers());
        if (DiscordSRV.config().getBoolean("GroupRoleSynchronizationCycleCompletely")) {
            DiscordUtil.getJda().getGuilds().stream().flatMap(guild -> guild.getMembers().stream()).map(member -> DiscordSRV.getPlugin().getAccountLinkManager().getUuid(member.getId())).filter(Objects::nonNull).map(Bukkit::getOfflinePlayer).forEach(players::add);
        }
        players.forEach(player -> this.resync((OfflinePlayer)player, direction, cause));
    }

    public void resync(User user, SyncCause cause) {
        this.resync(user, SyncDirection.AUTHORITATIVE, cause);
    }

    public void resync(User user, SyncDirection direction, SyncCause cause) {
        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(user.getId());
        if (uuid == null) {
            DiscordSRV.debug(Debug.GROUP_SYNC, "Tried to sync groups for " + user + " but their Discord account is not linked to a MC account");
            return;
        }
        this.resync(Bukkit.getOfflinePlayer((UUID)uuid), direction, cause);
    }

    public void resync(OfflinePlayer player, SyncCause cause) {
        this.resync(player, SyncDirection.AUTHORITATIVE, cause);
    }

    public void resync(OfflinePlayer player, SyncDirection direction, SyncCause cause) {
        this.resync(player, direction, false, cause);
    }

    public void resync(OfflinePlayer player, SyncDirection direction, boolean addLinkedRole, SyncCause cause) {
        boolean discordIsStrictlyAuthoritative;
        if (player == null) {
            return;
        }
        if (this.getPermissions() == null) {
            DiscordSRV.debug(Debug.GROUP_SYNC, "Can't synchronize groups/roles for " + player.getName() + ", permissions provider is null");
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Resync cannot be run on the server main thread");
        }
        if (DiscordSRV.getPlugin().getAccountLinkManager() == null) {
            DiscordSRV.debug(Debug.GROUP_SYNC, "Tried to sync groups for player " + player.getName() + " but the AccountLinkManager wasn't initialized yet");
            return;
        }
        String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
        if (discordId == null) {
            DiscordSRV.debug(Debug.GROUP_SYNC, "Tried to sync groups for player " + player.getName() + " but their MC account is not linked to a Discord account. Synchronization cause: " + (Object)((Object)cause));
            return;
        }
        User user = DiscordUtil.getUserById(discordId);
        if (user == null) {
            DiscordSRV.debug(Debug.GROUP_SYNC, "Tried to sync groups for player " + player.getName() + " but Discord user is not available");
            return;
        }
        int id = this.synchronizationCount.incrementAndGet();
        boolean vaultGroupsLogged = false;
        ArrayList<String> synchronizationSummary = new ArrayList<String>();
        synchronizationSummary.add("Group synchronization (#" + id + ") " + (Object)((Object)direction) + " for {" + player.getName() + ":" + user + "}. Synchronization cause: " + (Object)((Object)cause));
        ArrayList<String> bothSidesTrue = new ArrayList<String>();
        ArrayList bothSidesFalse = new ArrayList();
        ArrayList<String> groupsGrantedByPermission = new ArrayList<String>();
        ArrayList<String> groupsDeniedByPermission = new ArrayList<String>();
        HashMap<Guild, Map> roleChanges = new HashMap<Guild, Map>();
        boolean oneWaySynchronisation = DiscordSRV.config().getBoolean("GroupRoleSynchronizationOneWay");
        boolean minecraftIsStrictlyAuthoritative = oneWaySynchronisation && DiscordSRV.config().getBoolean("GroupRoleSynchronizationMinecraftIsAuthoritative");
        boolean bl = discordIsStrictlyAuthoritative = oneWaySynchronisation && !DiscordSRV.config().getBoolean("GroupRoleSynchronizationMinecraftIsAuthoritative");
        if (oneWaySynchronisation) {
            synchronizationSummary.add("Synchronisation is one way (" + (minecraftIsStrictlyAuthoritative ? "Minecraft -> Discord" : "Discord -> Minecraft") + ")");
        }
        if (minecraftIsStrictlyAuthoritative && direction == SyncDirection.TO_MINECRAFT || discordIsStrictlyAuthoritative && direction == SyncDirection.TO_DISCORD) {
            DiscordSRV.debug(Debug.GROUP_SYNC, "Group synchronization (#" + id + ") " + (Object)((Object)direction) + " cancelled because " + (minecraftIsStrictlyAuthoritative ? "Minecraft" : "Discord") + " is strictly authoritative");
            return;
        }
        for (Map.Entry<String, String> entry : DiscordSRV.getPlugin().getGroupSynchronizables().entrySet()) {
            Runnable runnable;
            boolean luckPerms;
            boolean minecraftIsAuthoritative;
            boolean hasGroup;
            Member member;
            Role role;
            String groupName;
            block50: {
                Object[] playerGroups;
                block49: {
                    groupName = entry.getKey();
                    String roleId = entry.getValue();
                    if (StringUtils.isBlank(groupName) || StringUtils.isBlank(roleId.replace("0", ""))) continue;
                    role = DiscordUtil.getRole(roleId);
                    if (role == null) {
                        synchronizationSummary.add("Tried to sync role " + roleId + " but could not find role");
                        continue;
                    }
                    if (role.isPublicRole()) {
                        synchronizationSummary.add("Skipping role " + roleId + " because it's a Guild's public role");
                        continue;
                    }
                    Guild guild2 = role.getGuild();
                    Set membersNotInGuild = this.membersNotInGuilds.computeIfAbsent(guild2.getId(), key -> new HashSet());
                    if (guild2.getMember(user) != null) {
                        membersNotInGuild.remove(user.getId());
                    }
                    if (membersNotInGuild.contains(user.getId())) {
                        synchronizationSummary.add("Tried to sync role " + role + " but the user wasn't a member in the guild the role is in (cached)");
                        continue;
                    }
                    try {
                        member = guild2.retrieveMember(user, false).complete();
                    }
                    catch (ErrorResponseException e) {
                        if (e.getErrorResponse() == ErrorResponse.UNKNOWN_MEMBER) {
                            membersNotInGuild.add(user.getId());
                            synchronizationSummary.add("Tried to sync role " + role + " but the user wasn't a member in the guild the role is in (Discord response)");
                            continue;
                        }
                        DiscordSRV.error(e);
                        continue;
                    }
                    if (member == null) {
                        synchronizationSummary.add("Tried to sync " + role + " but could not find " + user + " in the role's Discord server, treating it as if they don't have the role");
                    }
                    try {
                        playerGroups = this.getPermissions().getPlayerGroups(null, player);
                        if (playerGroups == null) {
                            synchronizationSummary.add("Tried to sync {" + role + ":" + groupName + "} but Vault returned null as the player's groups (Player is " + (player.isOnline() ? "online" : "offline") + ")");
                        }
                        break block49;
                    }
                    catch (Throwable t2) {
                        this.vaultError("Could not get player's groups", t2);
                    }
                    continue;
                }
                boolean primaryGroupOnly = DiscordSRV.config().getBoolean("GroupRoleSynchronizationPrimaryGroupOnly");
                if (!vaultGroupsLogged) {
                    synchronizationSummary.add("Player " + player.getName() + "'s " + (primaryGroupOnly ? "Primary group: " + this.getPermissions().getPrimaryGroup(null, player) + ", " : "") + "Vault groups: " + Arrays.toString(playerGroups) + " (Player is " + (player.isOnline() ? "online" : "offline") + ")");
                    vaultGroupsLogged = true;
                }
                try {
                    boolean bl2 = hasGroup = primaryGroupOnly ? groupName.equalsIgnoreCase(this.getPermissions().getPrimaryGroup(null, player)) : this.getPermissions().playerInGroup(null, player, groupName);
                    if (this.getPermissions().playerHas(null, player, "discordsrv.sync." + groupName)) {
                        hasGroup = true;
                        groupsGrantedByPermission.add(groupName);
                    }
                    if (!DiscordSRV.config().getBoolean("GroupRoleSynchronizationEnableDenyPermission") || !this.getPermissions().playerHas(null, player, "discordsrv.sync.deny." + groupName)) break block50;
                    hasGroup = false;
                    groupsDeniedByPermission.add(groupName);
                }
                catch (Throwable t3) {
                    this.vaultError("Could not check the player's groups/permissions", t3);
                    continue;
                }
            }
            boolean hasRole = member != null && member.getRoles().contains(role);
            boolean roleIsManaged = role.isManaged();
            if (roleIsManaged && minecraftIsStrictlyAuthoritative) {
                synchronizationSummary.add("Tried to sync {" + role + ":" + groupName + "} to Discord but the role is managed and Minecraft is strictly authoritative");
                continue;
            }
            boolean bl3 = minecraftIsStrictlyAuthoritative || !roleIsManaged && !discordIsStrictlyAuthoritative && (direction == SyncDirection.AUTHORITATIVE ? DiscordSRV.config().getBoolean("GroupRoleSynchronizationMinecraftIsAuthoritative") : direction == SyncDirection.TO_DISCORD) ? true : (minecraftIsAuthoritative = false);
            if (hasGroup == hasRole) {
                (hasGroup ? bothSidesTrue : bothSidesFalse).add("{" + groupName + ":" + role + "}" + (roleIsManaged ? " (Managed Role)" : ""));
                continue;
            }
            if (!hasGroup) {
                if (minecraftIsAuthoritative) {
                    roleChanges.computeIfAbsent(role.getGuild(), g -> new HashMap()).computeIfAbsent("remove", s -> new HashSet()).add(role);
                    synchronizationSummary.add("{" + groupName + ":" + role + "} removes Discord role");
                    continue;
                }
                luckPerms = PluginUtil.pluginHookIsEnabled("LuckPerms");
                List additions = this.justModifiedGroups.computeIfAbsent(player.getUniqueId(), key -> new HashMap()).computeIfAbsent("add", key -> new ArrayList());
                runnable = () -> {
                    try {
                        Object[] serverGroups = this.getPermissions().getGroups();
                        if (ArrayUtils.contains(serverGroups, groupName)) {
                            if (!this.getPermissions().playerAddGroup(null, player, groupName)) {
                                DiscordSRV.debug(Debug.GROUP_SYNC, "Synchronization #" + id + " for {" + player.getName() + ":" + user + "} failed: adding group " + groupName + ", returned a failure");
                                additions.remove(groupName);
                            }
                        } else {
                            DiscordSRV.debug(Debug.GROUP_SYNC, "Synchronization #" + id + " for {" + player.getName() + ":" + user + "} failed: group " + groupName + " doesn't exist (Server's Groups: " + Arrays.toString(serverGroups) + ")");
                        }
                    }
                    catch (Throwable t) {
                        this.vaultError("Could not add a player to a group", t);
                    }
                };
                if (luckPerms) {
                    additions.add(groupName);
                    runnable.run();
                } else {
                    SchedulerUtil.runTask((Plugin)DiscordSRV.getPlugin(), runnable);
                }
                synchronizationSummary.add("{" + groupName + ":" + role + "} adds Minecraft group" + (roleIsManaged ? " (Managed Role)" : ""));
                continue;
            }
            if (minecraftIsAuthoritative) {
                roleChanges.computeIfAbsent(role.getGuild(), g -> new HashMap()).computeIfAbsent("add", s -> new HashSet()).add(role);
                synchronizationSummary.add("{" + groupName + ":" + role + "} adds Discord role");
                continue;
            }
            luckPerms = PluginUtil.pluginHookIsEnabled("LuckPerms");
            List removals = this.justModifiedGroups.computeIfAbsent(player.getUniqueId(), key -> new HashMap()).computeIfAbsent("remove", key -> new ArrayList());
            runnable = () -> {
                try {
                    if (this.getPermissions().playerInGroup(null, player, groupName)) {
                        if (!this.getPermissions().playerRemoveGroup(null, player, groupName)) {
                            DiscordSRV.debug(Debug.GROUP_SYNC, "Synchronization #" + id + " for {" + player.getName() + ":" + user + "} failed: removing group " + groupName + " returned a failure");
                            removals.add(groupName);
                        }
                    } else {
                        DiscordSRV.debug(Debug.GROUP_SYNC, "Synchronization #" + id + " for {" + player.getName() + ":" + user + "} failed: player is not in group \"" + groupName + "\"");
                        removals.add(groupName);
                    }
                }
                catch (Throwable t) {
                    this.vaultError("Could not remove a player from a group", t);
                }
            };
            if (luckPerms) {
                removals.add(groupName);
                runnable.run();
            } else {
                SchedulerUtil.runTask((Plugin)DiscordSRV.getPlugin(), runnable);
            }
            synchronizationSummary.add("{" + groupName + ":" + role + "} removes Minecraft group" + (roleIsManaged ? " (Managed Role)" : ""));
        }
        if (!groupsGrantedByPermission.isEmpty()) {
            synchronizationSummary.add("The following groups were granted due to having the discordsrv.sync.<group name> permission(s): " + String.join((CharSequence)" | ", groupsGrantedByPermission));
        }
        if (!groupsDeniedByPermission.isEmpty()) {
            synchronizationSummary.add("The player does not have the following groups due to having the discordsrv.sync.deny.<group name> permission(s): " + String.join((CharSequence)" | ", groupsDeniedByPermission));
        }
        if (!bothSidesTrue.isEmpty()) {
            synchronizationSummary.add("No changes for (Both sides true): " + String.join((CharSequence)" | ", bothSidesTrue));
        }
        if (!bothSidesFalse.isEmpty()) {
            synchronizationSummary.add("No changes for (Both sides false): " + String.join((CharSequence)" | ", bothSidesFalse));
        }
        if (addLinkedRole) {
            try {
                Role role = DiscordUtil.resolveRole(DiscordSRV.config().getString("MinecraftDiscordAccountLinkedRoleNameToAddUserTo"));
                if (role != null) {
                    roleChanges.computeIfAbsent(role.getGuild(), guild -> new HashMap()).computeIfAbsent("add", s -> new HashSet()).add(role);
                } else {
                    DiscordSRV.debug(Debug.GROUP_SYNC, "Couldn't add user to null (\"linked\") role to " + player.getName());
                }
            }
            catch (Throwable t4) {
                DiscordSRV.debug(Debug.GROUP_SYNC, "Couldn't add \"linked\" role to " + player.getName() + " due to exception: " + ExceptionUtils.getMessage(t4));
            }
        }
        for (Map.Entry<String, String> entry : roleChanges.entrySet()) {
            Guild guild3 = (Guild)((Object)entry.getKey());
            Member member = guild3.getMember(user);
            Set<Role> add = ((Map)((Object)entry.getValue())).getOrDefault("add", Collections.emptySet());
            Set<Role> remove = ((Map)((Object)entry.getValue())).getOrDefault("remove", Collections.emptySet());
            if (member == null) {
                synchronizationSummary.add("Synchronization failed for " + user + " in " + guild3 + ": user is not a member");
                continue;
            }
            Member selfMember = guild3.getSelfMember();
            if (!selfMember.canInteract(member)) {
                synchronizationSummary.add("Synchronization failed for " + member + ": can't interact with member" + (member.isOwner() ? " (server owner)" : (!member.getRoles().isEmpty() ? (!selfMember.getRoles().isEmpty() ? (selfMember.getRoles().get(0).getPosition() <= member.getRoles().get(0).getPosition() ? " (member has a higher or equal role: " + member.getRoles().get(0) + " (" + member.getRoles().get(0).getPosition() + "))" : " (bot has a higher role????? bot: " + selfMember.getRoles().get(0) + ", member: " + member.getRoles().get(0) + ")") : " (bot has 0 roles)") : " (bot & member both have 0 roles)")));
                synchronizationSummary.add("Bot's top role in " + guild3 + ": " + (selfMember.getRoles().isEmpty() ? "bot has no roles" : selfMember.getRoles().get(0) + " (" + selfMember.getRoles().get(0).getPosition() + ")"));
                continue;
            }
            if (!selfMember.hasPermission(github.scarsz.discordsrv.dependencies.jda.api.Permission.MANAGE_ROLES)) {
                synchronizationSummary.add("Synchronization failed for " + member + ": bot doesn't have MANAGE_ROLES permission");
                continue;
            }
            boolean anyInteractFail = false;
            Iterator addIterator = add.iterator();
            while (addIterator.hasNext()) {
                Role role = (Role)addIterator.next();
                if (selfMember.canInteract(role)) continue;
                synchronizationSummary.add("Synchronization for role " + role + " (add) in " + guild3 + " failed: can't interact with role (" + role.getPosition() + ")");
                addIterator.remove();
                anyInteractFail = true;
            }
            Iterator removeIterator = add.iterator();
            while (removeIterator.hasNext()) {
                Role role = (Role)removeIterator.next();
                if (selfMember.canInteract(role)) continue;
                synchronizationSummary.add("Synchronization for role " + role + " (remove) in " + guild3 + " failed: can't interact with role (" + role.getPosition() + ")");
                removeIterator.remove();
                anyInteractFail = true;
            }
            if (anyInteractFail) {
                synchronizationSummary.add("Bot's top role in " + guild3 + ": " + (selfMember.getRoles().isEmpty() ? "bot has no roles" : selfMember.getRoles().get(0) + " (" + selfMember.getRoles().get(0).getPosition() + ")"));
            }
            guild3.modifyMemberRoles(member, add, remove).reason("DiscordSRV synchronization").queue(v -> DiscordSRV.debug(Debug.GROUP_SYNC, "Synchronization #" + id + " for {" + player.getName() + ":" + member + "} successful in " + guild3 + ": {add=" + add + ", remove=" + remove + "}"), t -> DiscordSRV.debug(Debug.GROUP_SYNC, "Synchronization #" + id + " for {" + player.getName() + ":" + member + "} failed in " + guild3 + ": " + ExceptionUtils.getStackTrace(t)));
            this.justModifiedRoles.put(member, entry);
        }
        DiscordSRV.debug(Debug.GROUP_SYNC, synchronizationSummary);
    }

    private void vaultError(String problem, Throwable throwable) {
        String name;
        Permission permission = this.getPermissions();
        try {
            name = permission.getName();
        }
        catch (Throwable t) {
            name = permission.getClass().getName();
        }
        DiscordSRV.error(problem + ". Caused by a error in Vault or its permissions provider: " + name, throwable);
    }

    public void resyncEveryone(SyncCause cause) {
        this.resyncEveryone(SyncDirection.AUTHORITATIVE, cause);
    }

    public void resyncEveryone(SyncDirection direction, SyncCause cause) {
        HashSet players = new HashSet();
        DiscordSRV.getPlugin().getAccountLinkManager().getManyDiscordIds(Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getUniqueId).collect(Collectors.toSet())).keySet().stream().map(Bukkit::getOfflinePlayer).filter(Objects::nonNull).forEach(players::add);
        Map<String, UUID> linkedDiscords = DiscordSRV.getPlugin().getAccountLinkManager().getManyUuids(DiscordUtil.getJda().getGuilds().stream().flatMap(guild -> guild.getMembers().stream()).map(ISnowflake::getId).collect(Collectors.toSet()));
        DiscordUtil.getJda().getGuilds().stream().flatMap(guild -> guild.getMembers().stream()).filter(member -> linkedDiscords.containsKey(member.getId())).map(member -> (UUID)linkedDiscords.get(member.getId())).filter(Objects::nonNull).map(Bukkit::getOfflinePlayer).filter(Objects::nonNull).forEach(players::add);
        players.forEach(player -> this.resync((OfflinePlayer)player, direction, cause));
    }

    public void removeSynchronizables(OfflinePlayer player) {
        if (!DiscordSRV.config().getBoolean("GroupRoleSynchronizationMinecraftIsAuthoritative")) {
            Permission permission = this.getPermissions();
            ArrayList<String> fail = new ArrayList<String>();
            ArrayList<String> success = new ArrayList<String>();
            for (String group : DiscordSRV.getPlugin().getGroupSynchronizables().keySet()) {
                if (!permission.playerInGroup(null, player, group)) continue;
                if (permission.playerRemoveGroup(null, player, group)) {
                    success.add(group);
                    continue;
                }
                fail.add(group);
            }
            DiscordSRV.debug(Debug.GROUP_SYNC, player.getName() + " removed from their groups (Discord is authoritative). succeeded: " + success + ", failed: " + fail);
        } else {
            this.removeSynchronizedRoles(player);
        }
    }

    public void removeSynchronizedRoles(OfflinePlayer player) {
        String userId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
        User user = DiscordUtil.getUserById(userId);
        if (user != null) {
            HashMap<Guild, Set> roles = new HashMap<Guild, Set>();
            DiscordSRV.getPlugin().getGroupSynchronizables().values().stream().map(DiscordUtil::getRole).filter(Objects::nonNull).forEach(role -> roles.computeIfAbsent(role.getGuild(), guild -> new HashSet()).add(role));
            try {
                Role role2;
                String linkRole = DiscordSRV.config().getString("MinecraftDiscordAccountLinkedRoleNameToAddUserTo");
                Role role3 = role2 = StringUtils.isNotBlank(linkRole) ? DiscordUtil.resolveRole(linkRole) : null;
                if (role2 != null) {
                    roles.computeIfAbsent(role2.getGuild(), guild -> new HashSet()).add(role2);
                } else {
                    DiscordSRV.debug(Debug.GROUP_SYNC, "Couldn't remove user from null \"linked\" role");
                }
            }
            catch (Throwable t) {
                DiscordSRV.debug(Debug.GROUP_SYNC, "Failed to remove \"linked\" role from " + player.getName() + " during unlink: " + ExceptionUtils.getMessage(t));
            }
            for (Map.Entry entry : roles.entrySet()) {
                Guild guild2 = (Guild)entry.getKey();
                Member member = guild2.getMember(user);
                if (member == null || !guild2.getSelfMember().canInteract(member)) continue;
                DiscordUtil.removeRolesFromMember(member, (Set)entry.getValue());
            }
        }
    }

    @Override
    public void onGuildMemberJoin(@NotNull GuildMemberJoinEvent event) {
        this.membersNotInGuilds.computeIfAbsent(event.getGuild().getId(), key -> new HashSet()).remove(event.getMember().getId());
    }

    @Override
    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent event) {
        this.membersNotInGuilds.computeIfAbsent(event.getGuild().getId(), key -> new HashSet()).add(event.getUser().getId());
    }

    @Override
    public void onGuildMemberRoleAdd(@NotNull GuildMemberRoleAddEvent event) {
        this.onGuildMemberRolesChanged("add", event.getMember(), event.getRoles());
    }

    @Override
    public void onGuildMemberRoleRemove(@NotNull GuildMemberRoleRemoveEvent event) {
        this.onGuildMemberRolesChanged("remove", event.getMember(), event.getRoles());
    }

    private void onGuildMemberRolesChanged(String type, Member member, List<Role> roles) {
        Set recentlyChanged;
        Map.Entry<Guild, Map<String, Set<Role>>> entry;
        if (!DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled()) {
            return;
        }
        ArrayList<Role> checkRoles = new ArrayList<Role>(roles);
        Collection<String> validRoleIds = DiscordSRV.getPlugin().getGroupSynchronizables().values();
        checkRoles.removeIf(role -> !validRoleIds.contains(role.getId()));
        if (checkRoles.isEmpty()) {
            return;
        }
        if (this.justModifiedRoles.containsKey(member) && (entry = this.justModifiedRoles.remove(member)).getKey().equals(member.getGuild()) && (recentlyChanged = entry.getValue().getOrDefault(type, Collections.emptySet())).size() == roles.size() && recentlyChanged.containsAll(roles)) {
            return;
        }
        this.resync(member.getUser(), SyncDirection.TO_MINECRAFT, SyncCause.DISCORD_ROLE_EDIT);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onServerCommand(ServerCommandEvent event) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.checkCommand(event.getCommand()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRemoteServerCommand(RemoteServerCommandEvent event) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.checkCommand(event.getCommand()));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!GamePermissionUtil.hasPermission((Permissible)event.getPlayer(), "discordsrv.groupsyncwithcommands")) {
            return;
        }
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.checkCommand(event.getMessage()));
    }

    private void checkCommand(String message) {
        if (!DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled()) {
            return;
        }
        OfflinePlayer target = this.patterns.stream().map(pattern -> pattern.matcher(message)).filter(Matcher::find).map(matcher -> matcher.group(1)).filter(Objects::nonNull).map(input -> {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)input);
            if (offlinePlayer != null) {
                return offlinePlayer;
            }
            try {
                return Bukkit.getOfflinePlayer((UUID)UUID.fromString(input));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }).findAny().orElse(null);
        SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.resync(target, SyncDirection.TO_DISCORD, SyncCause.MINECRAFT_GROUP_EDIT_COMMAND), 5L);
    }

    public Map<UUID, Map<String, List<String>>> getJustModifiedGroups() {
        return this.justModifiedGroups;
    }

    public Permission getPermissions() {
        if (this.permission != null) {
            return this.permission;
        }
        try {
            Class.forName("net.milkbowl.vault.permission.Permission");
            RegisteredServiceProvider provider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (provider == null) {
                DiscordSRV.debug(Debug.GROUP_SYNC, "Can't access permissions: registration provider was null");
                return null;
            }
            this.permission = (Permission)provider.getProvider();
            return this.permission;
        }
        catch (ClassNotFoundException e) {
            if (!this.warnedAboutMissingVault && DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled(false)) {
                DiscordSRV.error("Group synchronization failed: Vault classes couldn't be found (did it enable properly?). Vault is required for synchronization to work.");
                this.warnedAboutMissingVault = true;
            }
            return null;
        }
    }

    public static enum SyncCause {
        DISCORD_ROLE_EDIT("Discord roles changed"),
        MINECRAFT_GROUP_EDIT_API("Minecraft group change (via api)"),
        MINECRAFT_GROUP_EDIT_COMMAND("Minecraft group change (via command)"),
        PLAYER_LINK("Player linked"),
        PLAYER_JOIN("Player joined"),
        TIMER("Timer"),
        MANUAL("Manually triggered via resync command"),
        LEGACY("Legacy (deprecated method)");

        private final String description;

        private SyncCause(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum SyncDirection {
        TO_MINECRAFT("to Minecraft"),
        TO_DISCORD("to Discord"),
        AUTHORITATIVE("on authority");

        private final String description;

        private SyncDirection(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

