/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class IncompatibleClientManager
implements PluginMessageListener,
Listener {
    private static final Method CLIENT_BRAND_NAME_METHOD;
    private final Set<UUID> incompatibleClients = new HashSet<UUID>();

    public boolean isIncompatible(Player player) {
        return this.incompatibleClients.contains(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (CLIENT_BRAND_NAME_METHOD == null) {
            return;
        }
        SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.checkBrand(event.getPlayer()), 40L);
        SchedulerUtil.runTaskLaterAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> this.checkBrand(event.getPlayer()), 200L);
    }

    private void checkBrand(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        try {
            String brand = (String)CLIENT_BRAND_NAME_METHOD.invoke((Object)player, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return;
        }
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] bytes) {
        this.checkChannel(player, channel, false);
    }

    private void checkChannel(Player player, String channel, boolean register) {
    }

    private void addIncompatible(Player player, String client) {
        if (!this.incompatibleClients.add(player.getUniqueId())) {
            return;
        }
        if (!DiscordSRV.config().getBooleanElse("EnableIncompatibleClientAlert", true)) {
            return;
        }
        player.sendMessage(ChatColor.RED + LangUtil.InternalMessage.INCOMPATIBLE_CLIENT.toString().replace("{client}", client));
        DiscordSRV.info(player.getName() + " was sent a notice for having a degraded user experience due to " + client + " (You can use EnableIncompatibleClientAlert to disable the message if you'd like (Not recommended))");
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.incompatibleClients.remove(event.getPlayer().getUniqueId());
    }

    static {
        Method method = null;
        try {
            method = Player.class.getMethod("getClientBrandName", new Class[0]);
        }
        catch (NoSuchMethodError | NoSuchMethodException throwable) {
            // empty catch block
        }
        CLIENT_BRAND_NAME_METHOD = method;
    }
}

