/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers.link;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.AccountLinkedEvent;
import github.scarsz.discordsrv.api.events.AccountUnlinkedEvent;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.objects.managers.AccountLinkManager;
import github.scarsz.discordsrv.objects.managers.GroupSynchronizationManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.PrettyUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class AbstractAccountLinkManager
implements AccountLinkManager {
    protected final Map<String, UUID> linkingCodes = new ConcurrentHashMap<String, UUID>();
    private final Set<String> nagged = new HashSet<String>();

    @Override
    public String generateCode(UUID playerUuid) {
        int code;
        String codeString;
        do {
            code = ThreadLocalRandom.current().nextInt(10000);
        } while (this.linkingCodes.putIfAbsent(codeString = String.format("%04d", code), playerUuid) != null);
        return codeString;
    }

    protected void ensureOffThread(boolean single) {
        if (!Bukkit.isPrimaryThread()) {
            return;
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        String apiUser = elements[3].toString();
        if (!this.nagged.add(apiUser)) {
            return;
        }
        if (apiUser.startsWith("github.scarsz.discordsrv")) {
            DiscordSRV.warning("Linked account data requested on main thread, please report this to DiscordSRV: " + apiUser);
            for (StackTraceElement element : elements) {
                DiscordSRV.debug(Debug.ACCOUNT_LINKING, element.toString());
            }
            return;
        }
        DiscordSRV.warning("API user " + apiUser + " requested linked account information on the main thread while MySQL is enabled in DiscordSRV's settings");
        if (single) {
            DiscordSRV.warning("Requesting data for offline players on the main thread will lead to an exception in the future, if being on the main thread is explicitly required use getDiscordIdBypassCache / getUuidBypassCache");
        } else {
            DiscordSRV.warning("Managing / Requesting bulk linked account data on the main thread will lead to an exception in the future");
        }
        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Full callstack:");
        for (StackTraceElement element : elements) {
            DiscordSRV.debug(Debug.ACCOUNT_LINKING, element.toString());
        }
    }

    protected void afterLink(String discordId, UUID uuid) {
        DiscordSRV.api.callEvent(new AccountLinkedEvent(DiscordUtil.getUserById(discordId), uuid));
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        User user = DiscordUtil.getUserById(discordId);
        for (String command : DiscordSRV.config().getStringList("MinecraftDiscordAccountLinkedConsoleCommands")) {
            DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Parsing command /" + command + " for linked commands...");
            command = command.replace("%minecraftplayername%", PrettyUtil.beautifyUsername(offlinePlayer, "[Unknown Player]", false)).replace("%minecraftdisplayname%", PrettyUtil.beautifyNickname(offlinePlayer, "[Unknown Player]", false)).replace("%minecraftuuid%", uuid.toString()).replace("%discordid%", discordId).replace("%discordname%", user != null ? user.getName() : "").replace("%discorddisplayname%", PrettyUtil.beautify(user, "", false));
            if (StringUtils.isBlank(command)) {
                DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Command was blank, skipping");
                continue;
            }
            if (PluginUtil.pluginHookIsEnabled("placeholderapi")) {
                command = PlaceholderAPI.setPlaceholders((Player)Bukkit.getPlayer((UUID)uuid), (String)command);
            }
            String finalCommand = command;
            DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Final command to be run: /" + finalCommand);
            SchedulerUtil.runTask((Plugin)DiscordSRV.getPlugin(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand));
        }
        if (DiscordSRV.config().getBoolean("GroupRoleSynchronizationOnLink") && DiscordSRV.getPlugin().getGroupSynchronizationManager().getPermissions() != null) {
            DiscordSRV.getPlugin().getGroupSynchronizationManager().resync(offlinePlayer, GroupSynchronizationManager.SyncDirection.AUTHORITATIVE, true, GroupSynchronizationManager.SyncCause.PLAYER_LINK);
        } else {
            String roleName = DiscordSRV.config().getString("MinecraftDiscordAccountLinkedRoleNameToAddUserTo");
            try {
                Role roleToAdd = DiscordUtil.resolveRole(roleName);
                if (roleToAdd != null) {
                    Member member = roleToAdd.getGuild().getMemberById(discordId);
                    if (member != null) {
                        DiscordUtil.addRoleToMember(member, roleToAdd);
                    } else {
                        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Couldn't find member for " + offlinePlayer.getName() + " in " + roleToAdd.getGuild());
                    }
                } else {
                    DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Couldn't find \"account linked\" role " + roleName + " to add to " + offlinePlayer.getName() + "'s linked Discord account");
                }
            }
            catch (Throwable t) {
                DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Couldn't add \"account linked\" role \"" + roleName + "\" due to exception: " + ExceptionUtils.getMessage(t));
            }
        }
        if (DiscordSRV.config().getBoolean("NicknameSynchronizationEnabled")) {
            DiscordSRV.getPlugin().getNicknameUpdater().setNickname(DiscordUtil.getMemberById(discordId), offlinePlayer);
        }
    }

    protected void beforeUnlink(UUID uuid, String discordId) {
        if (DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled()) {
            DiscordSRV.getPlugin().getGroupSynchronizationManager().removeSynchronizables(Bukkit.getOfflinePlayer((UUID)uuid));
        } else {
            try {
                Role role = DiscordUtil.resolveRole(DiscordSRV.config().getString("MinecraftDiscordAccountLinkedRoleNameToAddUserTo"));
                if (role != null) {
                    Member member = role.getGuild().getMemberById(discordId);
                    if (member != null) {
                        role.getGuild().removeRoleFromMember(member, role).queue();
                    } else {
                        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Couldn't remove \"linked\" role from null member: " + uuid);
                    }
                } else {
                    DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Couldn't remove user from null \"linked\" role");
                }
            }
            catch (Throwable t) {
                DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Failed to remove \"linked\" role from [" + uuid + ":" + discordId + "] during unlink: " + ExceptionUtils.getMessage(t));
            }
        }
    }

    protected void afterUnlink(UUID uuid, String discordId) {
        Player player;
        Member member = DiscordUtil.getMemberById(discordId);
        DiscordSRV.api.callEvent(new AccountUnlinkedEvent(discordId, uuid));
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        User user = DiscordUtil.getUserById(discordId);
        for (String command : DiscordSRV.config().getStringList("MinecraftDiscordAccountUnlinkedConsoleCommands")) {
            if (StringUtils.isBlank(command = command.replace("%minecraftplayername%", PrettyUtil.beautifyUsername(offlinePlayer, "[Unknown player]", false)).replace("%minecraftdisplayname%", PrettyUtil.beautifyNickname(offlinePlayer, "<Unknown name>", false)).replace("%minecraftuuid%", uuid.toString()).replace("%discordid%", discordId).replace("%discordname%", user != null ? user.getName() : "").replace("%discorddisplayname%", PrettyUtil.beautify(user, "", false)))) continue;
            if (PluginUtil.pluginHookIsEnabled("placeholderapi")) {
                command = PlaceholderAPI.setPlaceholders((Player)Bukkit.getPlayer((UUID)uuid), (String)command);
            }
            String finalCommand = command;
            SchedulerUtil.runTask((Plugin)DiscordSRV.getPlugin(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand));
        }
        if (member != null && DiscordSRV.config().getBoolean("NicknameSynchronizationEnabled")) {
            if (member.getGuild().getSelfMember().canInteract(member)) {
                member.modifyNickname(null).queue();
            } else {
                DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Can't remove nickname from " + member + ", bot is lower in hierarchy");
            }
        }
        if ((player = Bukkit.getPlayer((UUID)uuid)) != null) {
            DiscordSRV.getPlugin().getRequireLinkModule().noticePlayerUnlink(player);
        }
    }

    @Override
    public Map<String, UUID> getLinkingCodes() {
        return this.linkingCodes;
    }
}

