/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers.link;

import com.mysql.cj.jdbc.NonRegisteringDriver;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.objects.ExpiringDualHashBidiMap;
import github.scarsz.discordsrv.objects.managers.link.AbstractAccountLinkManager;
import github.scarsz.discordsrv.objects.managers.link.file.AppendOnlyFileAccountLinkManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PrettyUtil;
import github.scarsz.discordsrv.util.SQLUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.io.File;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class JdbcAccountLinkManager
extends AbstractAccountLinkManager {
    private static final Pattern JDBC_PATTERN = Pattern.compile("^(?<proto>\\w+):(?<engine>\\w+)://(?<host>.+?)(:(?<port>\\d{1,5}|PORT))?/(?<name>\\w+)\\??(?<params>.+)$");
    private static final long EXPIRY_TIME_ONLINE = TimeUnit.MINUTES.toMillis(3L);
    private final Connection connection;
    private final String database;
    private final String accountsTable;
    private final String codesTable;
    private final ExpiringDualHashBidiMap<UUID, String> cache = new ExpiringDualHashBidiMap(TimeUnit.SECONDS.toMillis(10L));
    private int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putExpiring(UUID uuid, String discordId, long expiryTime) {
        ExpiringDualHashBidiMap<UUID, String> expiringDualHashBidiMap = this.cache;
        synchronized (expiringDualHashBidiMap) {
            this.cache.putExpiring(uuid, discordId, expiryTime);
        }
    }

    public static boolean shouldUseJdbc() {
        return JdbcAccountLinkManager.shouldUseJdbc(false);
    }

    public static boolean shouldUseJdbc(boolean quiet) {
        String jdbc = DiscordSRV.config().getString("Experiment_JdbcAccountLinkBackend");
        if (StringUtils.isBlank(jdbc)) {
            return false;
        }
        try {
            Matcher matcher = JDBC_PATTERN.matcher(jdbc);
            if (!matcher.matches()) {
                if (!quiet) {
                    DiscordSRV.error("Not using JDBC because the JDBC connection string is invalid!");
                }
                return false;
            }
            if (!matcher.group("proto").equalsIgnoreCase("jdbc")) {
                if (!quiet) {
                    DiscordSRV.error("Not using JDBC because the protocol of the JDBC URL is wrong!");
                }
                return false;
            }
            String engine = matcher.group("engine");
            String host = matcher.group("host");
            String port = matcher.group("port");
            String database = matcher.group("name");
            if (!engine.equalsIgnoreCase("mysql")) {
                if (!quiet) {
                    DiscordSRV.error("Only MySQL is supported for JDBC currently, not using JDBC");
                }
                return false;
            }
            if (host.equalsIgnoreCase("host") || port.equalsIgnoreCase("port") || database.equalsIgnoreCase("database")) {
                if (!quiet) {
                    DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Not using JDBC, one of host/port/database was default");
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (!quiet) {
                DiscordSRV.error("Not using JDBC because of exception while matching parts of JDBC url: " + e.getMessage() + "\n" + ExceptionUtils.getStackTrace(e));
            }
            return false;
        }
    }

    public JdbcAccountLinkManager() throws SQLException {
        PreparedStatement statement;
        HashMap<String, String> expected;
        Connection conn;
        String jdbc = DiscordSRV.config().getString("Experiment_JdbcAccountLinkBackend");
        if (!JdbcAccountLinkManager.shouldUseJdbc(true) || StringUtils.isBlank(jdbc)) {
            throw new RuntimeException("JDBC is not wanted");
        }
        String jdbcUsername = DiscordSRV.config().getString("Experiment_JdbcUsername");
        String jdbcPassword = DiscordSRV.config().getString("Experiment_JdbcPassword");
        Properties properties = new Properties();
        if (StringUtils.isNotBlank(jdbcUsername)) {
            properties.put("user", jdbcUsername);
        }
        if (StringUtils.isNotBlank(jdbcPassword)) {
            properties.put("password", jdbcPassword);
        }
        try {
            Class.forName("com.mysql.cj.jdbc.NonRegisteringDriver");
            conn = new NonRegisteringDriver().connect(jdbc, properties);
        }
        catch (ClassNotFoundException ignored) {
            try {
                Class<?> driverClass = Class.forName("com.mysql.jdbc.Driver");
                Object driver = driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                conn = (Connection)driverClass.getMethod("connect", String.class, Properties.class).invoke(driver, jdbc, properties);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to connect with old MySQL driver", e);
            }
        }
        this.connection = conn;
        this.database = this.connection.getCatalog();
        String tablePrefix = DiscordSRV.config().getString("Experiment_JdbcTablePrefix");
        tablePrefix = StringUtils.isBlank(tablePrefix) ? "" : tablePrefix + "_";
        this.accountsTable = tablePrefix + "accounts";
        this.codesTable = tablePrefix + "codes";
        if (SQLUtil.checkIfTableExists(this.connection, this.accountsTable)) {
            expected = new HashMap<String, String>();
            expected.put("discord", "varchar(32)");
            expected.put("uuid", "varchar(36)");
            if (!SQLUtil.checkIfTableMatchesStructure(this.connection, this.accountsTable, expected)) {
                throw new SQLException("JDBC table " + this.accountsTable + " does not match expected structure");
            }
        } else {
            statement = this.connection.prepareStatement("create table " + this.accountsTable + "\n(\n    link    int auto_increment primary key,\n    discord varchar(32) not null,\n    uuid    varchar(36) not null,\n    constraint accounts_discord_uindex unique (discord),\n    constraint accounts_uuid_uindex unique (uuid)\n);");
            try {
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (SQLUtil.checkIfTableExists(this.connection, this.codesTable)) {
            expected = new HashMap();
            expected.put("code", "char(4)");
            expected.put("uuid", "varchar(36)");
            HashMap<String, String> legacyExpected = new HashMap<String, String>(expected);
            legacyExpected.put("expiration", "bigint(20)");
            expected.put("expiration", "bigint");
            if (!SQLUtil.checkIfTableMatchesStructure(this.connection, this.codesTable, expected, false) && !SQLUtil.checkIfTableMatchesStructure(this.connection, this.codesTable, legacyExpected)) {
                throw new SQLException("JDBC table " + this.codesTable + " does not match expected structure");
            }
        } else {
            statement = this.connection.prepareStatement("create table " + this.codesTable + "\n(\n    code       char(4)     not null primary key,\n    uuid       varchar(36) not null,\n    expiration bigint(20)  not null,\n    constraint codes_uuid_uindex unique (uuid)\n);");
            try {
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        DiscordSRV.info("JDBC tables passed validation, using JDBC account backend");
        SchedulerUtil.runTaskTimerAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> {
            long currentTime = System.currentTimeMillis();
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                UUID uuid = onlinePlayer.getUniqueId();
                if (this.cache.containsKey(uuid) && this.cache.getExpiryTime(uuid) - TimeUnit.SECONDS.toMillis(30L) >= currentTime) continue;
                this.putExpiring(uuid, this.getDiscordIdBypassCache(uuid), currentTime + EXPIRY_TIME_ONLINE);
            }
            try (PreparedStatement statement = this.connection.prepareStatement("select COUNT(*) as accountcount from " + this.accountsTable + ";");
                 ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    this.count = resultSet.getInt("accountcount");
                }
            }
            catch (SQLException t) {
                t.printStackTrace();
            }
        }, 1L, 200L);
    }

    public void migrateFile() {
        block13: {
            File accountsFile = new File(DiscordSRV.getPlugin().getDataFolder(), "accounts.aof");
            if (accountsFile.exists()) {
                try {
                    if (accountsFile.length() != 0L) {
                        DiscordSRV.info("linked accounts file exists and we want to use JDBC backend, importing...");
                        Map<String, UUID> accounts = new AppendOnlyFileAccountLinkManager().getLinkedAccounts();
                        File importFile = new File(accountsFile.getParentFile(), "accounts.aof.imported");
                        if (!accountsFile.renameTo(importFile)) {
                            throw new RuntimeException("Failed to move accounts file to " + importFile.getName());
                        }
                        this.connection.setAutoCommit(false);
                        for (Map.Entry<String, UUID> entry : accounts.entrySet()) {
                            String discord = entry.getKey();
                            UUID uuid = entry.getValue();
                            this.unlink(discord);
                            this.unlink(uuid);
                            PreparedStatement statement = this.connection.prepareStatement("insert into " + this.accountsTable + " (discord, uuid) VALUES (?, ?)");
                            try {
                                statement.setString(1, discord);
                                statement.setString(2, uuid.toString());
                                statement.executeUpdate();
                            }
                            finally {
                                if (statement == null) continue;
                                statement.close();
                            }
                        }
                        DiscordSRV.info("Imported " + accounts.size() + " accounts to JDBC, committing...");
                        this.connection.setAutoCommit(true);
                        DiscordSRV.info("Finished importing accounts to JDBC backend");
                        break block13;
                    }
                    if (!accountsFile.delete()) {
                        accountsFile.deleteOnExit();
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        DiscordSRV.error("Failed to import linked accounts file: " + e.getMessage());
                    }
                    DiscordSRV.error("Failed to import linked accounts file", e);
                }
            }
        }
    }

    private void dropExpiredCodes() {
        try (PreparedStatement statement = this.connection.prepareStatement("delete from " + this.codesTable + " where `expiration` < ?");){
            statement.setLong(1, System.currentTimeMillis());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
    }

    @Override
    public Map<String, UUID> getLinkingCodes() {
        this.ensureOffThread(false);
        this.dropExpiredCodes();
        HashMap<String, UUID> codes = new HashMap<String, UUID>();
        try (PreparedStatement statement = this.connection.prepareStatement("select * from " + this.codesTable);
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                codes.put(result.getString("code"), UUID.fromString(result.getString("uuid")));
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return codes;
    }

    @Override
    public Map<String, UUID> getLinkedAccounts() {
        this.ensureOffThread(false);
        HashMap<String, UUID> accounts = new HashMap<String, UUID>();
        try (PreparedStatement statement = this.connection.prepareStatement("select * from " + this.accountsTable);
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                accounts.put(result.getString("discord"), UUID.fromString(result.getString("uuid")));
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return accounts;
    }

    @Override
    public String getDiscordIdFromCache(UUID uuid) {
        return (String)this.cache.get(uuid);
    }

    @Override
    public UUID getUuidFromCache(String discordId) {
        return (UUID)this.cache.getKey(discordId);
    }

    @Override
    public String generateCode(UUID playerUuid) {
        String code;
        if (this.getLinkingCodes().values().stream().anyMatch(playerUuid::equals)) {
            try (PreparedStatement statement = this.connection.prepareStatement("delete from " + this.codesTable + " where `uuid` = ?");){
                statement.setString(1, playerUuid.toString());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                DiscordSRV.error(e);
            }
        }
        do {
            int numbers = ThreadLocalRandom.current().nextInt(10000);
            code = String.format("%04d", numbers);
        } while (this.getLinkingCodes().containsKey(code));
        try (PreparedStatement statement = this.connection.prepareStatement("insert into " + this.codesTable + " (`code`, `uuid`, `expiration`) VALUES (?, ?, ?)");){
            statement.setString(1, code);
            statement.setString(2, playerUuid.toString());
            statement.setLong(3, System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return code;
    }

    @Override
    public String process(String code, String discordId) {
        boolean alreadyLinked;
        this.ensureOffThread(false);
        String mention = DiscordUtil.getUserById(discordId).getAsMention();
        UUID existingUuid = this.getUuid(discordId);
        boolean bl = alreadyLinked = existingUuid != null;
        if (alreadyLinked) {
            if (DiscordSRV.config().getBoolean("MinecraftDiscordAccountLinkedAllowRelinkBySendingANewCode")) {
                this.unlink(discordId);
            } else {
                OfflinePlayer offlinePlayer = DiscordSRV.getPlugin().getServer().getOfflinePlayer(existingUuid);
                return LangUtil.Message.ALREADY_LINKED.toString().replace("%username%", String.valueOf(offlinePlayer.getName())).replace("%uuid%", offlinePlayer.getUniqueId().toString()).replace("%mention%", mention);
            }
        }
        code = code.replaceAll("[^0-9]", "");
        UUID uuid = this.getLinkingCodes().get(code);
        if (uuid != null) {
            this.link(discordId, uuid);
            try (PreparedStatement statement = this.connection.prepareStatement("delete from " + this.codesTable + " where `code` = ?");){
                statement.setString(1, code);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                DiscordSRV.error(e);
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            if (player.isOnline()) {
                MessageUtil.sendMessage((CommandSender)player.getPlayer(), LangUtil.Message.MINECRAFT_ACCOUNT_LINKED.toString().replace("%username%", DiscordUtil.getUserById(discordId).getName()).replace("%id%", DiscordUtil.getUserById(discordId).getId()));
            }
            return LangUtil.Message.DISCORD_ACCOUNT_LINKED.toString().replace("%name%", PrettyUtil.beautifyUsername(player, "<Unknown>", false)).replace("%displayname%", PrettyUtil.beautifyNickname(player, "<Unknown>", false)).replace("%uuid%", uuid.toString()).replace("%mention%", mention);
        }
        String reply = code.length() == 4 ? LangUtil.Message.UNKNOWN_CODE.toString() : LangUtil.Message.INVALID_CODE.toString();
        return reply.replace("%code%", code).replace("%mention%", mention);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiscordId(UUID uuid) {
        ExpiringDualHashBidiMap<UUID, String> expiringDualHashBidiMap = this.cache;
        synchronized (expiringDualHashBidiMap) {
            if (this.cache.containsKey(uuid)) {
                return (String)this.cache.get(uuid);
            }
        }
        this.ensureOffThread(true);
        String discordId = this.getDiscordIdBypassCache(uuid);
        ExpiringDualHashBidiMap<UUID, String> expiringDualHashBidiMap2 = this.cache;
        synchronized (expiringDualHashBidiMap2) {
            this.cache.put(uuid, discordId);
        }
        return discordId;
    }

    @Override
    public String getDiscordIdBypassCache(UUID uuid) {
        String discordId = null;
        try (PreparedStatement statement = this.connection.prepareStatement("select discord from " + this.accountsTable + " where uuid = ?");){
            statement.setString(1, uuid.toString());
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    discordId = result.getString("discord");
                }
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return discordId;
    }

    @Override
    public Map<UUID, String> getManyDiscordIds(Set<UUID> uuids) {
        this.ensureOffThread(false);
        HashMap<UUID, String> results = new HashMap<UUID, String>();
        try {
            Array uuidArray = this.connection.createArrayOf("varchar", uuids.toArray(new UUID[0]));
            try (PreparedStatement statement = this.connection.prepareStatement("select uuid, discord from " + this.accountsTable + " where uuid in (?)");){
                statement.setArray(1, uuidArray);
                try (ResultSet result = statement.executeQuery();){
                    while (result.next()) {
                        UUID uuid = UUID.fromString(result.getString("uuid"));
                        String discordId = result.getString("discord");
                        results.put(uuid, discordId);
                    }
                }
            }
            catch (SQLException e) {
                DiscordSRV.error(e);
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            try {
                for (UUID uuid : uuids) {
                    PreparedStatement statement = this.connection.prepareStatement("select discord from " + this.accountsTable + " where uuid = ?");
                    try {
                        statement.setString(1, uuid.toString());
                        ResultSet result = statement.executeQuery();
                        try {
                            while (result.next()) {
                                String discordId = result.getString("discord");
                                results.put(uuid, discordId);
                            }
                        }
                        finally {
                            if (result == null) continue;
                            result.close();
                        }
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
            }
            catch (SQLException e2) {
                DiscordSRV.error(e2);
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getUuid(String discordId) {
        ExpiringDualHashBidiMap<UUID, String> expiringDualHashBidiMap = this.cache;
        synchronized (expiringDualHashBidiMap) {
            if (this.cache.containsValue(discordId)) {
                return (UUID)this.cache.getKey(discordId);
            }
        }
        this.ensureOffThread(true);
        UUID uuid = this.getUuidBypassCache(discordId);
        ExpiringDualHashBidiMap<UUID, String> expiringDualHashBidiMap2 = this.cache;
        synchronized (expiringDualHashBidiMap2) {
            this.cache.put(uuid, discordId);
        }
        return uuid;
    }

    @Override
    public int getLinkedAccountCount() {
        return this.count;
    }

    @Override
    public UUID getUuidBypassCache(String discordId) {
        UUID uuid = null;
        try (PreparedStatement statement = this.connection.prepareStatement("select uuid from " + this.accountsTable + " where discord = ?");){
            statement.setString(1, discordId);
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    uuid = UUID.fromString(result.getString("uuid"));
                }
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return uuid;
    }

    @Override
    public boolean isInCache(UUID uuid) {
        return this.cache.containsKey(uuid);
    }

    @Override
    public boolean isInCache(String discordId) {
        return this.cache.containsValue(discordId);
    }

    @Override
    public Map<String, UUID> getManyUuids(Set<String> discordIds) {
        this.ensureOffThread(false);
        HashMap<String, UUID> results = new HashMap<String, UUID>();
        try {
            Array discordIdArray = this.connection.createArrayOf("varchar", discordIds.toArray(new String[0]));
            try (PreparedStatement statement = this.connection.prepareStatement("select discord, uuid from " + this.accountsTable + " where discord in (?)");){
                statement.setArray(1, discordIdArray);
                try (ResultSet result = statement.executeQuery();){
                    while (result.next()) {
                        String discordId = result.getString("discord");
                        UUID uuid = UUID.fromString(result.getString("uuid"));
                        results.put(discordId, uuid);
                    }
                }
            }
            catch (SQLException e) {
                DiscordSRV.error(e);
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            for (String discordId : discordIds) {
                try {
                    PreparedStatement statement = this.connection.prepareStatement("select uuid from " + this.accountsTable + " where discord = ?");
                    try {
                        statement.setString(1, discordId);
                        ResultSet result = statement.executeQuery();
                        try {
                            while (result.next()) {
                                UUID uuid = UUID.fromString(result.getString("uuid"));
                                results.put(discordId, uuid);
                            }
                        }
                        finally {
                            if (result == null) continue;
                            result.close();
                        }
                    }
                    finally {
                        if (statement == null) continue;
                        statement.close();
                    }
                }
                catch (SQLException e2) {
                    DiscordSRV.error(e2);
                }
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        return results;
    }

    @Override
    public void link(String discordId, UUID uuid) {
        if (discordId.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty discord id's are not allowed");
        }
        this.ensureOffThread(false);
        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "JDBC Account link: " + discordId + ": " + uuid);
        this.unlink(discordId);
        this.unlink(uuid);
        try (PreparedStatement statement = this.connection.prepareStatement("insert into " + this.accountsTable + " (discord, uuid) VALUES (?, ?)");){
            statement.setString(1, discordId);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
            this.cache.put(uuid, discordId);
            this.afterLink(discordId, uuid);
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
    }

    @Override
    public void unlink(UUID uuid) {
        this.ensureOffThread(false);
        String discord = this.getDiscordId(uuid);
        if (discord == null) {
            return;
        }
        this.beforeUnlink(uuid, discord);
        try (PreparedStatement statement = this.connection.prepareStatement("delete from " + this.accountsTable + " where `uuid` = ?");){
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        this.cache.remove(uuid);
        this.afterUnlink(uuid, discord);
    }

    @Override
    public void unlink(String discordId) {
        this.ensureOffThread(false);
        UUID uuid = this.getUuid(discordId);
        if (uuid == null) {
            return;
        }
        this.beforeUnlink(uuid, discordId);
        try (PreparedStatement statement = this.connection.prepareStatement("delete from " + this.accountsTable + " where `discord` = ?");){
            statement.setString(1, discordId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
        this.cache.removeValue(discordId);
        this.afterUnlink(uuid, discordId);
    }

    @Override
    public void save() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            DiscordSRV.error(e);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> {
            UUID uuid = event.getPlayer().getUniqueId();
            this.cache.putExpiring(uuid, this.getDiscordIdBypassCache(uuid), System.currentTimeMillis() + EXPIRY_TIME_ONLINE);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        long expiryDelay;
        long currentTime;
        UUID uuid = event.getPlayer().getUniqueId();
        if (!this.cache.containsKey(uuid)) {
            return;
        }
        long expiryTime = this.cache.getExpiryTime(uuid);
        if (expiryTime - (currentTime = System.currentTimeMillis()) > (expiryDelay = this.cache.getExpiryDelay())) {
            this.cache.setExpiryTime(uuid, currentTime + expiryDelay);
        }
    }
}

