/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers.link.file;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.collections4.bidimap.DualHashBidiMap;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.objects.managers.link.AbstractAccountLinkManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PrettyUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public abstract class AbstractFileAccountLinkManager
extends AbstractAccountLinkManager {
    final DualHashBidiMap<String, UUID> linkedAccounts = new DualHashBidiMap();

    public AbstractFileAccountLinkManager() {
        try {
            this.load();
            DiscordSRV.debug(Debug.ACCOUNT_LINKING, this.getClass().getSimpleName() + " loaded " + this.linkedAccounts.size() + " linked accounts");
        }
        catch (IOException e) {
            DiscordSRV.error("Failed to load linked accounts", e);
        }
    }

    @Override
    public boolean isInCache(UUID uuid) {
        return true;
    }

    @Override
    public boolean isInCache(String discordId) {
        return true;
    }

    @Override
    public Map<String, UUID> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Override
    public String getDiscordIdFromCache(UUID uuid) {
        return this.getDiscordId(uuid);
    }

    @Override
    public UUID getUuidFromCache(String discordId) {
        return this.getUuid(discordId);
    }

    @Override
    public int getLinkedAccountCount() {
        return this.linkedAccounts.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String process(String linkCode, String discordId) {
        String mention;
        boolean contains;
        DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            contains = this.linkedAccounts.containsKey(discordId);
        }
        User user = DiscordUtil.getUserById(discordId);
        String string = mention = user == null ? "" : user.getAsMention();
        if (contains) {
            if (DiscordSRV.config().getBoolean("MinecraftDiscordAccountLinkedAllowRelinkBySendingANewCode")) {
                this.unlink(discordId);
            } else {
                UUID uuid;
                DualHashBidiMap<String, UUID> dualHashBidiMap2 = this.linkedAccounts;
                synchronized (dualHashBidiMap2) {
                    uuid = (UUID)this.linkedAccounts.get(discordId);
                }
                OfflinePlayer offlinePlayer = DiscordSRV.getPlugin().getServer().getOfflinePlayer(uuid);
                return LangUtil.Message.ALREADY_LINKED.toString().replace("%username%", PrettyUtil.beautifyUsername(offlinePlayer, "<Unknown>", false)).replace("%uuid%", uuid.toString()).replace("%mention%", mention);
            }
        }
        if (this.linkingCodes.containsKey(linkCode = linkCode.replaceAll("[^0-9]", ""))) {
            this.link(discordId, (UUID)this.linkingCodes.get(linkCode));
            this.linkingCodes.remove(linkCode);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)this.getUuid(discordId));
            if (player.isOnline()) {
                MessageUtil.sendMessage((CommandSender)Bukkit.getPlayer((UUID)this.getUuid(discordId)), LangUtil.Message.MINECRAFT_ACCOUNT_LINKED.toString().replace("%username%", user == null ? "" : user.getName()).replace("%id%", user == null ? "" : user.getId()));
            }
            return LangUtil.Message.DISCORD_ACCOUNT_LINKED.toString().replace("%name%", PrettyUtil.beautifyUsername(player, "<Unknown>", false)).replace("%displayname%", PrettyUtil.beautifyNickname(player, "<Unknown>", false)).replace("%uuid%", this.getUuid(discordId).toString()).replace("%mention%", mention);
        }
        String reply = linkCode.length() == 4 ? LangUtil.Message.UNKNOWN_CODE.toString() : LangUtil.Message.INVALID_CODE.toString();
        return reply.replace("%code%", linkCode).replace("%mention%", mention);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiscordId(UUID uuid) {
        DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            return (String)this.linkedAccounts.getKey(uuid);
        }
    }

    @Override
    public String getDiscordIdBypassCache(UUID uuid) {
        return this.getDiscordId(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, String> getManyDiscordIds(Set<UUID> uuids) {
        HashMap<UUID, String> results = new HashMap<UUID, String>();
        for (UUID uuid : uuids) {
            String discordId;
            DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
            synchronized (dualHashBidiMap) {
                discordId = (String)this.linkedAccounts.getKey(uuid);
            }
            if (discordId == null) continue;
            results.put(uuid, discordId);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getUuid(String discordId) {
        DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            return (UUID)this.linkedAccounts.get(discordId);
        }
    }

    @Override
    public UUID getUuidBypassCache(String discordId) {
        return this.getUuid(discordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UUID> getManyUuids(Set<String> discordIds) {
        HashMap<String, UUID> results = new HashMap<String, UUID>();
        for (String discordId : discordIds) {
            UUID uuid;
            DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
            synchronized (dualHashBidiMap) {
                uuid = (UUID)this.linkedAccounts.get(discordId);
            }
            if (uuid == null) continue;
            results.put(discordId, uuid);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void link(String discordId, UUID uuid) {
        if (discordId.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty Discord IDs are not allowed");
        }
        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "File backed link: " + discordId + ": " + uuid);
        this.unlink(discordId);
        this.unlink(uuid);
        DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            this.linkedAccounts.put(discordId, uuid);
        }
        this.afterLink(discordId, uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(UUID uuid) {
        String discordId;
        DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            discordId = (String)this.linkedAccounts.getKey(uuid);
        }
        if (discordId == null) {
            return;
        }
        dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            this.beforeUnlink(uuid, discordId);
            this.linkedAccounts.removeValue(uuid);
        }
        this.afterUnlink(uuid, discordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(String discordId) {
        UUID uuid;
        DualHashBidiMap<String, UUID> dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            uuid = (UUID)this.linkedAccounts.get(discordId);
        }
        if (uuid == null) {
            return;
        }
        dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            this.beforeUnlink(uuid, discordId);
            this.linkedAccounts.remove(discordId);
        }
        this.afterUnlink(uuid, discordId);
    }

    abstract void load() throws IOException;

    abstract File getFile();
}

