/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers.link.file;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.collections4.bidimap.DualHashBidiMap;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.objects.managers.link.file.AbstractFileAccountLinkManager;
import github.scarsz.discordsrv.objects.managers.link.file.JsonFileAccountLinkManager;
import github.scarsz.discordsrv.util.LangUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppendOnlyFileAccountLinkManager
extends AbstractFileAccountLinkManager {
    private static final Pattern LINK_PATTERN = Pattern.compile("^(?<discord>\\d+) (?<uuid>[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}).*");
    private static final Pattern MODIFICATION_PATTERN = Pattern.compile("^-(?>(?>(?<discord>\\d{17,}+)|(?<uuid>[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})) ?){1,2}.*");

    @Override
    void load() throws IOException {
        this.readAOF();
        this.importJsonFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAOF() throws IOException {
        String fileContent;
        File file = this.getFile();
        if (!file.exists()) {
            File temporaryFile = this.getTemporaryFile();
            if (!temporaryFile.exists() || temporaryFile.length() <= 0L) return;
            DiscordSRV.warning("AOF linked accounts file didn't exist but the temporary one does. Did the server die while saving?");
            file = temporaryFile;
        } else if (file.length() == 0L) {
            return;
        }
        if ((fileContent = FileUtils.readFileToString(file, "UTF-8")) == null || StringUtils.isBlank(fileContent)) {
            return;
        }
        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Reading accounts.aof file...");
        String[] split = fileContent.split("\n");
        boolean clean = split[split.length - 1].equals("");
        int modifications = 0;
        for (String line : split) {
            String uuid;
            String discordId;
            Matcher matcher = LINK_PATTERN.matcher(line);
            if (matcher.matches()) {
                discordId = matcher.group("discord");
                uuid = matcher.group("uuid");
                this.linkedAccounts.put(discordId, UUID.fromString(uuid));
                continue;
            }
            matcher = MODIFICATION_PATTERN.matcher(line);
            if (matcher.matches()) {
                discordId = matcher.group("discord");
                if (discordId != null) {
                    this.linkedAccounts.remove(discordId);
                }
                if ((uuid = matcher.group("uuid")) != null) {
                    this.linkedAccounts.removeValue(UUID.fromString(uuid));
                }
                ++modifications;
                continue;
            }
            clean = false;
            DiscordSRV.error("Invalid line in linked accounts file: " + line);
        }
        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Finished reading accounts.aof file");
        if ((double)modifications / (double)split.length >= 0.1) {
            clean = false;
        }
        if (clean) return;
        this.save();
    }

    private void importJsonFile() throws IOException {
        File linkedAccountsJsonFile = new File(DiscordSRV.getPlugin().getDataFolder(), "linkedaccounts.json");
        if (linkedAccountsJsonFile.exists()) {
            JsonFileAccountLinkManager manager = new JsonFileAccountLinkManager();
            AtomicInteger count = new AtomicInteger();
            manager.linkedAccounts.forEach((discordId, uuid) -> {
                if (!this.linkedAccounts.containsKey(discordId)) {
                    this.linkedAccounts.put(discordId, uuid);
                    count.getAndIncrement();
                }
            });
            this.save();
            File newFile = new File(DiscordSRV.getPlugin().getDataFolder(), "linkedaccounts.json.delete");
            if (!linkedAccountsJsonFile.renameTo(newFile)) {
                DiscordSRV.error("Failed to rename " + linkedAccountsJsonFile.getName() + " to " + newFile.getName());
            }
            DiscordSRV.info("Migrated " + count + " linked accounts to AOF file backend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        File file = this.getFile();
        File tmpFile = this.getTemporaryFile();
        tmpFile.deleteOnExit();
        DiscordSRV.debug(Debug.ACCOUNT_LINKING, "Saving accounts.aof file...");
        long startTime = System.currentTimeMillis();
        try {
            try (FileWriter fileWriter = new FileWriter(tmpFile);
                 BufferedWriter writer = new BufferedWriter(fileWriter);){
                for (Map.Entry entry : this.linkedAccounts.entrySet()) {
                    String discordId = (String)entry.getKey();
                    UUID uuid = (UUID)entry.getValue();
                    writer.write(discordId + " " + uuid + "\n");
                }
            }
            catch (IOException e) {
                DiscordSRV.error((Object)((Object)LangUtil.InternalMessage.LINKED_ACCOUNTS_SAVE_FAILED) + ": " + e.getMessage());
                tmpFile.delete();
                return;
            }
            file.delete();
            try {
                FileUtils.moveFile(tmpFile, file);
            }
            catch (IOException e) {
                DiscordSRV.error("Failed moving accounts.aof.tmp to accounts.aof: " + e.getMessage());
            }
        }
        finally {
            tmpFile.delete();
        }
        DiscordSRV.info(LangUtil.InternalMessage.LINKED_ACCOUNTS_SAVED.toString().replace("{ms}", String.valueOf(System.currentTimeMillis() - startTime)));
    }

    @Override
    public void link(String discordId, UUID uuid) {
        super.link(discordId, uuid);
        FileUtils.writeStringToFile(this.getFile(), discordId + " " + uuid + "\n", "UTF-8", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(UUID uuid) {
        String discordId;
        DualHashBidiMap dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            discordId = (String)this.linkedAccounts.getKey(uuid);
        }
        if (discordId == null) {
            return;
        }
        dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            this.beforeUnlink(uuid, discordId);
            this.linkedAccounts.removeValue(uuid);
            FileUtils.writeStringToFile(this.getFile(), "-" + discordId + " " + uuid + "\n", "UTF-8", true);
        }
        this.afterUnlink(uuid, discordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(String discordId) {
        UUID uuid;
        DualHashBidiMap dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            uuid = (UUID)this.linkedAccounts.get(discordId);
        }
        if (uuid == null) {
            return;
        }
        dualHashBidiMap = this.linkedAccounts;
        synchronized (dualHashBidiMap) {
            this.beforeUnlink(uuid, discordId);
            this.linkedAccounts.remove(discordId);
            FileUtils.writeStringToFile(this.getFile(), "-" + discordId + " " + uuid + "\n", "UTF-8", true);
        }
        this.afterUnlink(uuid, discordId);
    }

    @Override
    File getFile() {
        return new File(DiscordSRV.getPlugin().getDataFolder(), "accounts.aof");
    }

    File getTemporaryFile() {
        return new File(DiscordSRV.getPlugin().getDataFolder(), "accounts.aof.tmp");
    }
}

