/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.managers.link.file;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.collections4.bidimap.DualHashBidiMap;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.google.gson.JsonElement;
import github.scarsz.discordsrv.dependencies.google.gson.JsonObject;
import github.scarsz.discordsrv.dependencies.google.gson.JsonSyntaxException;
import github.scarsz.discordsrv.dependencies.google.gson.stream.MalformedJsonException;
import github.scarsz.discordsrv.objects.managers.link.file.AbstractFileAccountLinkManager;
import github.scarsz.discordsrv.util.LangUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

@Deprecated
public class JsonFileAccountLinkManager
extends AbstractFileAccountLinkManager {
    @Override
    void load() throws IOException {
        JsonObject jsonObject;
        File file = this.getFile();
        if (!file.exists()) {
            return;
        }
        String fileContent = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        if (fileContent == null || StringUtils.isBlank(fileContent)) {
            fileContent = "{}";
        }
        try {
            jsonObject = DiscordSRV.getPlugin().getGson().fromJson(fileContent, JsonObject.class);
        }
        catch (Throwable t) {
            if (!(t instanceof MalformedJsonException) && !(t instanceof JsonSyntaxException) || !t.getMessage().contains("JsonPrimitive")) {
                DiscordSRV.error("Failed to load " + file.getName(), t);
                return;
            }
            jsonObject = new JsonObject();
        }
        jsonObject.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (key.isEmpty() || value.isEmpty()) {
                return;
            }
            try {
                this.linkedAccounts.put(key, UUID.fromString(value));
            }
            catch (Exception e) {
                try {
                    this.linkedAccounts.put(value, UUID.fromString(key));
                }
                catch (Exception f) {
                    DiscordSRV.warning("Failed to load " + file.getName() + " file. It's extremely recommended to delete your " + file.getName() + " file.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        long startTime = System.currentTimeMillis();
        try {
            JsonObject map = new JsonObject();
            DualHashBidiMap dualHashBidiMap = this.linkedAccounts;
            synchronized (dualHashBidiMap) {
                this.linkedAccounts.forEach((discordId, uuid) -> map.addProperty((String)discordId, String.valueOf(uuid)));
            }
            FileUtils.writeStringToFile(this.getFile(), map.toString(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            DiscordSRV.error((Object)((Object)LangUtil.InternalMessage.LINKED_ACCOUNTS_SAVE_FAILED) + ": " + e.getMessage());
            return;
        }
        DiscordSRV.info(LangUtil.InternalMessage.LINKED_ACCOUNTS_SAVED.toString().replace("{ms}", String.valueOf(System.currentTimeMillis() - startTime)));
    }

    @Override
    File getFile() {
        return new File(DiscordSRV.getPlugin().getDataFolder(), "linkedaccounts.json");
    }
}

