/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.proxy;

import dev.vankka.dynamicproxy.DynamicProxy;
import github.scarsz.discordsrv.dependencies.jda.api.events.message.guild.GuildMessageReceivedEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.ComponentLike;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import github.scarsz.discordsrv.util.DiscordChatChannelCommandFeedbackForwarder;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandSenderDynamicProxy {
    private final CommandSender original;
    private final DiscordChatChannelCommandFeedbackForwarder sendUtil;
    private static final DynamicProxy $DYNAMICPROXY = new DynamicProxy(CommandSenderDynamicProxy.class);
    private CommandSender $PROXY = null;

    public CommandSenderDynamicProxy(CommandSender original, GuildMessageReceivedEvent event) {
        this.original = original;
        this.sendUtil = new DiscordChatChannelCommandFeedbackForwarder(event);
    }

    private void doSend(String message) {
        this.sendUtil.send(message);
    }

    private void doSend(ComponentLike componentLike) {
        this.doSend(BukkitComponentSerializer.legacy().serialize(componentLike.asComponent()));
    }

    public void sendMessage(@NotNull String s) {
        this.original.sendMessage(s);
        this.doSend(s);
    }

    public void sendMessage(@NotNull String[] strings) {
        this.original.sendMessage(strings);
        for (String string : strings) {
            this.doSend(string);
        }
    }

    public void sendMessage(@Nullable UUID uuid, @NotNull String s) {
        this.original.sendMessage(s);
        this.doSend(s);
    }

    public void sendMessage(@Nullable UUID uuid, @NotNull String[] strings) {
        this.original.sendMessage(strings);
        for (String string : strings) {
            this.doSend(string);
        }
    }

    public void sendMessage(BaseComponent ... components) {
        this.original.sendMessage(components);
        this.doSend(BungeeComponentSerializer.get().deserialize(components));
    }

    public void sendMessage(@NotNull BaseComponent component) {
        this.original.sendMessage(component);
        this.doSend(BungeeComponentSerializer.get().deserialize(new BaseComponent[]{component}));
    }

    public final CommandSender getProxy() {
        if (this.original == null) {
            throw new NullPointerException("original");
        }
        return this.$PROXY != null ? this.$PROXY : (this.$PROXY = (CommandSender)$DYNAMICPROXY.make(this.original, this));
    }
}

