/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.threads;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import java.util.concurrent.TimeUnit;

public class ChannelTopicUpdater
extends Thread {
    public ChannelTopicUpdater() {
        this.setName("DiscordSRV - Channel Topic Updater");
    }

    @Override
    public void run() {
        while (true) {
            int rate;
            if ((rate = DiscordSRV.config().getInt("ChannelTopicUpdaterRateInMinutes")) < 10) {
                rate = 10;
            }
            if (DiscordUtil.getJda() != null) {
                String consoleTopic;
                String chatTopic = PlaceholderUtil.replaceChannelUpdaterPlaceholders(LangUtil.Message.CHAT_CHANNEL_TOPIC.toString());
                if (StringUtils.isNotBlank(chatTopic)) {
                    DiscordUtil.setTextChannelTopic(DiscordSRV.getPlugin().getMainTextChannel(), chatTopic);
                }
                if (StringUtils.isNotBlank(consoleTopic = PlaceholderUtil.replaceChannelUpdaterPlaceholders(LangUtil.Message.CONSOLE_CHANNEL_TOPIC.toString()))) {
                    DiscordUtil.setTextChannelTopic(DiscordSRV.getPlugin().getConsoleChannel(), consoleTopic);
                }
            } else {
                DiscordSRV.debug("Skipping channel topic update cycle, JDA was null");
            }
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(rate));
            }
            catch (InterruptedException e) {
                DiscordSRV.debug("Broke from Channel Topic Updater thread: sleep interrupted");
                return;
            }
        }
    }
}

