/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.threads;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public class ChannelUpdater
extends Thread {
    private final Set<UpdaterChannel> updaterChannels = new HashSet<UpdaterChannel>();

    public ChannelUpdater() {
        this.setName("DiscordSRV - Channel Updater");
    }

    public void reload() {
        this.updaterChannels.clear();
        List configEntries = (List)DiscordSRV.config().get("ChannelUpdater");
        for (Map configEntry : configEntries) {
            int interval;
            Dynamic map = Dynamic.from(configEntry);
            String channelId = map.get("ChannelId").maybe().asString().orElse("");
            String format = map.get("Format").maybe().asString().orElse("");
            Optional<Integer> optionalInteger = map.get("UpdateInterval").maybe().as(Integer.class);
            String shutdownFormat = map.get("ShutdownFormat").maybe().asString().orElse("");
            if (channelId.equals("0000000000000000")) continue;
            if (StringUtils.isAnyBlank(channelId, format)) {
                DiscordSRV.debug(Debug.CHANNEL_UPDATER, "Failed to initialise a ChannelUpdater entry: Missing either ChannelId or Format");
                continue;
            }
            if (optionalInteger.isPresent()) {
                interval = optionalInteger.get();
            } else {
                DiscordSRV.warning("Update interval in minutes provided for Updater Channel " + channelId + " was blank or invalid, using the minimum value of 10");
                interval = 10;
            }
            GuildChannel channel = DiscordUtil.getJda().getGuildChannelById(channelId);
            if (channel == null) {
                DiscordSRV.error("ChannelUpdater entry " + channelId + " has an invalid id");
                continue;
            }
            DiscordSRV.debug(Debug.CHANNEL_UPDATER, "Initialising ChannelUpdater entry " + channelId);
            UpdaterChannel updaterChannel = new UpdaterChannel(channel, format, interval, shutdownFormat);
            this.updaterChannels.add(updaterChannel);
            updaterChannel.update();
        }
    }

    @Override
    public void run() {
        this.reload();
        for (UpdaterChannel channel : this.updaterChannels) {
            channel.update();
        }
        try {
            block3: while (true) {
                Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
                Iterator<UpdaterChannel> iterator = this.updaterChannels.iterator();
                while (true) {
                    UpdaterChannel channel;
                    if (!iterator.hasNext()) continue block3;
                    channel = iterator.next();
                    channel.performTick();
                }
                break;
            }
        }
        catch (InterruptedException e) {
            DiscordSRV.debug(Debug.CHANNEL_UPDATER, "Broke from Channel Updater thread: sleep interrupted");
            return;
        }
    }

    public Set<UpdaterChannel> getUpdaterChannels() {
        return this.updaterChannels;
    }

    public static class UpdaterChannel {
        public static final int MAX_CHANNEL_NAME = 100;
        private final String channelId;
        private final String format;
        private final int interval;
        @Nullable
        private final String shutdownFormat;
        private int minutesUntilRefresh;

        public UpdaterChannel(GuildChannel channel, String format, int interval, @Nullable String shutdownFormat) {
            this.channelId = channel.getId();
            this.format = format;
            this.shutdownFormat = shutdownFormat;
            if (interval < 10) {
                DiscordSRV.warning("Update interval in minutes for channel \"" + channel.getName() + "\" was below the minimum value of 10. Using 10 as the interval.");
                this.interval = 10;
            } else {
                this.interval = interval;
            }
            this.minutesUntilRefresh = this.interval;
        }

        public void update() {
            GuildChannel discordChannel = DiscordUtil.getJda().getGuildChannelById(this.channelId);
            if (discordChannel == null) {
                DiscordSRV.error(String.format("Failed to find channel \"%s\". Does it exist?", this.channelId));
                return;
            }
            String newName = PlaceholderUtil.replaceChannelUpdaterPlaceholders(this.format);
            this.parseChannelName(discordChannel, newName, false);
        }

        public void updateToShutdownFormat() {
            GuildChannel discordChannel;
            if (this.shutdownFormat == null) {
                return;
            }
            GuildChannel guildChannel = discordChannel = StringUtils.isNotBlank(this.channelId) && StringUtils.isNumeric(this.channelId) ? DiscordUtil.getJda().getGuildChannelById(this.channelId) : null;
            if (discordChannel == null) {
                DiscordSRV.error(String.format("Failed to find channel \"%s\". Does it exist?", this.channelId));
                return;
            }
            String newName = this.shutdownFormat.replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%serverversion%", Bukkit.getBukkitVersion()).replace("%totalplayers%", Integer.toString(DiscordSRV.getTotalPlayerCount())).replace("%timestamp%", Long.toString(System.currentTimeMillis() / 1000L));
            this.parseChannelName(discordChannel, newName, true);
        }

        public void performTick() {
            --this.minutesUntilRefresh;
            if (this.minutesUntilRefresh <= 0) {
                this.update();
                this.minutesUntilRefresh = this.interval;
            }
        }

        private void parseChannelName(GuildChannel discordChannel, String newName, boolean blockThread) {
            if (newName.length() > 100) {
                newName = newName.substring(0, 99);
                DiscordSRV.debug(Debug.CHANNEL_UPDATER, "The new channel name for \"" + discordChannel.getName() + "\" was too long. Reducing it to " + 100 + " characters...");
                if (StringUtils.isBlank(newName)) {
                    DiscordSRV.debug(Debug.CHANNEL_UPDATER, "The new channel name for `\"" + discordChannel.getName() + "\" was blank, skipping...");
                    return;
                }
            }
            DiscordUtil.setChannelName(discordChannel, newName, blockThread);
        }

        public String getChannelId() {
            return this.channelId;
        }

        public String getFormat() {
            return this.format;
        }

        public int getInterval() {
            return this.interval;
        }

        @Nullable
        public String getShutdownFormat() {
            return this.shutdownFormat;
        }
    }
}

