/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.threads;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorResponseException;
import github.scarsz.discordsrv.dependencies.jda.api.requests.ErrorResponse;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class NicknameUpdater
extends Thread {
    private final Set<String> nonMembers = new HashSet<String>();

    public NicknameUpdater() {
        this.setName("DiscordSRV - Nickname Updater");
    }

    @Override
    public void run() {
        while (true) {
            int rate;
            if ((rate = DiscordSRV.config().getInt("NicknameSynchronizationCycleTime")) < 3) {
                rate = 3;
            }
            if (DiscordSRV.config().getBoolean("NicknameSynchronizationEnabled")) {
                DiscordSRV.debug(Debug.NICKNAME_SYNC, "Synchronizing nicknames...");
                if (!DiscordSRV.isReady) {
                    try {
                        Thread.sleep(TimeUnit.MINUTES.toMillis(rate));
                    }
                    catch (InterruptedException ignored) {
                        DiscordSRV.debug(Debug.NICKNAME_SYNC, "Broke from Nickname Updater thread: sleep interrupted");
                        return;
                    }
                }
                Guild guild = DiscordSRV.getPlugin().getMainGuild();
                for (Player onlinePlayer : PlayerUtil.getOnlinePlayers()) {
                    Member member;
                    String playerName = onlinePlayer.getName();
                    if (PlayerUtil.isVanished(onlinePlayer)) {
                        DiscordSRV.debug(Debug.NICKNAME_SYNC, playerName + " is vanished, not setting nickname");
                        continue;
                    }
                    String userId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(onlinePlayer.getUniqueId());
                    if (userId == null) {
                        DiscordSRV.debug(Debug.NICKNAME_SYNC, playerName + " isn't linked, not setting nickname");
                        continue;
                    }
                    User linkedUser = DiscordUtil.getJda().getUserById(userId);
                    if (linkedUser == null) {
                        DiscordSRV.debug(Debug.NICKNAME_SYNC, "Could not resolve a valid Discord user for " + playerName + ", not setting nickname");
                        continue;
                    }
                    if (guild.getMember(linkedUser) != null) {
                        this.nonMembers.remove(linkedUser.getId());
                    }
                    if (this.nonMembers.contains(linkedUser.getId())) {
                        DiscordSRV.debug(Debug.NICKNAME_SYNC, linkedUser.getName() + " is not in the Main guild, not setting nickname");
                        continue;
                    }
                    try {
                        member = guild.retrieveMember(linkedUser, false).complete();
                    }
                    catch (ErrorResponseException e) {
                        if (e.getErrorResponse() == ErrorResponse.UNKNOWN_MEMBER) {
                            this.nonMembers.add(linkedUser.getId());
                            continue;
                        }
                        throw e;
                    }
                    if (member == null) {
                        DiscordSRV.debug(Debug.NICKNAME_SYNC, linkedUser.getName() + " is not in the Main guild, not setting nickname");
                        continue;
                    }
                    this.setNickname(member, (OfflinePlayer)onlinePlayer);
                }
            }
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(rate));
            }
            catch (InterruptedException ignored) {
                DiscordSRV.debug(Debug.NICKNAME_SYNC, "Broke from Nickname Updater thread: sleep interrupted");
                return;
            }
        }
    }

    public void setNickname(Member member, OfflinePlayer offlinePlayer) {
        String nickname;
        if (member == null) {
            return;
        }
        if (offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            if (!player.hasPermission("discordsrv.nicknamesync")) {
                DiscordSRV.debug(Debug.NICKNAME_SYNC, "Not syncing nicknames for " + player.getName() + " because they do not have the discordsrv.nicknamesync permission.");
                return;
            }
            DiscordSRV.debug(Debug.NICKNAME_SYNC, "Syncing nickname for " + player.getName());
            nickname = DiscordSRV.config().getString("NicknameSynchronizationFormat").replace("%displayname%", player.getDisplayName() != null ? player.getDisplayName() : player.getName()).replace("%username%", player.getName()).replace("%discord_name%", member.getUser().getName()).replace("%discord_discriminator%", member.getUser().getDiscriminator());
            nickname = PlaceholderUtil.replacePlaceholders(nickname, (OfflinePlayer)player);
        } else {
            nickname = offlinePlayer.getName();
        }
        nickname = MessageUtil.strip(nickname);
        if (nickname.length() > 32) {
            DiscordSRV.debug(Debug.NICKNAME_SYNC, "The new nickname for " + offlinePlayer.getName() + " (" + nickname + ") is too long, reducing it to 32 characters.");
            nickname = nickname.substring(0, 32);
        }
        DiscordUtil.setNickname(member, nickname);
    }
}

