/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.threads;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.OnlineStatus;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Activity;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class PresenceUpdater
extends Thread {
    private int lastStatusIndex = 0;
    private String lastStatus = null;
    private OnlineStatus lastOnlineStatus = null;

    public PresenceUpdater() {
        this.setName("DiscordSRV - Presence Updater");
    }

    @Override
    public void run() {
        while (true) {
            int rate;
            if ((rate = DiscordSRV.config().getInt("StatusUpdateRateInMinutes")) < 1) {
                rate = 1;
            }
            if (DiscordUtil.getJda() != null) {
                String onlineStatusString;
                OnlineStatus onlineStatus;
                String status;
                Dynamic dynamic = DiscordSRV.config().dget("DiscordGameStatus");
                LinkedList<Object> statuses = new LinkedList<Object>();
                if (dynamic.isList()) {
                    statuses.addAll(dynamic.asList());
                } else {
                    statuses.add(dynamic.convert().intoString());
                }
                if (statuses.size() == 0) {
                    status = null;
                } else {
                    int nextStatusIndex = this.lastStatusIndex + 1;
                    if (nextStatusIndex >= statuses.size()) {
                        nextStatusIndex = 0;
                    }
                    status = statuses.size() >= nextStatusIndex + 1 ? (String)statuses.get(nextStatusIndex) : null;
                    this.lastStatusIndex = nextStatusIndex;
                }
                if (status != null) {
                    status = status.replace("%online%", String.valueOf(PlayerUtil.getOnlinePlayers(true).size()));
                    status = PlaceholderUtil.replacePlaceholders(status);
                    status = MessageUtil.strip(status);
                }
                if ((onlineStatus = OnlineStatus.fromKey(onlineStatusString = DiscordSRV.config().getString("DiscordOnlineStatus").toUpperCase(Locale.ROOT).trim())) == OnlineStatus.UNKNOWN) {
                    onlineStatus = OnlineStatus.ONLINE;
                }
                boolean same = Objects.equals(this.lastStatus, status) && Objects.equals((Object)onlineStatus, (Object)this.lastOnlineStatus);
                this.lastStatus = status;
                this.lastOnlineStatus = onlineStatus;
                if (!same) {
                    if (StringUtils.isNotBlank(status)) {
                        String removed;
                        DiscordSRV.debug(Debug.PRESENCE, "Setting presence to \"" + status + "\" and online status to \"" + onlineStatus.name() + "\"");
                        if (StringUtils.startsWithIgnoreCase(status, "watching")) {
                            removed = status.substring("watching".length()).trim();
                            DiscordUtil.getJda().getPresence().setPresence(onlineStatus, Activity.watching(removed), false);
                        } else if (StringUtils.startsWithIgnoreCase(status, "listening to")) {
                            removed = status.substring("listening to".length()).trim();
                            DiscordUtil.getJda().getPresence().setPresence(onlineStatus, Activity.listening(removed), false);
                        } else if (StringUtils.startsWithIgnoreCase(status, "playing")) {
                            removed = status.substring("playing".length()).trim();
                            DiscordUtil.getJda().getPresence().setPresence(onlineStatus, Activity.playing(removed), false);
                        } else if (StringUtils.startsWithIgnoreCase(status, "competing")) {
                            removed = status.substring("competing".length()).trim();
                            DiscordUtil.getJda().getPresence().setPresence(onlineStatus, Activity.competing(removed), false);
                        } else {
                            DiscordUtil.getJda().getPresence().setPresence(onlineStatus, Activity.customStatus(status), false);
                        }
                    } else {
                        DiscordUtil.getJda().getPresence().setPresence(onlineStatus, null, false);
                        DiscordSRV.debug(Debug.PRESENCE, "Cleared presence status");
                    }
                }
            } else {
                DiscordSRV.debug(Debug.PRESENCE, "Skipping presence status update cycle, JDA was null");
            }
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(rate));
            }
            catch (InterruptedException ignored) {
                DiscordSRV.debug(Debug.PRESENCE, "Broke from Status Updater thread: sleep interrupted");
                return;
            }
        }
    }
}

