/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.objects.threads;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.events.WatchdogMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.WatchdogMessagePreProcessEvent;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ServerWatchdog
extends Thread {
    private long lastTick = System.currentTimeMillis();
    private boolean hasBeenTriggered = true;

    public ServerWatchdog() {
        super("DiscordSRV - Server Watchdog");
    }

    private void tick() {
        this.lastTick = System.currentTimeMillis();
        this.hasBeenTriggered = false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        taskNumber = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DiscordSRV.getPlugin(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, tick(), ()V)((ServerWatchdog)this), 0L, 20L);
        if (taskNumber == -1) {
            DiscordSRV.debug(Debug.WATCHDOG, "Failed to schedule repeating task for server watchdog; returning");
            return;
        }
        try {
            block2: while (true) {
                if ((timeout = DiscordSRV.config().getInt("ServerWatchdogTimeout")) < 10) {
                    timeout = 10;
                }
                if (this.hasBeenTriggered || TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastTick) < (long)timeout) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.hasBeenTriggered = true;
                if (!DiscordSRV.config().getBoolean("ServerWatchdogEnabled")) {
                    DiscordSRV.debug(Debug.WATCHDOG, "The Server Watchdog would have triggered right now but it was disabled in the config");
                    continue;
                }
                channelName = DiscordSRV.getPlugin().getOptionalChannel("watchdog");
                preEvent = DiscordSRV.api.callEvent(new WatchdogMessagePreProcessEvent(channelName, message = PlaceholderUtil.replacePlaceholdersToDiscord(LangUtil.Message.SERVER_WATCHDOG.toString()), count = DiscordSRV.config().getInt("ServerWatchdogMessageCount"), false));
                if (preEvent.isCancelled()) {
                    DiscordSRV.debug(Debug.WATCHDOG, "WatchdogMessagePreProcessEvent was cancelled, message send aborted");
                    continue;
                }
                count = preEvent.getCount();
                channelName = preEvent.getChannel();
                postEvent = DiscordSRV.api.callEvent(new WatchdogMessagePostProcessEvent(channelName, discordMessage = (message = preEvent.getMessage()).replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%timestamp%", Long.toString(System.currentTimeMillis() / 1000L)).replace("%timeout%", Integer.toString(timeout)).replace("%guildowner%", DiscordSRV.getPlugin().getMainGuild().getOwner().getAsMention()), count, false));
                if (postEvent.isCancelled()) {
                    DiscordSRV.debug(Debug.WATCHDOG, "WatchdogMessagePostProcessEvent was cancelled, message send aborted");
                    continue;
                }
                count = postEvent.getCount();
                channelName = postEvent.getChannel();
                discordMessage = postEvent.getProcessedMessage();
                channel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channelName);
                i = 0;
                while (true) {
                    if (i < count) ** break;
                    continue block2;
                    DiscordUtil.queueMessage(channel, discordMessage, true);
                    ++i;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            DiscordSRV.debug(Debug.WATCHDOG, "Broke from Server Watchdog thread: sleep interrupted");
            return;
        }
    }
}

