/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.util;

import github.scarsz.configuralize.ParseException;
import github.scarsz.configuralize.Provider;
import github.scarsz.configuralize.Source;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.dependencies.zafarkhaja.semver.Version;
import github.scarsz.discordsrv.util.DebugUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigUtil {
    public static void migrate() {
        Version pluginVersion;
        String pluginVersionRaw;
        String configVersionRaw = DiscordSRV.config().getString("ConfigVersion");
        if (configVersionRaw.contains("/")) {
            configVersionRaw = configVersionRaw.substring(0, configVersionRaw.indexOf("/"));
        }
        if (configVersionRaw.contains("${version}") || configVersionRaw.contains("${project.version}")) {
            configVersionRaw = "0.0.0";
        }
        if (configVersionRaw.equals(pluginVersionRaw = DiscordSRV.getPlugin().getDescription().getVersion())) {
            return;
        }
        Version configVersion = configVersionRaw.split("\\.").length == 3 ? Version.valueOf(configVersionRaw.replace("-SNAPSHOT", "")) : Version.valueOf("1." + configVersionRaw.replace("-SNAPSHOT", ""));
        if (configVersion.equals(pluginVersion = Version.valueOf(pluginVersionRaw.replace("-SNAPSHOT", "")))) {
            return;
        }
        if (configVersion.greaterThan(pluginVersion)) {
            DiscordSRV.warning("You're attempting to use a higher config version than the plugin. Things probably won't work correctly.");
            return;
        }
        String oldVersionName = configVersion.getMajorVersion() == 0 ? "invalidversion" : configVersion.toString();
        DiscordSRV.info("Your DiscordSRV config file was outdated; attempting migration...");
        try {
            Provider configProvider = DiscordSRV.config().getProvider("config");
            Provider messageProvider = DiscordSRV.config().getProvider("messages");
            Provider voiceProvider = DiscordSRV.config().getProvider("voice");
            Provider linkingProvider = DiscordSRV.config().getProvider("linking");
            Provider synchronizationProvider = DiscordSRV.config().getProvider("synchronization");
            Provider alertsProvider = DiscordSRV.config().getProvider("alerts");
            ConfigUtil.migrate("config.yml-build." + oldVersionName + ".old", DiscordSRV.getPlugin().getConfigFile(), configProvider);
            ConfigUtil.migrate("messages.yml-build." + oldVersionName + ".old", DiscordSRV.getPlugin().getMessagesFile(), messageProvider);
            ConfigUtil.migrate("voice.yml-build." + oldVersionName + ".old", DiscordSRV.getPlugin().getVoiceFile(), voiceProvider);
            ConfigUtil.migrate("linking.yml-build." + oldVersionName + ".old", DiscordSRV.getPlugin().getLinkingFile(), linkingProvider);
            ConfigUtil.migrate("synchronization.yml-build." + oldVersionName + ".old", DiscordSRV.getPlugin().getSynchronizationFile(), synchronizationProvider);
            ConfigUtil.migrate("alerts.yml-build." + oldVersionName + ".old", DiscordSRV.getPlugin().getAlertsFile(), alertsProvider);
            DiscordSRV.info("Successfully migrated configuration files to version " + pluginVersionRaw);
        }
        catch (Exception e) {
            DiscordSRV.error("Failed migrating configs: " + e.getMessage());
            DiscordSRV.debug(ExceptionUtils.getStackTrace(e));
        }
    }

    private static void migrate(String fromFileName, File to, Provider provider) throws IOException, ParseException {
        File from = new File(DiscordSRV.getPlugin().getDataFolder(), fromFileName);
        if (from.exists()) {
            from = new File(DiscordSRV.getPlugin().getDataFolder(), fromFileName + "-" + System.currentTimeMillis());
        }
        FileUtils.moveFile(to, from);
        provider.saveDefaults();
        List oldConfigLines = Arrays.stream(FileUtils.readFileToString(from, StandardCharsets.UTF_8).split(System.lineSeparator() + "|\n")).collect(Collectors.toList());
        List newConfigLines = Arrays.stream(FileUtils.readFileToString(to, StandardCharsets.UTF_8).split(System.lineSeparator() + "|\n")).collect(Collectors.toList());
        HashMap<String, String> options = new HashMap<String, String>();
        String option = null;
        StringBuilder optionValue = null;
        StringBuilder buffer = new StringBuilder();
        for (String line : oldConfigLines) {
            String[] lineSplit;
            boolean blank = StringUtils.isBlank(line);
            if (line.startsWith("#") || blank && option == null) continue;
            if (blank || line.startsWith("}")) {
                if (optionValue == null) continue;
                optionValue.append(line);
                buffer.append('\n');
                continue;
            }
            if (StringUtils.isBlank(line.substring(0, 1))) {
                if (optionValue == null) continue;
                optionValue.append((CharSequence)buffer).append('\n').append(line);
                buffer.setLength(0);
                continue;
            }
            if (option != null) {
                options.put(option, optionValue.toString());
                option = null;
                buffer.setLength(0);
            }
            if ((lineSplit = line.split(":", 2)).length != 2) {
                if (optionValue == null) continue;
                optionValue.append('\n').append(line);
                continue;
            }
            String key = lineSplit[0].trim();
            if (key.equals("ConfigVersion")) continue;
            option = key;
            String value = lineSplit[1].trim();
            if (option.equals("AvatarUrl") && value.contains("https://crafatar.com")) {
                DiscordSRV.warning("AvatarUrl config option contained \"https://crafatar.com\"; Crafatar no longer allows queries from Discord so the new default provider will be used instead.");
                value = "\"\"";
            } else if (option.equals("ProxyHost") && value.equals("\"https://example.com\"")) {
                value = "\"example.com\"";
            }
            optionValue = new StringBuilder(value);
        }
        if (optionValue != null) {
            options.put(option, optionValue.toString());
        }
        StringBuilder newConfig = new StringBuilder();
        boolean sameOption = false;
        StringBuilder comments = new StringBuilder();
        for (String line : newConfigLines) {
            String[] lineSplit;
            if (StringUtils.isBlank(line) || line.startsWith("#")) {
                comments.append(line).append('\n');
                continue;
            }
            if (sameOption) {
                if (StringUtils.isBlank(line.substring(0, 1))) continue;
                newConfig.append(option).append(": ").append((String)options.get(option)).append('\n').append((CharSequence)comments);
                comments.setLength(0);
                sameOption = false;
            }
            if ((lineSplit = line.split(":", 2)).length != 2) continue;
            newConfig.append((CharSequence)comments);
            comments.setLength(0);
            String key = lineSplit[0];
            if (!options.containsKey(key)) {
                newConfig.append(line).append('\n');
                continue;
            }
            option = key;
            DiscordSRV.debug("Migrating config option " + option + " with value " + (DebugUtil.SENSITIVE_OPTIONS.stream().anyMatch(option::equalsIgnoreCase) ? "OMITTED" : (String)options.get(option)) + " to new config");
            sameOption = true;
        }
        if (option != null) {
            newConfig.append(option).append(": ").append((String)options.get(option));
        }
        newConfig.append((CharSequence)comments);
        FileUtils.writeStringToFile(to, newConfig.toString(), StandardCharsets.UTF_8);
        provider.load();
    }

    public static void logMissingOptions() {
        for (Map.Entry<Source, Provider> entry : DiscordSRV.config().getSources().entrySet()) {
            Set<String> keys;
            try {
                keys = ConfigUtil.getAllKeys(entry.getValue().getDefaults().asMap());
                keys.removeAll(ConfigUtil.getAllKeys(entry.getValue().getValues().asMap()));
            }
            catch (Throwable t) {
                DiscordSRV.error("Failed to check " + entry.getKey().getResourceName() + " for missing options, is it broken?", t);
                continue;
            }
            for (String missing : keys) {
                if (missing.contains(".")) continue;
                DiscordSRV.warning("Config key " + missing + " is missing from the " + entry.getKey().getResourceName() + ".yml. Using the default value of " + entry.getValue().getDefaults().dget(missing).asObject());
            }
        }
    }

    public static Set<String> getAllKeys(Map<String, Object> map) {
        return ConfigUtil.getAllKeys(map, null);
    }

    public static Set<String> getAllKeys(Map<String, Object> map, String prefix) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = (prefix != null ? prefix + "." : "") + entry.getKey();
            keys.add(key);
            if (!(entry.getValue() instanceof Map)) continue;
            keys.addAll(ConfigUtil.getAllKeys((Map)entry.getValue(), key));
        }
        return keys;
    }
}

